/**
 * ./src/classes/xdg.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Xdg: xdg-user-dirs, etc
 * @remarks all the utilities
 */
export default class Xdg {
    /**
     *
     * @param olduser
     * @param newuser
     * @param chroot
     */
    /**
     * Forza l'autologin per il nuovo utente (live) su diversi Display Manager
     * @param newuser Nome dell'utente live da loggare automaticamente
     * @param chroot Percorso della root (default '/')
     */
    static autologin(newuser: string, chroot?: string): Promise<void>;
    /**
     *
     * @param user
     * @param chroot
     * @param verbose
     */
    static create(user: string, chroot: string, traduce?: boolean, verbose?: boolean): Promise<void>;
    /**
     *
     * @param chroot
     * @param path
     * @param verbose
     */
    static mk(chroot: string, path: string, verbose?: boolean): Promise<void>;
    /**
     * Copia della configurazione in /etc/skel
     * @param user
     * @param verbose
     */
    static skel(user: string, verbose?: boolean): Promise<void>;
    /**
     *
     * @param xdg_dir
     */
    static traduce(xdg_dir?: string, traduce?: boolean): string;
}
