
#ifndef PURPOSE_EXPORT_H
#define PURPOSE_EXPORT_H

#ifdef PURPOSE_STATIC_DEFINE
#  define PURPOSE_EXPORT
#  define PURPOSE_NO_EXPORT
#else
#  ifndef PURPOSE_EXPORT
#    ifdef KF6Purpose_EXPORTS
        /* We are building this library */
#      define PURPOSE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PURPOSE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PURPOSE_NO_EXPORT
#    define PURPOSE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PURPOSE_DECL_DEPRECATED
#  define PURPOSE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PURPOSE_DECL_DEPRECATED_EXPORT
#  define PURPOSE_DECL_DEPRECATED_EXPORT PURPOSE_EXPORT PURPOSE_DECL_DEPRECATED
#endif

#ifndef PURPOSE_DECL_DEPRECATED_NO_EXPORT
#  define PURPOSE_DECL_DEPRECATED_NO_EXPORT PURPOSE_NO_EXPORT PURPOSE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PURPOSE_NO_DEPRECATED
#    define PURPOSE_NO_DEPRECATED
#  endif
#endif
#include <purpose_version.h>

#define PURPOSE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(PURPOSE_NO_DEPRECATED) && !defined(PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define PURPOSE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(PURPOSE_NO_DEPRECATED_WARNINGS) && !defined(PURPOSE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define PURPOSE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define PURPOSE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(PURPOSE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define PURPOSE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(PURPOSE_NO_DEPRECATED)
#  undef PURPOSE_DEPRECATED
#  define PURPOSE_DEPRECATED_EXPORT PURPOSE_EXPORT
#  define PURPOSE_DEPRECATED_NO_EXPORT PURPOSE_NO_EXPORT
#elif defined(PURPOSE_NO_DEPRECATED_WARNINGS)
#  define PURPOSE_DEPRECATED
#  define PURPOSE_DEPRECATED_EXPORT PURPOSE_EXPORT
#  define PURPOSE_DEPRECATED_NO_EXPORT PURPOSE_NO_EXPORT
#else
#  define PURPOSE_DEPRECATED PURPOSE_DECL_DEPRECATED
#  define PURPOSE_DEPRECATED_EXPORT PURPOSE_DECL_DEPRECATED_EXPORT
#  define PURPOSE_DEPRECATED_NO_EXPORT PURPOSE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PURPOSE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PURPOSE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PURPOSE_NO_DEPRECATED
#  define PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT PURPOSE_VERSION
#endif
#ifdef PURPOSE_NO_DEPRECATED_WARNINGS
#  define PURPOSE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PURPOSE_DEPRECATED_WARNINGS_SINCE
#  ifdef PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PURPOSE_DEPRECATED_WARNINGS_SINCE PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PURPOSE_DEPRECATED_WARNINGS_SINCE PURPOSE_VERSION
#  endif
#endif

#ifndef PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PURPOSE_DEPRECATED
#  define PURPOSE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PURPOSE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PURPOSE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* PURPOSE_EXPORT_H */
