/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tomcat.util.compat.JreCompat;

public final class JarContents {
    private static final int HASH_PRIME_1 = 31;
    private static final int HASH_PRIME_2 = 17;
    private static final int TABLE_SIZE = 2048;
    private final BitSet bits1 = new BitSet(2048);
    private final BitSet bits2 = new BitSet(2048);

    public JarContents(JarFile jarFile) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            this.processEntry(jarEntry);
        }
    }

    public JarContents(Collection<JarEntry> collection) {
        for (JarEntry jarEntry : collection) {
            this.processEntry(jarEntry);
        }
    }

    private void processEntry(JarEntry jarEntry) {
        int n;
        int n2;
        boolean bl;
        String string = jarEntry.getName();
        int n3 = 0;
        boolean bl2 = bl = string.charAt(0) == '/';
        if (bl) {
            n3 = 1;
        }
        if (string.startsWith("META-INF/versions/", n3)) {
            n2 = string.indexOf(47, 18 + n3);
            if (n2 > 0 && (n = Integer.parseInt(string.substring(18 + n3, n2))) <= JreCompat.getInstance().jarFileRuntimeMajorVersion()) {
                n3 = n2 + 1;
            }
            if (n3 == string.length()) {
                return;
            }
        }
        n2 = this.hashcode(string, n3, 31);
        n = this.hashcode(string, n3, 17);
        this.bits1.set(n2 % 2048);
        this.bits2.set(n % 2048);
        if (jarEntry.isDirectory()) {
            n2 = this.hashcode(string, n3, string.length() - 1, 31);
            n = this.hashcode(string, n3, string.length() - 1, 17);
            this.bits1.set(n2 % 2048);
            this.bits2.set(n % 2048);
        }
    }

    private int hashcode(String string, int n, int n2) {
        return this.hashcode(string, n, string.length(), n2);
    }

    private int hashcode(String string, int n, int n2, int n3) {
        int n4 = n3 / 2;
        for (int i = n; i < n2; ++i) {
            n4 = n3 * n4 + string.charAt(i);
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        return n4;
    }

    public boolean mightContainResource(String string, String string2) {
        int n = 0;
        if (string.startsWith(string2)) {
            n = string2.length();
        }
        if (string.charAt(n) == '/') {
            ++n;
        }
        return this.bits1.get(this.hashcode(string, n, 31) % 2048) && this.bits2.get(this.hashcode(string, n, 17) % 2048);
    }
}

