﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codepipeline/CodePipeline_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace CodePipeline {
namespace Model {
enum class ExecutionType { NOT_SET, STANDARD, ROLLBACK };

namespace ExecutionTypeMapper {
AWS_CODEPIPELINE_API ExecutionType GetExecutionTypeForName(const Aws::String& name);

AWS_CODEPIPELINE_API Aws::String GetNameForExecutionType(ExecutionType value);
}  // namespace ExecutionTypeMapper
}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
