﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p> Provides details about an Database Migration Service (DMS) endpoint. An
 * endpoint provides connection, data store type, and location information about
 * your data store. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsDmsEndpointDetails">AWS
 * API Reference</a></p>
 */
class AwsDmsEndpointDetails {
 public:
  AWS_SECURITYHUB_API AwsDmsEndpointDetails() = default;
  AWS_SECURITYHUB_API AwsDmsEndpointDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsDmsEndpointDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) for the SSL certificate that encrypts
   * connections between the DMS endpoint and the replication instance. </p>
   */
  inline const Aws::String& GetCertificateArn() const { return m_certificateArn; }
  inline bool CertificateArnHasBeenSet() const { return m_certificateArnHasBeenSet; }
  template <typename CertificateArnT = Aws::String>
  void SetCertificateArn(CertificateArnT&& value) {
    m_certificateArnHasBeenSet = true;
    m_certificateArn = std::forward<CertificateArnT>(value);
  }
  template <typename CertificateArnT = Aws::String>
  AwsDmsEndpointDetails& WithCertificateArn(CertificateArnT&& value) {
    SetCertificateArn(std::forward<CertificateArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the endpoint database.</p>
   */
  inline const Aws::String& GetDatabaseName() const { return m_databaseName; }
  inline bool DatabaseNameHasBeenSet() const { return m_databaseNameHasBeenSet; }
  template <typename DatabaseNameT = Aws::String>
  void SetDatabaseName(DatabaseNameT&& value) {
    m_databaseNameHasBeenSet = true;
    m_databaseName = std::forward<DatabaseNameT>(value);
  }
  template <typename DatabaseNameT = Aws::String>
  AwsDmsEndpointDetails& WithDatabaseName(DatabaseNameT&& value) {
    SetDatabaseName(std::forward<DatabaseNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The Amazon Resource Name (ARN) of the endpoint. </p>
   */
  inline const Aws::String& GetEndpointArn() const { return m_endpointArn; }
  inline bool EndpointArnHasBeenSet() const { return m_endpointArnHasBeenSet; }
  template <typename EndpointArnT = Aws::String>
  void SetEndpointArn(EndpointArnT&& value) {
    m_endpointArnHasBeenSet = true;
    m_endpointArn = std::forward<EndpointArnT>(value);
  }
  template <typename EndpointArnT = Aws::String>
  AwsDmsEndpointDetails& WithEndpointArn(EndpointArnT&& value) {
    SetEndpointArn(std::forward<EndpointArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The database endpoint identifier. </p>
   */
  inline const Aws::String& GetEndpointIdentifier() const { return m_endpointIdentifier; }
  inline bool EndpointIdentifierHasBeenSet() const { return m_endpointIdentifierHasBeenSet; }
  template <typename EndpointIdentifierT = Aws::String>
  void SetEndpointIdentifier(EndpointIdentifierT&& value) {
    m_endpointIdentifierHasBeenSet = true;
    m_endpointIdentifier = std::forward<EndpointIdentifierT>(value);
  }
  template <typename EndpointIdentifierT = Aws::String>
  AwsDmsEndpointDetails& WithEndpointIdentifier(EndpointIdentifierT&& value) {
    SetEndpointIdentifier(std::forward<EndpointIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of endpoint. Valid values are source and target. </p>
   */
  inline const Aws::String& GetEndpointType() const { return m_endpointType; }
  inline bool EndpointTypeHasBeenSet() const { return m_endpointTypeHasBeenSet; }
  template <typename EndpointTypeT = Aws::String>
  void SetEndpointType(EndpointTypeT&& value) {
    m_endpointTypeHasBeenSet = true;
    m_endpointType = std::forward<EndpointTypeT>(value);
  }
  template <typename EndpointTypeT = Aws::String>
  AwsDmsEndpointDetails& WithEndpointType(EndpointTypeT&& value) {
    SetEndpointType(std::forward<EndpointTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The type of engine for the endpoint, depending on the
   * <code>EndpointType</code> value. </p>
   */
  inline const Aws::String& GetEngineName() const { return m_engineName; }
  inline bool EngineNameHasBeenSet() const { return m_engineNameHasBeenSet; }
  template <typename EngineNameT = Aws::String>
  void SetEngineName(EngineNameT&& value) {
    m_engineNameHasBeenSet = true;
    m_engineName = std::forward<EngineNameT>(value);
  }
  template <typename EngineNameT = Aws::String>
  AwsDmsEndpointDetails& WithEngineName(EngineNameT&& value) {
    SetEngineName(std::forward<EngineNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> A value that can be used for cross-account validation. </p>
   */
  inline const Aws::String& GetExternalId() const { return m_externalId; }
  inline bool ExternalIdHasBeenSet() const { return m_externalIdHasBeenSet; }
  template <typename ExternalIdT = Aws::String>
  void SetExternalId(ExternalIdT&& value) {
    m_externalIdHasBeenSet = true;
    m_externalId = std::forward<ExternalIdT>(value);
  }
  template <typename ExternalIdT = Aws::String>
  AwsDmsEndpointDetails& WithExternalId(ExternalIdT&& value) {
    SetExternalId(std::forward<ExternalIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Additional attributes associated with the connection. </p>
   */
  inline const Aws::String& GetExtraConnectionAttributes() const { return m_extraConnectionAttributes; }
  inline bool ExtraConnectionAttributesHasBeenSet() const { return m_extraConnectionAttributesHasBeenSet; }
  template <typename ExtraConnectionAttributesT = Aws::String>
  void SetExtraConnectionAttributes(ExtraConnectionAttributesT&& value) {
    m_extraConnectionAttributesHasBeenSet = true;
    m_extraConnectionAttributes = std::forward<ExtraConnectionAttributesT>(value);
  }
  template <typename ExtraConnectionAttributesT = Aws::String>
  AwsDmsEndpointDetails& WithExtraConnectionAttributes(ExtraConnectionAttributesT&& value) {
    SetExtraConnectionAttributes(std::forward<ExtraConnectionAttributesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> An DMS key identifier that is used to encrypt the connection parameters for
   * the endpoint. If you don't specify a value for the <code>KmsKeyId</code>
   * parameter, then DMS uses your default encryption key. KMS creates the default
   * encryption key for your Amazon Web Services account. Your Amazon Web Services
   * account has a different default encryption key for each Amazon Web Services
   * Region.</p>
   */
  inline const Aws::String& GetKmsKeyId() const { return m_kmsKeyId; }
  inline bool KmsKeyIdHasBeenSet() const { return m_kmsKeyIdHasBeenSet; }
  template <typename KmsKeyIdT = Aws::String>
  void SetKmsKeyId(KmsKeyIdT&& value) {
    m_kmsKeyIdHasBeenSet = true;
    m_kmsKeyId = std::forward<KmsKeyIdT>(value);
  }
  template <typename KmsKeyIdT = Aws::String>
  AwsDmsEndpointDetails& WithKmsKeyId(KmsKeyIdT&& value) {
    SetKmsKeyId(std::forward<KmsKeyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The port used to access the endpoint. </p>
   */
  inline int GetPort() const { return m_port; }
  inline bool PortHasBeenSet() const { return m_portHasBeenSet; }
  inline void SetPort(int value) {
    m_portHasBeenSet = true;
    m_port = value;
  }
  inline AwsDmsEndpointDetails& WithPort(int value) {
    SetPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the server where the endpoint database resides.</p>
   */
  inline const Aws::String& GetServerName() const { return m_serverName; }
  inline bool ServerNameHasBeenSet() const { return m_serverNameHasBeenSet; }
  template <typename ServerNameT = Aws::String>
  void SetServerName(ServerNameT&& value) {
    m_serverNameHasBeenSet = true;
    m_serverName = std::forward<ServerNameT>(value);
  }
  template <typename ServerNameT = Aws::String>
  AwsDmsEndpointDetails& WithServerName(ServerNameT&& value) {
    SetServerName(std::forward<ServerNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The SSL mode used to connect to the endpoint. The default is none.</p>
   */
  inline const Aws::String& GetSslMode() const { return m_sslMode; }
  inline bool SslModeHasBeenSet() const { return m_sslModeHasBeenSet; }
  template <typename SslModeT = Aws::String>
  void SetSslMode(SslModeT&& value) {
    m_sslModeHasBeenSet = true;
    m_sslMode = std::forward<SslModeT>(value);
  }
  template <typename SslModeT = Aws::String>
  AwsDmsEndpointDetails& WithSslMode(SslModeT&& value) {
    SetSslMode(std::forward<SslModeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The user name to be used to log in to the endpoint database. </p>
   */
  inline const Aws::String& GetUsername() const { return m_username; }
  inline bool UsernameHasBeenSet() const { return m_usernameHasBeenSet; }
  template <typename UsernameT = Aws::String>
  void SetUsername(UsernameT&& value) {
    m_usernameHasBeenSet = true;
    m_username = std::forward<UsernameT>(value);
  }
  template <typename UsernameT = Aws::String>
  AwsDmsEndpointDetails& WithUsername(UsernameT&& value) {
    SetUsername(std::forward<UsernameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_certificateArn;

  Aws::String m_databaseName;

  Aws::String m_endpointArn;

  Aws::String m_endpointIdentifier;

  Aws::String m_endpointType;

  Aws::String m_engineName;

  Aws::String m_externalId;

  Aws::String m_extraConnectionAttributes;

  Aws::String m_kmsKeyId;

  int m_port{0};

  Aws::String m_serverName;

  Aws::String m_sslMode;

  Aws::String m_username;
  bool m_certificateArnHasBeenSet = false;
  bool m_databaseNameHasBeenSet = false;
  bool m_endpointArnHasBeenSet = false;
  bool m_endpointIdentifierHasBeenSet = false;
  bool m_endpointTypeHasBeenSet = false;
  bool m_engineNameHasBeenSet = false;
  bool m_externalIdHasBeenSet = false;
  bool m_extraConnectionAttributesHasBeenSet = false;
  bool m_kmsKeyIdHasBeenSet = false;
  bool m_portHasBeenSet = false;
  bool m_serverNameHasBeenSet = false;
  bool m_sslModeHasBeenSet = false;
  bool m_usernameHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
