/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.overview.MapOverviewImageMouseHandler;
import org.freeplane.view.swing.map.overview.MapViewPane;

class MapOverviewImage
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final Color VIEWPORT_HIGHLIGHTING_COLOR = new Color(838861055, true);
    private static final float FONT_SCALE = 0.75f;
    private BufferedImage image;
    private MapView mapView;
    private PopupMenu popupMenu;

    MapOverviewImage(MapView mapView, JScrollPane mapViewScrollPane) {
        this.mapView = mapView;
        MapOverviewImageMouseHandler handler = new MapOverviewImageMouseHandler(mapView, mapViewScrollPane);
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.addMouseWheelListener(handler);
        this.popupMenu = new PopupMenu();
        MenuItem hideItem = new MenuItem(TextUtils.getText("map_overview_hide"));
        hideItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controller.getCurrentController().getViewController().setMapOverviewVisible(false);
            }
        });
        this.popupMenu.add(hideItem);
        this.add(this.popupMenu);
    }

    void showPopupMenu(int x, int y) {
        this.popupMenu.show(this, x, y);
    }

    void resetImage() {
        this.image = null;
    }

    double getBestScale(Dimension mapSize, Dimension overviewSize) {
        double tw = overviewSize.getWidth();
        double sw = mapSize.getWidth();
        double th = overviewSize.getHeight();
        double sh = mapSize.getHeight();
        double scale = sw / sh > tw / th ? tw / sw : th / sh;
        return scale;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle overviewBounds = this.getBounds();
        Rectangle mapInnerBounds = this.mapView.getRoot().getBounds();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform transform = g2d.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleX();
        AffineTransform overviewTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        overviewBounds = overviewTransform.createTransformedShape(overviewBounds).getBounds();
        Dimension source = mapInnerBounds.getSize();
        Dimension target = overviewBounds.getSize();
        double scale = this.getBestScale(source, target);
        if (this.image == null || this.image.getWidth() != overviewBounds.width) {
            this.image = this.createOverviewImage(mapInnerBounds, overviewBounds, scale);
        }
        double overviewImageX = (target.getWidth() - source.getWidth() * scale) / 2.0;
        double overviewImageY = (target.getHeight() - source.getHeight() * scale) / 2.0;
        if (scaleX == 1.0 && scaleY == 1.0) {
            g2d.drawImage((Image)this.image, (int)overviewImageX, (int)overviewImageY, this);
        } else {
            AffineTransform newTransform = AffineTransform.getTranslateInstance(transform.getTranslateX(), transform.getTranslateY());
            g2d.setTransform(newTransform);
            g2d.drawImage((Image)this.image, (int)overviewImageX, (int)overviewImageY, this);
            g2d.setTransform(transform);
        }
        this.highlightViewport(g2d, mapInnerBounds, scale, (int)(overviewImageX / scaleX), (int)(overviewImageY / scaleY));
        this.drawZoomLevel(g2d);
    }

    private void drawZoomLevel(Graphics2D g2d) {
        String zoomLevel = null;
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager instanceof MapViewController) {
            zoomLevel = ((MapViewController)mapViewManager).getItemForZoom(this.mapView.getZoom());
        }
        if (zoomLevel == null) {
            return;
        }
        Dimension imageSize = this.getSize();
        int borderSize = MapViewPane.MAP_OVERVIEW_BORDER_SIZE;
        Point zoomLevelLoc = new Point(borderSize, imageSize.height - borderSize);
        Color invBgColor = this.complementaryColor(this.mapView.getBackground());
        Color textColor = new Color(invBgColor.getRed(), invBgColor.getGreen(), invBgColor.getBlue(), 95);
        g2d.setColor(textColor);
        Font origFont = this.getFont();
        g2d.setFont(origFont.deriveFont((float)origFont.getSize() * 0.75f));
        g2d.drawChars(zoomLevel.toCharArray(), 0, zoomLevel.length(), zoomLevelLoc.x, zoomLevelLoc.y);
    }

    private Color complementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createOverviewImage(Rectangle mapInnerBounds, Rectangle overviewBounds, double scale) {
        AffineTransform translation = AffineTransform.getTranslateInstance(-mapInnerBounds.x, -mapInnerBounds.y);
        AffineTransform transformer = AffineTransform.getScaleInstance(scale, scale);
        transformer.concatenate(translation);
        BufferedImage image = new BufferedImage(overviewBounds.width, overviewBounds.height, 2);
        Graphics2D imageG2D = image.createGraphics();
        try {
            imageG2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            imageG2D.setColor(this.mapView.getBackground());
            imageG2D.fillRect(0, 0, overviewBounds.width, overviewBounds.height);
            imageG2D.transform(transformer);
            imageG2D.clip(mapInnerBounds);
            this.mapView.paintOverview(imageG2D);
        }
        finally {
            imageG2D.dispose();
        }
        return image;
    }

    private void highlightViewport(Graphics2D g2d, Rectangle mapInnerBounds, double scale, int overviewImageX, int overviewImageY) {
        JViewport viewPort = (JViewport)this.mapView.getParent();
        Point viewPortPosition = viewPort.getViewPosition();
        Dimension viewportSize = viewPort.getExtentSize();
        Rectangle highlightedRectangleOnMap = new Rectangle(viewPortPosition.x - mapInnerBounds.x, viewPortPosition.y - mapInnerBounds.y, viewportSize.width, viewportSize.height);
        AffineTransform transformed = g2d.getTransform();
        AffineTransform transformer = AffineTransform.getScaleInstance(scale / transformed.getScaleX(), scale / transformed.getScaleY());
        Rectangle highlightedRectanlgleOnOverview = transformer.createTransformedShape(highlightedRectangleOnMap).getBounds();
        highlightedRectanlgleOnOverview.x += overviewImageX;
        highlightedRectanlgleOnOverview.y += overviewImageY;
        g2d.setColor(VIEWPORT_HIGHLIGHTING_COLOR);
        g2d.fillRect(highlightedRectanlgleOnOverview.x, highlightedRectanlgleOnOverview.y, highlightedRectanlgleOnOverview.width, highlightedRectanlgleOnOverview.height);
        g2d.setColor(VIEWPORT_HIGHLIGHTING_COLOR.darker());
        g2d.drawRect(highlightedRectanlgleOnOverview.x, highlightedRectanlgleOnOverview.y, highlightedRectanlgleOnOverview.width - 1, highlightedRectanlgleOnOverview.height - 1);
    }
}

