/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.NodeStyleDeclaration;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class InlineStyle
extends BaseCSSStyleDeclaration
implements NodeStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private Node node = null;

    protected InlineStyle() {
    }

    protected InlineStyle(InlineStyle copiedObject) {
        super(copiedObject);
        this.setOwnerNode(copiedObject.getOwnerNode());
    }

    @Override
    protected void writeShorthandCssText(SimpleWriter wri, StyleFormattingContext context, String shorthandName, ShorthandValue shval) throws IOException {
        wri.write((CharSequence)shorthandName);
        context.writeColon(wri);
        context.writeShorthandValue(wri, shorthandName, shval);
        if (shval.isImportant()) {
            context.writeImportantPriority(wri);
        }
        context.writeSemiColon(wri);
        context.endInlinePropertyDeclaration(wri);
    }

    @Override
    protected void writeLonghandCssText(SimpleWriter wri, StyleFormattingContext context, String ptyname, StyleValue ptyvalue, boolean important) throws IOException {
        wri.write((CharSequence)ptyname);
        context.writeColon(wri);
        this.writeValue(wri, ptyname, ptyvalue);
        if (important) {
            context.writeImportantPriority(wri);
        }
        context.writeSemiColon(wri);
        context.endInlinePropertyDeclaration(wri);
    }

    private void writeValue(SimpleWriter wri, String propertyName, StyleValue value) throws IOException {
        if (value.getCssValueType() != CSSValue.CssType.TYPED || value.getPrimitiveType() != CSSValue.Type.STRING) {
            value.writeCssText(wri);
        } else {
            CSSTypedValue primi = (CSSTypedValue)((Object)value);
            String s = primi.getStringValue();
            s = ParseHelper.escapeControl(s);
            s = ParseHelper.quote(s, '\'');
            wri.write((CharSequence)s);
        }
    }

    @Override
    public Node getOwnerNode() {
        return this.node;
    }

    protected void setOwnerNode(Node node) {
        this.node = node;
    }

    public boolean hasOverrideStyle(Condition pseudoElt) {
        Node node = this.getOwnerNode();
        if (node != null) {
            short type = node.getNodeType();
            if (type == 2) {
                if ((node = ((Attr)node).getOwnerElement()) == null) {
                    return false;
                }
                type = node.getNodeType();
            }
            if (type == 1) {
                return ((CSSElement)node).hasOverrideStyle(pseudoElt);
            }
        }
        return false;
    }

    @Override
    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        CSSElement owner;
        Node node = this.getOwnerNode();
        if (node != null && (owner = node.getNodeType() == 2 ? (CSSElement)((Attr)node).getOwnerElement() : (node.getNodeType() == 1 ? (CSSElement)node : null)) != null) {
            return owner.getOwnerDocument().getErrorHandler().getInlineStyleErrorHandler(owner);
        }
        return null;
    }

    @Override
    public abstract InlineStyle clone();
}

