/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.suggestions;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.extensions.PluginId;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001BO\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u000b\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007\u0012\u000b\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\nR\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/suggestions/PluginEnablementChecker;", "", "notebookLanguages", "", "", "dismissedKey", "suggestionText", "Lcom/intellij/openapi/util/NlsContexts$Label;", "suggestionActionText", "requiresIdeRestart", "", "pluginIds", "", "<init>", "(Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;)V", "getSuggestionText", "()Ljava/lang/String;", "getSuggestionActionText", "getRequiresIdeRestart", "()Z", "getPluginIds", "()Ljava/util/List;", "isNotebookLanguageSupported", "languageId", "isSuggestionDismissed", "dismissSuggestion", "", "pluginsInstalledAndEnabled", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJupyterNotebookSuggestionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/PluginEnablementChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1740#2,3:149\n*S KotlinDebug\n*F\n+ 1 JupyterNotebookSuggestionProvider.kt\norg/jetbrains/kotlin/idea/suggestions/PluginEnablementChecker\n*L\n142#1:149,3\n*E\n"})
final class PluginEnablementChecker {
    @Nullable
    private final Set<String> notebookLanguages;
    @NotNull
    private final String dismissedKey;
    @NotNull
    private final String suggestionText;
    @NotNull
    private final String suggestionActionText;
    private final boolean requiresIdeRestart;
    @NotNull
    private final List<String> pluginIds;

    public PluginEnablementChecker(@Nullable Set<String> notebookLanguages, @NotNull String dismissedKey, @NotNull String suggestionText, @NotNull String suggestionActionText, boolean requiresIdeRestart, @NotNull List<String> pluginIds) {
        Intrinsics.checkNotNullParameter((Object)dismissedKey, (String)"dismissedKey");
        Intrinsics.checkNotNullParameter((Object)suggestionText, (String)"suggestionText");
        Intrinsics.checkNotNullParameter((Object)suggestionActionText, (String)"suggestionActionText");
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        this.notebookLanguages = notebookLanguages;
        this.dismissedKey = dismissedKey;
        this.suggestionText = suggestionText;
        this.suggestionActionText = suggestionActionText;
        this.requiresIdeRestart = requiresIdeRestart;
        this.pluginIds = pluginIds;
    }

    @NotNull
    public final String getSuggestionText() {
        return this.suggestionText;
    }

    @NotNull
    public final String getSuggestionActionText() {
        return this.suggestionActionText;
    }

    public final boolean getRequiresIdeRestart() {
        return this.requiresIdeRestart;
    }

    @NotNull
    public final List<String> getPluginIds() {
        return this.pluginIds;
    }

    public final boolean isNotebookLanguageSupported(@Nullable String languageId2) {
        if (this.notebookLanguages == null) {
            return true;
        }
        if (languageId2 == null) {
            return false;
        }
        return this.notebookLanguages.contains(languageId2);
    }

    public final boolean isSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue(this.dismissedKey);
    }

    public final void dismissSuggestion() {
        PropertiesComponent.getInstance().setValue(this.dismissedKey, true);
    }

    public final boolean pluginsInstalledAndEnabled() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.pluginIds;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String pluginIdStr = (String)element$iv;
                    boolean bl2 = false;
                    PluginId pluginId = PluginId.Companion.getId(pluginIdStr);
                    if (PluginManager.isPluginInstalled((PluginId)pluginId) && !PluginManagerCore.isDisabled((PluginId)pluginId)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

