/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass, boolean includeSelf, @NotNull Processor<? super PsiClass> superProcessor) {
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass, superProcessor, new HashSet());
    }

    private static boolean processSupers(@NotNull PsiClass aClass, @NotNull Processor<? super PsiClass> superProcessor, @NotNull Set<? super PsiClass> visited2) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(1);
        }
        if (superProcessor == null) {
            InheritanceUtil.$$$reportNull$$$0(2);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(3);
        }
        if (!visited2.add(aClass)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited2)) continue;
            return false;
        }
        PsiClass superClass = aClass.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited2);
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiType type2, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(4);
        }
        if (type2 instanceof PsiClassType) {
            PsiUtil.ensureValidType(type2);
            return InheritanceUtil.isInheritor(((PsiClassType)type2).resolve(), baseClassName);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (!InheritanceUtil.isInheritor(conjunct, baseClassName)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(5);
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            InheritanceUtil.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass, @NotNull Set<? super PsiClass> results, boolean includeNonProject) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(7);
        }
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(8);
        }
        InheritanceUtil.getSuperClassesOfList(aClass.getSuperTypes(), results, includeNonProject, new HashSet(), aClass.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(9);
        }
        LinkedHashSet<PsiClass> result2 = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass, result2, true);
        return result2;
    }

    private static void getSuperClassesOfList(PsiClassType @NotNull [] types2, @NotNull Set<? super PsiClass> results, boolean includeNonProject, @NotNull Set<? super PsiClass> visited2, @NotNull PsiManager manager) {
        if (results == null) {
            InheritanceUtil.$$$reportNull$$$0(10);
        }
        if (visited2 == null) {
            InheritanceUtil.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            InheritanceUtil.$$$reportNull$$$0(12);
        }
        if (types2 == null) {
            InheritanceUtil.$$$reportNull$$$0(13);
        }
        for (PsiClassType type2 : types2) {
            PsiClass resolved = type2.resolve();
            if (resolved == null || !visited2.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited2, manager);
        }
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass aClass, PsiElement scope2, boolean isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(14);
        }
        return InheritanceUtil.hasEnclosingInstanceInScope(aClass, scope2, psiClass -> isSuperClassAccepted, isTypeParamsAccepted);
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass aClass, PsiElement scope2, @NotNull Condition<? super PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(15);
        }
        if (isSuperClassAccepted == null) {
            InheritanceUtil.$$$reportNull$$$0(16);
        }
        return InheritanceUtil.findEnclosingInstanceInScope(aClass, scope2, isSuperClassAccepted, isTypeParamsAccepted) != null;
    }

    @Nullable
    public static PsiClass findEnclosingInstanceInScope(@NotNull PsiClass aClass, PsiElement scope2, @NotNull Condition<? super PsiClass> isSuperClassAccepted, boolean isTypeParamsAccepted) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(17);
        }
        if (isSuperClassAccepted == null) {
            InheritanceUtil.$$$reportNull$$$0(18);
        }
        PsiManager manager = aClass.getManager();
        for (PsiElement place = scope2; place != null && !(place instanceof PsiFile); place = place.getParent()) {
            PsiModifierList modifierList2;
            if (place instanceof PsiClass) {
                if (isSuperClassAccepted.value((PsiClass)place)) {
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)place, aClass, true)) {
                        return (PsiClass)place;
                    }
                } else if (manager.areElementsEquivalent(place, aClass)) {
                    return aClass;
                }
                if (isTypeParamsAccepted && place instanceof PsiTypeParameter) {
                    return (PsiClass)place;
                }
            }
            if (!(place instanceof PsiModifierListOwner) || (modifierList2 = ((PsiModifierListOwner)place).getModifierList()) == null || !modifierList2.hasModifierProperty("static")) continue;
            return null;
        }
        return null;
    }

    public static boolean processSuperTypes(@NotNull PsiType type2, boolean includeSelf, @NotNull Processor<? super PsiType> processor) {
        if (type2 == null) {
            InheritanceUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            InheritanceUtil.$$$reportNull$$$0(20);
        }
        if (includeSelf && !processor.process(type2)) {
            return false;
        }
        return InheritanceUtil.processSuperTypes(type2, processor, new HashSet());
    }

    private static boolean processSuperTypes(PsiType type2, Processor<? super PsiType> processor, Set<? super PsiType> visited2) {
        if (!visited2.add(type2)) {
            return true;
        }
        for (PsiType superType : type2.getSuperTypes()) {
            if (!processor.process(superType)) {
                return false;
            }
            InheritanceUtil.processSuperTypes(superType, processor, visited2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PsiClass getCircularClass(@NotNull PsiClass aClass, @NotNull Collection<? super PsiClass> usedClasses) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(21);
        }
        if (usedClasses == null) {
            InheritanceUtil.$$$reportNull$$$0(22);
        }
        if (usedClasses.contains(aClass)) {
            return aClass;
        }
        try {
            PsiClassType[] superTypes;
            usedClasses.add(aClass);
            for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
                Object circularClass = InheritanceUtil.getCircularClassInner(superType.resolve(), usedClasses);
                if (circularClass != null) {
                    PsiAnnotation[] psiAnnotationArray = circularClass;
                    return psiAnnotationArray;
                }
                for (PsiAnnotation annotation : superType.getAnnotations()) {
                    circularClass = InheritanceUtil.getCircularClassInner(annotation.resolveAnnotationType(), usedClasses);
                    if (circularClass == null) continue;
                    Object object = circularClass;
                    return object;
                }
            }
        }
        finally {
            usedClasses.remove(aClass);
        }
        return null;
    }

    @Nullable
    private static PsiClass getCircularClassInner(@Nullable PsiElement superType, @NotNull Collection<? super PsiClass> usedClasses) {
        if (usedClasses == null) {
            InheritanceUtil.$$$reportNull$$$0(23);
        }
        while (superType instanceof PsiClass) {
            PsiClass circularClass;
            if (!"java.lang.Object".equals(((PsiClass)superType).getQualifiedName()) && (circularClass = InheritanceUtil.getCircularClass((PsiClass)superType, usedClasses)) != null) {
                return circularClass;
            }
            superType = superType.getParent();
        }
        return null;
    }

    @Nullable
    public static PsiClass getCircularClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(24);
        }
        return InheritanceUtil.getCircularClass(aClass, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superProcessor";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSuperClassAccepted";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedClasses";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/InheritanceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processSupers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperClassesOfList";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEnclosingInstanceInScope";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingInstanceInScope";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperTypes";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getCircularClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getCircularClassInner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

