/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/AnalyzingUtils;", "", "<init>", "()V", "WRITE_DEBUG_TRACE_NAMES", "", "checkForSyntacticErrors", "", "root", "Lcom/intellij/psi/PsiElement;", "getSyntaxErrorRanges", "", "Lcom/intellij/psi/PsiErrorElement;", "throwExceptionOnErrors", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "formDebugNameForBindingTrace", "", "debugName", "resolutionSubjectForMessage", "PsiErrorElementVisitor", "frontend"})
public final class AnalyzingUtils {
    @NotNull
    public static final AnalyzingUtils INSTANCE = new AnalyzingUtils();

    private AnalyzingUtils() {
    }

    @JvmStatic
    public static final void checkForSyntacticErrors(@NotNull PsiElement root) {
        Intrinsics.checkNotNullParameter(root, "root");
        root.acceptChildren(new PsiErrorElementVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                throw new IllegalArgumentException(element.getErrorDescription() + "; looking at " + element.getNode().getElementType() + " '" + element.getText() + PsiDiagnosticUtils.atLocation(element));
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        Intrinsics.checkNotNullParameter(root, "root");
        List r = new ArrayList();
        root.acceptChildren(new PsiErrorElementVisitor(r){
            final /* synthetic */ List<PsiErrorElement> $r;
            {
                this.$r = $r;
            }

            public void visitErrorElement(PsiErrorElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                this.$r.add(element);
            }
        });
        return r;
    }

    public final void throwExceptionOnErrors(@NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Diagnostics diagnostics = bindingContext.getDiagnostics();
        Intrinsics.checkNotNullExpressionValue(diagnostics, "getDiagnostics(...)");
        this.throwExceptionOnErrors(diagnostics);
    }

    public final void throwExceptionOnErrors(@NotNull Diagnostics diagnostics) {
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        for (Diagnostic diagnostic : diagnostics) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    @JvmStatic
    @NotNull
    public static final String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        return "";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/AnalyzingUtils$PsiErrorElementVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "<init>", "()V", "visitErrorElement", "", "element", "Lcom/intellij/psi/PsiErrorElement;", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "frontend"})
    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        @Override
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);

        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            PsiUtilsKt.visitBinaryExpressionUsingStack(this, expression2);
        }
    }
}

