/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FilePreprocessorExtension;
import org.jetbrains.kotlin.resolve.FilePreprocessorKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/FilePreprocessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "extensions", "", "Lorg/jetbrains/kotlin/resolve/FilePreprocessorExtension;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/Iterable;)V", "preprocessFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "registerFileByPackage", "frontend"})
public final class FilePreprocessor {
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final Iterable<FilePreprocessorExtension> extensions;

    public FilePreprocessor(@NotNull BindingTrace trace, @NotNull Iterable<? extends FilePreprocessorExtension> extensions) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.trace = trace;
        this.extensions = extensions;
    }

    public final void preprocessFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.registerFileByPackage(file);
        for (FilePreprocessorExtension extension : this.extensions) {
            extension.preprocessFile(file);
        }
    }

    private final void registerFileByPackage(KtFile file) {
        WritableSlice<FqName, Collection<KtFile>> writableSlice = BindingContext.PACKAGE_TO_FILES;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "PACKAGE_TO_FILES");
        FilePreprocessorKt.addElementToSlice(this.trace, writableSlice, file.getPackageFqName(), file);
    }
}

