/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.MappingValue;
import org.languagetool.markup.TextPart;

public class AnnotatedTextBuilder {
    private static final String hiddenChars = "\u00ad\u202d\u202c";
    private final List<TextPart> parts = new ArrayList<TextPart>();
    private final Map<AnnotatedText.MetaDataKey, String> metaData = new HashMap<AnnotatedText.MetaDataKey, String>();
    private final Map<String, String> customMetaData = new HashMap<String, String>();

    public AnnotatedTextBuilder addGlobalMetaData(AnnotatedText.MetaDataKey key, String value) {
        this.metaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addGlobalMetaData(String key, String value) {
        this.customMetaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addText(String text) {
        StringTokenizer st = new StringTokenizer(text, hiddenChars, true);
        while (st.hasMoreElements()) {
            String token = (String)st.nextElement();
            if (!hiddenChars.contains(token)) {
                this.parts.add(new TextPart(token, TextPart.Type.TEXT));
                continue;
            }
            this.parts.add(new TextPart(token, TextPart.Type.MARKUP));
        }
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup, String interpretAs) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        this.parts.add(new TextPart(interpretAs, TextPart.Type.FAKE_CONTENT));
        return this;
    }

    public void add(TextPart part) {
        this.parts.add(part);
    }

    public AnnotatedText build() {
        int plainTextPosition = 0;
        int totalPosition = 0;
        HashMap<Integer, MappingValue> mapping = new HashMap<Integer, MappingValue>();
        for (int i = 0; i < this.parts.size(); ++i) {
            MappingValue mappingValue;
            TextPart part = this.parts.get(i);
            if (part.getType() == TextPart.Type.TEXT) {
                mappingValue = new MappingValue(totalPosition += part.getPart().length());
                mapping.put(plainTextPosition += part.getPart().length(), mappingValue);
                continue;
            }
            if (part.getType() != TextPart.Type.MARKUP) continue;
            totalPosition += part.getPart().length();
            if (!this.hasFakeContent(i, this.parts)) continue;
            plainTextPosition += this.parts.get(i + 1).getPart().length();
            ++i;
            if (mapping.get(plainTextPosition) != null) continue;
            mappingValue = new MappingValue(totalPosition, part.getPart().length());
            mapping.put(plainTextPosition, mappingValue);
        }
        return new AnnotatedText(this.parts, mapping, this.metaData, this.customMetaData);
    }

    private boolean hasFakeContent(int i, List<TextPart> parts) {
        int nextPartIndex = i + 1;
        return nextPartIndex < parts.size() && parts.get(nextPartIndex).getType().equals((Object)TextPart.Type.FAKE_CONTENT);
    }
}

