/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints.projects.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.editor.tools.storage.api.ToolPreferences;
import org.netbeans.spi.editor.hints.projects.PerProjectHintsPanel;
import org.netbeans.spi.editor.hints.projects.support.AdvancedLocationPanel;
import org.netbeans.spi.editor.hints.projects.support.Bundle;
import org.netbeans.spi.editor.hints.projects.support.StandardProjectSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class ProjectHintSettingPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ProjectHintSettingPanel.class.getName());
    private final PerProjectHintsPanel panel;
    private final JComponent panelUI;
    private final StandardProjectSettings.Standard projectSettings;
    private String settingsFileLocation;
    private PerProjectHintsPanel.MimeType2Preferences perProjectPreferences;
    private ToolPreferences toolPreferences;
    private JButton advanced;
    private JButton globalSettings;
    private JPanel settingsCustomizer;
    private ButtonGroup settingsSourceSelection;
    private JRadioButton useGlobalSettings;
    private JRadioButton useProjectSettings;

    public ProjectHintSettingPanel(StandardProjectSettings.Standard projectSettings, String customizersFolderLocation) {
        FileObject customizersFolder;
        this.projectSettings = projectSettings;
        this.settingsFileLocation = projectSettings.hasLocation() ? projectSettings.getSettingsFileLocation() : null;
        this.settingsFileLocationChanged();
        try {
            customizersFolder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)customizersFolderLocation);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        this.panel = PerProjectHintsPanel.create(customizersFolder);
        this.initComponents();
        this.advanced.setVisible(projectSettings.hasLocation());
        if (projectSettings.getUseProjectSettings()) {
            this.useProjectSettings.setSelected(true);
        } else {
            this.useGlobalSettings.setSelected(true);
        }
        this.settingsCustomizer.setLayout(new BorderLayout());
        this.panelUI = this.panel.getPanel();
        this.settingsCustomizer.add((Component)this.panelUI, "Center");
        this.settingsOriginChanged();
    }

    private void settingsOriginChanged() {
        this.globalSettings.setEnabled(!this.useProjectSettings.isSelected());
        this.advanced.setEnabled(this.useProjectSettings.isSelected());
        if (this.useProjectSettings.isSelected()) {
            this.panel.setPerProjectSettings(this.perProjectPreferences);
        } else {
            this.panel.setGlobalSettings();
        }
        this.enableDisableRecursively(this.panelUI, this.useProjectSettings.isSelected());
    }

    private void enableDisableRecursively(Component what, boolean enable) {
        what.setEnabled(enable);
        if (what instanceof Container) {
            for (Component c : ((Container)what).getComponents()) {
                this.enableDisableRecursively(c, enable);
            }
        }
    }

    public ToolPreferences commit() {
        this.projectSettings.setUseProjectSettings(this.useProjectSettings.isSelected());
        if (this.projectSettings.hasLocation()) {
            this.projectSettings.setSettingsFileLocation(this.settingsFileLocation);
        }
        this.panel.applyChanges();
        return this.useProjectSettings.isSelected() && this.toolPreferences != null ? this.toolPreferences : null;
    }

    private void initComponents() {
        this.settingsSourceSelection = new ButtonGroup();
        this.useGlobalSettings = new JRadioButton();
        this.useProjectSettings = new JRadioButton();
        this.advanced = new JButton();
        this.settingsCustomizer = new JPanel();
        this.globalSettings = new JButton();
        this.settingsSourceSelection.add(this.useGlobalSettings);
        Mnemonics.setLocalizedText((AbstractButton)this.useGlobalSettings, (String)NbBundle.getMessage(ProjectHintSettingPanel.class, (String)"ProjectHintSettingPanel.useGlobalSettings.text_1"));
        this.useGlobalSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectHintSettingPanel.this.useGlobalSettingsActionPerformed(evt);
            }
        });
        this.settingsSourceSelection.add(this.useProjectSettings);
        Mnemonics.setLocalizedText((AbstractButton)this.useProjectSettings, (String)NbBundle.getMessage(ProjectHintSettingPanel.class, (String)"ProjectHintSettingPanel.useProjectSettings.text_1"));
        this.useProjectSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectHintSettingPanel.this.useProjectSettingsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.advanced, (String)NbBundle.getMessage(ProjectHintSettingPanel.class, (String)"ProjectHintSettingPanel.advanced.text_1"));
        this.advanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectHintSettingPanel.this.advancedActionPerformed(evt);
            }
        });
        GroupLayout settingsCustomizerLayout = new GroupLayout(this.settingsCustomizer);
        this.settingsCustomizer.setLayout(settingsCustomizerLayout);
        settingsCustomizerLayout.setHorizontalGroup(settingsCustomizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 819, Short.MAX_VALUE));
        settingsCustomizerLayout.setVerticalGroup(settingsCustomizerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 208, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.globalSettings, (String)NbBundle.getMessage(ProjectHintSettingPanel.class, (String)"ProjectHintSettingPanel.globalSettings.text"));
        this.globalSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectHintSettingPanel.this.globalSettingsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsCustomizer, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useGlobalSettings, -1, -1, Short.MAX_VALUE).addComponent(this.useProjectSettings, -1, 618, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.advanced, -1, -1, Short.MAX_VALUE).addComponent(this.globalSettings, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useGlobalSettings).addComponent(this.globalSettings)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useProjectSettings).addComponent(this.advanced)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsCustomizer, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void useGlobalSettingsActionPerformed(ActionEvent evt) {
        this.settingsOriginChanged();
    }

    private void useProjectSettingsActionPerformed(ActionEvent evt) {
        this.settingsOriginChanged();
    }

    private void advancedActionPerformed(ActionEvent evt) {
        AdvancedLocationPanel panel = new AdvancedLocationPanel(this.settingsFileLocation, this.projectSettings);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.CAP_ProjectSpecificOptions(), true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            this.settingsFileLocation = panel.getHintFileLocation();
            this.settingsFileLocationChanged();
            this.settingsOriginChanged();
        }
    }

    private void globalSettingsActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Editor/Hints");
    }

    private void settingsFileLocationChanged() {
        if (this.projectSettings.hasLocation()) {
            final ToolPreferences toolPreferencesFin = this.toolPreferences = this.projectSettings.preferencesFrom(this.settingsFileLocation);
            this.perProjectPreferences = new PerProjectHintsPanel.MimeType2Preferences(){
                final /* synthetic */ ProjectHintSettingPanel this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Preferences getPreferences(String mimeType) {
                    return toolPreferencesFin.getPreferences("hints", mimeType);
                }
            };
        } else {
            this.perProjectPreferences = new PerProjectHintsPanel.MimeType2Preferences(){

                @Override
                public Preferences getPreferences(String mimeType) {
                    return ProjectHintSettingPanel.this.projectSettings.getProjectSettings(mimeType);
                }
            };
        }
    }
}

