/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DbNodeSummary;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListDbNodesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String dbSystemId;
    private String vmClusterId;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private DbNodeSummary.LifecycleState lifecycleState;
    private String dbServerId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public DbNodeSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getDbServerId() {
        return this.dbServerId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).dbSystemId(this.dbSystemId).vmClusterId(this.vmClusterId).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).dbServerId(this.dbServerId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",dbServerId=").append(String.valueOf(this.dbServerId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDbNodesRequest)) {
            return false;
        }
        ListDbNodesRequest other = (ListDbNodesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.dbServerId, other.dbServerId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.dbServerId == null ? 43 : this.dbServerId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbNodesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String dbSystemId = null;
        private String vmClusterId = null;
        private Integer limit = null;
        private String page = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private DbNodeSummary.LifecycleState lifecycleState = null;
        private String dbServerId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(DbNodeSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbNodesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.dbSystemId(o.getDbSystemId());
            this.vmClusterId(o.getVmClusterId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.dbServerId(o.getDbServerId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbNodesRequest build() {
            ListDbNodesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDbNodesRequest buildWithoutInvocationCallback() {
            ListDbNodesRequest request = new ListDbNodesRequest();
            request.compartmentId = this.compartmentId;
            request.dbSystemId = this.dbSystemId;
            request.vmClusterId = this.vmClusterId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.dbServerId = this.dbServerId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

