/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatform;
import org.netbeans.modules.java.j2seembedded.platform.RemotePlatformNode;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RemotePlatformProvider
implements Lookup.Provider,
InstanceCookie.Of,
InstanceContent.Convertor<Class<Node>, Node>,
PropertyChangeListener,
Runnable {
    private static final String PLATFORM_STOREGE = "Services/Platforms/org-netbeans-api-java-Platform";
    private static final Logger LOG = Logger.getLogger(RemotePlatformProvider.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(RemotePlatformProvider.class);
    private static final int SLIDING_WINDOW = 2000;
    private final XMLDataObject store;
    private final RequestProcessor.Task task;
    private final Lookup lkp;
    private Reference<RemotePlatform> platformRef;

    private RemotePlatformProvider(@NonNull XMLDataObject store) {
        Parameters.notNull((CharSequence)"store", (Object)store);
        this.store = store;
        this.store.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(@NonNull FileEvent fe) {
                final String systemName = fe.getFile().getName();
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Void run() throws IOException {
                            String propPrefix = String.format("platforms.%s.", systemName);
                            boolean changed = false;
                            EditableProperties props = PropertyUtils.getGlobalProperties();
                            Iterator it = props.keySet().iterator();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                if (!key.startsWith(propPrefix)) continue;
                                it.remove();
                                changed = true;
                            }
                            if (changed) {
                                PropertyUtils.putGlobalProperties((EditableProperties)props);
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                ConnectionMethod.Authentification.clear(systemName);
            }
        });
        InstanceContent c = new InstanceContent();
        c.add(Node.class, (InstanceContent.Convertor)this);
        c.add((Object)this);
        this.lkp = new AbstractLookup((AbstractLookup.Content)c);
        this.task = RP.create((Runnable)this);
    }

    public Lookup getLookup() {
        return this.lkp;
    }

    public boolean instanceOf(@NonNull Class<?> type) {
        return type.isAssignableFrom(JavaPlatform.class);
    }

    public String instanceName() {
        return this.store.getName();
    }

    @NonNull
    public Class<?> instanceClass() throws IOException, ClassNotFoundException {
        return JavaPlatform.class;
    }

    @NonNull
    public synchronized RemotePlatform instanceCreate() throws IOException, ClassNotFoundException {
        RemotePlatform remotePlatform;
        RemotePlatform remotePlatform2 = remotePlatform = this.platformRef == null ? null : this.platformRef.get();
        if (remotePlatform == null) {
            SAXHandler handler = new SAXHandler();
            try (InputStream in = this.store.getPrimaryFile().getInputStream();){
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(in);
                is.setSystemId(this.store.getPrimaryFile().toURL().toExternalForm());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception x = ex.getException();
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                throw new IOException(ex);
            }
            remotePlatform = RemotePlatform.create(handler.name, handler.properties, handler.sysProperties);
            remotePlatform.addPropertyChangeListener(this);
            this.platformRef = new WeakReference<RemotePlatform>(remotePlatform);
        }
        return remotePlatform;
    }

    public Node convert(Class<Node> clz) {
        try {
            RemotePlatform rp = this.instanceCreate();
            return new RemotePlatformNode(rp, this.store);
        }
        catch (IOException | ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public String displayName(Class<Node> clz) {
        return this.id(clz);
    }

    public String id(Class<Node> clz) {
        return clz.getName();
    }

    public Class<? extends Node> type(Class<Node> clz) {
        return clz;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.task.schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RemotePlatform platform;
        RemotePlatformProvider remotePlatformProvider = this;
        synchronized (remotePlatformProvider) {
            platform = this.platformRef == null ? null : this.platformRef.get();
        }
        if (platform != null) {
            try {
                FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){
                    final /* synthetic */ RemotePlatformProvider this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() throws IOException {
                        RemotePlatformProvider.store(platform, this.this$0.store.getPrimaryFile());
                    }
                });
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    @NonNull
    public static RemotePlatform createNewPlatform(final @NonNull RemotePlatform prototype) throws IOException {
        Parameters.notNull((CharSequence)"prototype", (Object)((Object)prototype));
        final String antName = prototype.getProperties().get("platform.ant.name");
        if (antName == null) {
            throw new IllegalArgumentException("Platform has no platform.ant.name attribute.");
        }
        final RemotePlatform[] res = new RemotePlatform[1];
        FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject platformsFolder = FileUtil.getConfigFile((String)RemotePlatformProvider.PLATFORM_STOREGE);
                if (platformsFolder.getFileObject(antName, "xml") != null) {
                    throw new IllegalArgumentException("Platform with ant name: " + antName + "already exists.");
                }
                FileObject target = platformsFolder.createData(antName, "xml");
                RemotePlatformProvider.store(prototype, target);
                DataObject dobj = DataObject.find((FileObject)target);
                res[0] = (RemotePlatform)((Object)dobj.getNodeDelegate().getLookup().lookup(RemotePlatform.class));
            }
        });
        assert (res[0] != null);
        return res[0];
    }

    public static boolean isValidPlatformAntName(@NonNull String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        FileObject platformsFolder = FileUtil.getConfigFile((String)PLATFORM_STOREGE);
        return platformsFolder.getFileObject(name, "xml") == null;
    }

    private static void store(@NonNull RemotePlatform platform, @NonNull FileObject target) throws IOException {
        RemotePlatformProvider.storePlatformDefinition(platform, target);
        RemotePlatformProvider.updateBuildProperties(platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storePlatformDefinition(@NonNull RemotePlatform platform, @NonNull FileObject target) throws IOException {
        FileLock lock = target.lock();
        try (OutputStream out = target.getOutputStream(lock);){
            SAXHandler.write(out, platform);
        }
        finally {
            lock.releaseLock();
        }
    }

    private static void updateBuildProperties(final @NonNull RemotePlatform platform) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    Map<String, String> props = platform.getProperties();
                    String antPlatformName = props.get("platform.ant.name");
                    EditableProperties ep = PropertyUtils.getGlobalProperties();
                    for (String key : platform.getGlobalPropertyNames()) {
                        String value = props.get(key);
                        if (value != null) {
                            ep.setProperty(RemotePlatformProvider.createPropertyName(antPlatformName, key), value);
                            continue;
                        }
                        ep.remove((Object)RemotePlatformProvider.createPropertyName(antPlatformName, key));
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)ep);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            if (me.getCause() instanceof IOException) {
                throw (IOException)me.getCause();
            }
            throw new IOException(me);
        }
    }

    @NonNull
    static String createPropertyName(@NonNull String antPlatformName, @NonNull String propName) {
        return String.format("platforms.%s.%s", antPlatformName, propName);
    }

    private static final class SAXHandler
    extends DefaultHandler
    implements EntityResolver {
        private static final String REMOTE_PLATFORM_DTD_ID = "-//NetBeans//DTD Remote Java Platform Definition 1.0//EN";
        private static final String REMOTE_PLATFORM_SYSTEM_ID = "http://www.netbeans.org/dtds/remote-java-platformdefinition-1_0.dtd";
        private static final String ELM_PLATFORM = "platform";
        private static final String ELM_PROPERTIES = "properties";
        private static final String ELM_SYSPROPERTIES = "sysproperties";
        private static final String ELM_PROPERTY = "property";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_VALUE = "value";
        Map<String, String> properties = Collections.emptyMap();
        Map<String, String> sysProperties = Collections.emptyMap();
        String name;
        private Map<String, String> active;

        private SAXHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(@NonNull String uri, @NonNull String localName, @NonNull String qName, @NonNull Attributes attrs) throws SAXException {
            if (ELM_PLATFORM.equals(qName)) {
                this.name = attrs.getValue(ATTR_NAME);
                if (this.name == null || this.name.isEmpty()) {
                    throw new SAXException("Missing mandatory platform name.");
                }
            } else if (ELM_PROPERTIES.equals(qName)) {
                this.properties = new HashMap<String, String>();
                this.active = this.properties;
            } else if (ELM_SYSPROPERTIES.equals(qName)) {
                this.sysProperties = new HashMap<String, String>();
                this.active = this.sysProperties;
            } else if (ELM_PROPERTY.equals(qName)) {
                if (this.active == null) {
                    throw new SAXException("property outside properties or sysproperties");
                }
                String name = attrs.getValue(ATTR_NAME);
                if (name == null || name.isEmpty()) {
                    throw new SAXException("Missing mandatory property name.");
                }
                String val = attrs.getValue(ATTR_VALUE);
                this.active.put(name, val);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ELM_PROPERTIES.equals(qName) || ELM_SYSPROPERTIES.equals(qName)) {
                this.active = null;
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (REMOTE_PLATFORM_DTD_ID.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        static void write(@NonNull OutputStream out, @NonNull RemotePlatform platform) throws IOException {
            Parameters.notNull((CharSequence)"out", (Object)out);
            Parameters.notNull((CharSequence)ELM_PLATFORM, (Object)((Object)platform));
            Document doc = XMLUtil.createDocument((String)ELM_PLATFORM, null, (String)REMOTE_PLATFORM_DTD_ID, (String)REMOTE_PLATFORM_SYSTEM_ID);
            Element platformElement = doc.getDocumentElement();
            platformElement.setAttribute(ATTR_NAME, platform.getDisplayName());
            Map<String, String> props = platform.getProperties();
            Element propsElement = doc.createElement(ELM_PROPERTIES);
            SAXHandler.writeProperties(props, propsElement, doc);
            platformElement.appendChild(propsElement);
            Map sysProps = platform.getSystemProperties();
            Element sysPropsElement = doc.createElement(ELM_SYSPROPERTIES);
            SAXHandler.writeProperties(sysProps, sysPropsElement, doc);
            platformElement.appendChild(sysPropsElement);
            XMLUtil.write((Document)doc, (OutputStream)out, (String)"UTF8");
        }

        private static void writeProperties(@NonNull Map<String, String> props, @NonNull Element element, @NonNull Document doc) throws IOException {
            TreeSet<String> sortedProps = new TreeSet<String>(props.keySet());
            for (String name : sortedProps) {
                String val = props.get(name);
                try {
                    XMLUtil.toAttributeValue((String)name);
                    XMLUtil.toAttributeValue((String)val);
                    Element propElement = doc.createElement(ELM_PROPERTY);
                    propElement.setAttribute(ATTR_NAME, name);
                    propElement.setAttribute(ATTR_VALUE, val);
                    element.appendChild(propElement);
                }
                catch (CharConversionException e) {
                    LOG.log(Level.WARNING, "Cannot store property: {0} value: {1}", new Object[]{name, val});
                }
            }
        }
    }

    public static class Env
    implements Environment.Provider {
        private Env() {
        }

        public Lookup getEnvironment(DataObject obj) {
            return new RemotePlatformProvider((XMLDataObject)obj).getLookup();
        }

        public static Env create(FileObject def) {
            return new Env();
        }
    }
}

