/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.ui.JFXPreloaderChooserWizard;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JFXPreloaderChooserWizardPanel2
implements WizardDescriptor.Panel<JFXPreloaderChooserWizard> {
    private static final Icon JAR_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/javawebstart/resources/jar.gif", (boolean)false);
    private JFileChooser projectChooser;
    private static String lastProjectDirectoryUsed;
    private JFileChooser jarFileChooser;
    private static String lastJARDirectoryUsed;
    private JFXProjectProperties.PreloaderSourceType sourceType = JFXProjectProperties.PreloaderSourceType.NONE;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    JFXPreloaderChooserWizardPanel2(JFXProjectProperties.PreloaderSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public Component getComponent() {
        if (this.sourceType == JFXProjectProperties.PreloaderSourceType.PROJECT) {
            if (this.projectChooser == null) {
                this.projectChooser = ProjectChooser.projectChooser();
                this.projectChooser.setPreferredSize(new Dimension(400, 300));
                this.projectChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.projectChooser.setName(NbBundle.getMessage(JFXPreloaderChooserWizardPanel2.class, (String)"CTL_SelectProject_Caption"));
                this.projectChooser.putClientProperty("WizardPanel_contentSelectedIndex", 1);
                if (lastProjectDirectoryUsed != null) {
                    this.projectChooser.setCurrentDirectory(new File(lastProjectDirectoryUsed));
                }
                this.projectChooser.setControlButtonsAreShown(false);
                this.projectChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        String propName = ev.getPropertyName();
                        if ("SelectedFileChangedProperty".equals(propName) || "directoryChanged".equals(propName)) {
                            JFXPreloaderChooserWizardPanel2.this.cs.fireChange();
                        }
                    }
                });
            }
            return this.projectChooser;
        }
        if (this.sourceType == JFXProjectProperties.PreloaderSourceType.JAR) {
            if (this.jarFileChooser == null) {
                this.jarFileChooser = new JFileChooser(lastJARDirectoryUsed);
                this.jarFileChooser.setFileView(new JARFileView());
                this.jarFileChooser.setPreferredSize(new Dimension(400, 300));
                this.jarFileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.jarFileChooser.setName(NbBundle.getMessage(JFXPreloaderChooserWizardPanel2.class, (String)"CTL_SelectJAR_Caption"));
                this.jarFileChooser.putClientProperty("WizardPanel_contentSelectedIndex", 1);
                this.jarFileChooser.setFileSelectionMode(0);
                this.jarFileChooser.setAcceptAllFileFilterUsed(true);
                this.jarFileChooser.setControlButtonsAreShown(false);
                this.jarFileChooser.setMultiSelectionEnabled(false);
                this.jarFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar");
                    }

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(JFXPreloaderChooserWizardPanel2.class, (String)"CTL_JarArchivesMask");
                    }
                });
                this.jarFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        String propName = ev.getPropertyName();
                        if ("SelectedFileChangedProperty".equals(propName) || "directoryChanged".equals(propName)) {
                            JFXPreloaderChooserWizardPanel2.this.cs.fireChange();
                        }
                    }
                });
                this.jarFileChooser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXPreloaderChooserWizardPanel2.class, (String)"CTL_SelectJAR_Step"));
            }
            return this.jarFileChooser;
        }
        return null;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        FileObject projectDir;
        File file;
        if (this.sourceType == JFXProjectProperties.PreloaderSourceType.PROJECT && this.projectChooser != null && (file = this.projectChooser.getSelectedFile()) != null && (projectDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file))) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(projectDir);
                if (project != null) {
                    lastProjectDirectoryUsed = this.projectChooser.getCurrentDirectory().getAbsolutePath();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sourceType == JFXProjectProperties.PreloaderSourceType.JAR && this.jarFileChooser != null && this.jarFileChooser.getSelectedFile() != null) {
            lastJARDirectoryUsed = this.jarFileChooser.getCurrentDirectory().getAbsolutePath();
            return true;
        }
        return false;
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void readSettings(JFXPreloaderChooserWizard settings) {
    }

    public void storeSettings(JFXPreloaderChooserWizard settings) {
        File file;
        if (this.projectChooser != null) {
            file = this.projectChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            FileObject projectDir = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (projectDir == null) {
                return;
            }
            Project project = null;
            try {
                project = ProjectManager.getDefault().findProject(projectDir);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            if (project == null) {
                return;
            }
            settings.setSourceType(JFXProjectProperties.PreloaderSourceType.PROJECT);
            settings.setSelectedSource(file);
        }
        if (this.jarFileChooser != null) {
            file = this.jarFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            settings.setSourceType(JFXProjectProperties.PreloaderSourceType.JAR);
            settings.setSelectedSource(file);
        }
    }

    public void setSourceType(JFXProjectProperties.PreloaderSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public JFXProjectProperties.PreloaderSourceType getSourceType() {
        return this.sourceType;
    }

    private class JARFileView
    extends FileView {
        private JARFileView() {
        }

        @Override
        public Icon getIcon(File f) {
            if (f.getName().toLowerCase().endsWith(".jar")) {
                return JAR_ICON;
            }
            return super.getIcon(f);
        }
    }
}

