/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static StringBuilder getCapitalizedName(CharSequence cs) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(1))) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb;
    }

    public static void guardedCommit(JTextComponent component, ModificationResult mr) throws IOException {
        block2: {
            try {
                mr.commit();
            }
            catch (IOException e) {
                if (!(e.getCause() instanceof GuardedException)) break block2;
                String message = NbBundle.getMessage(GeneratorUtils.class, (String)"ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText((JTextComponent)component, (String)message);
                Logger.getLogger(GeneratorUtils.class.getName()).log(Level.FINE, null, e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ClassTree insertClassMembers(WorkingCopy wc, ClassTree clazz, List<? extends Tree> members, int offset) throws IllegalStateException {
        void var9_12;
        if (offset < 0 || GeneratorUtils.getCodeStyle((CompilationInfo)wc).getClassMemberInsertionPoint() != CodeStyle.InsertionPoint.CARET_LOCATION) {
            return GeneratorUtilities.get((WorkingCopy)wc).insertClassMembers(clazz, members);
        }
        int index = 0;
        SourcePositions sp = wc.getTrees().getSourcePositions();
        GuardedDocument gdoc = null;
        try {
            Document doc = wc.getDocument();
            if (doc instanceof GuardedDocument) {
                gdoc = (GuardedDocument)doc;
            }
        }
        catch (IOException doc) {
            // empty catch block
        }
        Tree lastMember = null;
        for (Tree tree : clazz.getMembers()) {
            if ((long)offset <= sp.getStartPosition(wc.getCompilationUnit(), tree)) {
                if (gdoc == null) break;
                int pos = (int)(lastMember != null ? sp.getEndPosition(wc.getCompilationUnit(), lastMember) : sp.getStartPosition(wc.getCompilationUnit(), clazz));
                pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                if ((long)pos <= sp.getStartPosition(wc.getCompilationUnit(), tree)) break;
            }
            ++index;
            lastMember = tree;
        }
        TreeMaker tm = wc.getTreeMaker();
        int n = members.size() - 1;
        while (var9_12 >= 0) {
            clazz = tm.insertClassMember(clazz, index, members.get((int)var9_12));
            --var9_12;
        }
        return clazz;
    }

    private static CodeStyle getCodeStyle(CompilationInfo info) {
        if (info != null) {
            try {
                Document doc = info.getDocument();
                if (doc != null) {
                    CodeStyle cs = (CodeStyle)doc.getProperty(CodeStyle.class);
                    return cs != null ? cs : CodeStyle.getDefault((Document)doc);
                }
            }
            catch (IOException doc) {
                // empty catch block
            }
            FileObject file = info.getFileObject();
            if (file != null) {
                return CodeStyle.getDefault((FileObject)file);
            }
        }
        return CodeStyle.getDefault((Document)null);
    }
}

