/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui.picker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.modules.web.browser.ui.picker.ListItem;
import org.netbeans.modules.web.browser.ui.picker.SelectionList;
import org.netbeans.modules.web.browser.ui.picker.SelectionListFactory;
import org.netbeans.modules.web.browser.ui.picker.SelectionModel;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class BrowserMenu
implements ChangeListener {
    private final ProjectBrowserProvider browserProvider;
    private final Collection<WebBrowser> browsers;
    private final SelectionListFactory factory;
    private final SelectionModel selModel;
    private JPopupMenu popup;
    private WebBrowser selectedBrowser;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final boolean windowsLaF = "Windows".equals(UIManager.getLookAndFeel().getID());
    static final boolean GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    private final Color windowsSeparatorColor = UIManager.getColor("controlHighlight");

    public BrowserMenu(ProjectBrowserProvider provider) {
        this(provider.getBrowsers(), provider.getActiveBrowser(), provider);
    }

    public BrowserMenu(Collection<WebBrowser> browsers, WebBrowser selectedBrowser) {
        this(browsers, selectedBrowser, null);
    }

    private BrowserMenu(Collection<WebBrowser> browsers, WebBrowser selectedBrowser, ProjectBrowserProvider provider) {
        this.browsers = browsers;
        this.browserProvider = provider;
        this.selectedBrowser = selectedBrowser;
        this.factory = SelectionListFactory.create();
        this.selModel = this.factory.getSelectionModel();
    }

    public void show(JComponent invoker, int x, int y) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        this.fillContent(panel);
        this.popup = new JPopupMenu();
        this.popup.add(panel);
        if (windowsLaF) {
            this.popup.setBorder(BorderFactory.createLineBorder(this.windowsSeparatorColor.darker()));
        }
        this.popup.show(invoker, x, y);
    }

    private void fillContent(JPanel contentPanel) {
        contentPanel.setLayout(new GridBagLayout());
        WebBrowser activeBrowser = this.selectedBrowser;
        ArrayList<ListItemImpl> defaultItems = new ArrayList<ListItemImpl>(this.browsers.size());
        ArrayList<ListItemImpl> mobileItems = new ArrayList<ListItemImpl>(this.browsers.size());
        ArrayList<ListItemImpl> phoneGapItems = new ArrayList<ListItemImpl>(this.browsers.size());
        ListItemImpl selItem = null;
        for (WebBrowser browser : this.browsers) {
            ListItemImpl item = new ListItemImpl(browser);
            if (null != activeBrowser && activeBrowser.getId().equals(browser.getId())) {
                selItem = item;
            }
            if (BrowserFamilyId.PHONEGAP.equals((Object)browser.getBrowserFamily())) {
                phoneGapItems.add(item);
                continue;
            }
            if (browser.getBrowserFamily().isMobile()) {
                mobileItems.add(item);
                continue;
            }
            defaultItems.add(item);
        }
        this.addSection(contentPanel, defaultItems, NbBundle.getMessage(BrowserMenu.class, (String)"Header_BROWSER"), 0, null, mobileItems.isEmpty() && phoneGapItems.isEmpty());
        this.addSection(contentPanel, mobileItems, NbBundle.getMessage(BrowserMenu.class, (String)"Header_MOBILE"), 2, null, phoneGapItems.isEmpty());
        this.addSection(contentPanel, phoneGapItems, NbBundle.getMessage(BrowserMenu.class, (String)"Header_PHONEGAP"), 4, this.createConfigureButton(), true);
        JPanel panel = this.createBrighterPanel();
        JLabel label = this.createLabel(NbBundle.getMessage(BrowserMenu.class, (String)"Hint_NB_Connector"));
        Color lightForeground = UIManager.getColor("Nb.browser.picker.foreground.light");
        if (null != lightForeground) {
            label.setForeground(lightForeground);
        }
        if (windowsLaF) {
            label.setEnabled(false);
            panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, this.windowsSeparatorColor));
        }
        label.setBorder(BorderFactory.createEmptyBorder(16, 17, 5, 5));
        panel.add((Component)label, "West");
        contentPanel.add((Component)panel, new GridBagConstraints(0, 1, 0, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (!(defaultItems.isEmpty() || mobileItems.isEmpty() || windowsLaF)) {
            contentPanel.add((Component)new JSeparator(1), new GridBagConstraints(1, 1, 1, 3, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (!(mobileItems.isEmpty() || phoneGapItems.isEmpty() || windowsLaF)) {
            contentPanel.add((Component)new JSeparator(1), new GridBagConstraints(3, 1, 1, 3, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (!phoneGapItems.isEmpty()) {
            contentPanel.add((Component)this.createLabel(NbBundle.getMessage(BrowserMenu.class, (String)"Hint_PhoneGap")), new GridBagConstraints(0, 4, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 17, 10, 10), 0, 0));
        }
        if (null != selItem) {
            this.selModel.setSelectedItem(selItem);
        }
        this.selModel.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ListItem selItem = this.selModel.getSelectedItem();
        if (null == selItem) {
            return;
        }
        this.popup.setVisible(false);
        this.selectedBrowser = ((ListItemImpl)selItem).browser;
        this.changeSupport.fireChange();
    }

    private JComponent createList(List<ListItemImpl> items, boolean nbIntegrationOnly) {
        if (items.isEmpty()) {
            return null;
        }
        ArrayList<ListItemImpl> filteredItems = new ArrayList<ListItemImpl>(items.size());
        for (ListItemImpl li : items) {
            if (li.browser.hasNetBeansIntegration() != nbIntegrationOnly) continue;
            filteredItems.add(li);
        }
        if (filteredItems.isEmpty()) {
            return null;
        }
        SelectionList list = this.factory.createSelectionList();
        list.setItems(filteredItems);
        return list.getComponent();
    }

    private void addSection(JPanel contentPanel, List<ListItemImpl> items, String header, int column, JComponent bottomPart, boolean isLast) {
        if (items.isEmpty()) {
            return;
        }
        contentPanel.add((Component)this.createHeader(header), new GridBagConstraints(column, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 17, 15, 10), 0, 0));
        JPanel panel = this.createBrighterPanel();
        if (windowsLaF) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.windowsSeparatorColor), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        } else {
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        if (windowsLaF && !isLast) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, this.windowsSeparatorColor), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        }
        contentPanel.add((Component)panel, new GridBagConstraints(column, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        JComponent list = this.createList(items, true);
        if (null != list) {
            panel.add((Component)list, "Center");
        }
        panel = new JPanel(new BorderLayout(0, 5));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 10, 10, 10));
        list = this.createList(items, false);
        if (null != list) {
            panel.add((Component)list, "Center");
        }
        if (null != bottomPart) {
            panel.add((Component)bottomPart, "South");
        }
        if (windowsLaF && !isLast) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.windowsSeparatorColor), BorderFactory.createEmptyBorder(18, 10, 10, 10)));
        }
        if (null != bottomPart || null != list) {
            contentPanel.add((Component)panel, new GridBagConstraints(column, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    private JComponent createHeader(String title) {
        JLabel label = this.createLabel(title);
        Font defaultFont = label.getFont();
        label.setFont(defaultFont.deriveFont(1).deriveFont(defaultFont.getSize2D() + 2.0f));
        return label;
    }

    private JComponent createConfigureButton() {
        if (null == this.browserProvider || !this.browserProvider.hasCustomizer()) {
            return null;
        }
        JButton button = new JButton(NbBundle.getMessage(BrowserMenu.class, (String)"Ctl_ConfigurePhoneGap"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserMenu.this.browserProvider.customize();
            }
        });
        button.setBorder(new EmptyBorder(1, 1, 1, 1));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.setHorizontalAlignment(2);
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setRolloverEnabled(true);
        button.setContentAreaFilled(false);
        return button;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public WebBrowser getSelectedBrowser() {
        return this.selectedBrowser;
    }

    private JPanel createBrighterPanel() {
        JPanel res = new JPanel(new BorderLayout());
        Color background = UIManager.getColor("Nb.browser.picker.background.light");
        if (null != background) {
            res.setOpaque(true);
            res.setBackground(background);
        } else {
            res.setOpaque(false);
        }
        return res;
    }

    private JLabel createLabel(String text) {
        Color foreground;
        JLabel res = new JLabel(text);
        if (GTK && null != (foreground = UIManager.getColor("MenuItem.foreground"))) {
            res.setForeground(new Color(foreground.getRGB()));
        }
        return res;
    }

    private static class ListItemImpl
    extends ListItem {
        private final WebBrowser browser;

        public ListItemImpl(WebBrowser browser) {
            this.browser = browser;
        }

        @Override
        public Icon getIcon() {
            return ImageUtilities.image2Icon((Image)this.browser.getIconImage(false));
        }

        @Override
        public String getText() {
            return this.browser.getName();
        }
    }
}

