/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.projectimport.eclipse.core.DotClassPath;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.Link;
import org.netbeans.modules.projectimport.eclipse.core.spi.DotClassPathEntry;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class DotClassPathParser {
    private DotClassPathParser() {
    }

    public static DotClassPath parse(File dotClasspath, List<Link> links) throws IOException {
        List classpathEntryEls;
        Document dotClasspathXml;
        try {
            dotClasspathXml = XMLUtil.parse((InputSource)new InputSource(Utilities.toURI((File)dotClasspath).toString()), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException(dotClasspath + ": " + e.toString()).initCause(e);
            throw ioe;
        }
        Element classpathEl = dotClasspathXml.getDocumentElement();
        if (!"classpath".equals(classpathEl.getLocalName())) {
            return DotClassPathParser.empty();
        }
        try {
            classpathEntryEls = XMLUtil.findSubElements((Element)classpathEl);
        }
        catch (IllegalArgumentException x) {
            throw new IOException(x);
        }
        if (classpathEntryEls == null) {
            return DotClassPathParser.empty();
        }
        ArrayList<DotClassPathEntry> classpath = new ArrayList<DotClassPathEntry>();
        ArrayList<DotClassPathEntry> sources = new ArrayList<DotClassPathEntry>();
        DotClassPathEntry output = null;
        DotClassPathEntry jre = null;
        for (Element classpathEntry : classpathEntryEls) {
            DotClassPathEntry entry;
            List attrsList;
            HashMap<String, String> props = new HashMap<String, String>();
            NamedNodeMap attrs = classpathEntry.getAttributes();
            String linkName = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String resolvedLink;
                Node n = attrs.item(i);
                String key = n.getNodeName();
                String value = classpathEntry.getAttribute(n.getNodeName());
                if ("path".equals(key) && (resolvedLink = DotClassPathParser.resolveLink(value, links)) != null) {
                    linkName = value;
                    value = resolvedLink;
                }
                props.put(key, value);
            }
            Element entryAttrs = XMLUtil.findElement((Element)classpathEntry, (String)"attributes", null);
            if (entryAttrs != null && (attrsList = XMLUtil.findSubElements((Element)entryAttrs)) != null) {
                for (Element e : attrsList) {
                    props.put(e.getAttribute("name"), e.getAttribute("value"));
                }
            }
            if ((entry = new DotClassPathEntry(props, linkName)).getKind() == DotClassPathEntry.Kind.SOURCE) {
                sources.add(entry);
                continue;
            }
            if (entry.getKind() == DotClassPathEntry.Kind.OUTPUT) {
                assert (output == null) : "there should be always just one default output";
                output = entry;
                continue;
            }
            if (entry.getKind() == DotClassPathEntry.Kind.CONTAINER && entry.getRawPath().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                jre = entry;
                continue;
            }
            classpath.add(entry);
        }
        return new DotClassPath(classpath, sources, output, jre);
    }

    static DotClassPath empty() {
        return new DotClassPath(new ArrayList<DotClassPathEntry>(), new ArrayList<DotClassPathEntry>(), null, null);
    }

    private static String resolveLink(String value, List<Link> links) {
        String[] v = EclipseUtils.splitVariable(value);
        for (Link l : links) {
            if (!l.getName().equals(v[0])) continue;
            return l.getLocation() + v[1];
        }
        return null;
    }
}

