/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;

class DocAndScoreQuery
extends Query {
    private final int[] docs;
    private final float[] scores;
    private final float maxScore;
    private final int[] segmentStarts;
    private final long visited;
    private final Object contextIdentity;

    DocAndScoreQuery(int[] docs, float[] scores, float maxScore, int[] segmentStarts, long visited, Object contextIdentity) {
        this.docs = docs;
        this.scores = scores;
        this.maxScore = maxScore;
        this.segmentStarts = segmentStarts;
        this.visited = visited;
        this.contextIdentity = contextIdentity;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (searcher.getIndexReader().getContext().id() != this.contextIdentity) {
            throw new IllegalStateException("This DocAndScore query was created by a different reader");
        }
        return new Weight(this){

            @Override
            public Explanation explain(LeafReaderContext context, int doc) {
                int found = Arrays.binarySearch(DocAndScoreQuery.this.docs, doc + context.docBase);
                if (found < 0) {
                    return Explanation.noMatch("not in top " + DocAndScoreQuery.this.docs.length + " docs", new Explanation[0]);
                }
                return Explanation.match((Number)Float.valueOf(DocAndScoreQuery.this.scores[found] * boost), "within top " + DocAndScoreQuery.this.docs.length + " docs", new Explanation[0]);
            }

            @Override
            public int count(LeafReaderContext context) {
                return DocAndScoreQuery.this.segmentStarts[context.ord + 1] - DocAndScoreQuery.this.segmentStarts[context.ord];
            }

            @Override
            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                if (DocAndScoreQuery.this.segmentStarts[context.ord] == DocAndScoreQuery.this.segmentStarts[context.ord + 1]) {
                    return null;
                }
                Scorer scorer = new Scorer(){
                    final int lower;
                    final int upper;
                    int upTo;
                    {
                        this.lower = DocAndScoreQuery.this.segmentStarts[context.ord];
                        this.upper = DocAndScoreQuery.this.segmentStarts[context.ord + 1];
                        this.upTo = -1;
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){

                            @Override
                            public int docID() {
                                return this.docIdNoShadow();
                            }

                            @Override
                            public int nextDoc() {
                                upTo = upTo == -1 ? lower : ++upTo;
                                return this.docIdNoShadow();
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                return this.slowAdvance(target);
                            }

                            @Override
                            public long cost() {
                                return upper - lower;
                            }
                        };
                    }

                    @Override
                    public float getMaxScore(int docId) {
                        return DocAndScoreQuery.this.maxScore * boost;
                    }

                    @Override
                    public float score() {
                        return DocAndScoreQuery.this.scores[this.upTo] * boost;
                    }

                    private int docIdNoShadow() {
                        if (this.upTo == -1) {
                            return -1;
                        }
                        if (this.upTo >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return DocAndScoreQuery.this.docs[this.upTo] - context.docBase;
                    }

                    @Override
                    public int docID() {
                        return this.docIdNoShadow();
                    }
                };
                return new Weight.DefaultScorerSupplier(scorer);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public long visited() {
        return this.visited;
    }

    @Override
    public String toString(String field) {
        return "DocAndScoreQuery[" + this.docs[0] + ",...][" + this.scores[0] + ",...]," + this.maxScore;
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return this.contextIdentity == ((DocAndScoreQuery)obj).contextIdentity && Arrays.equals(this.docs, ((DocAndScoreQuery)obj).docs) && Arrays.equals(this.scores, ((DocAndScoreQuery)obj).scores);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.contextIdentity, Arrays.hashCode(this.docs), Arrays.hashCode(this.scores));
    }

    static Query createDocAndScoreQuery(IndexReader reader, TopDocs topK) {
        int len = topK.scoreDocs.length;
        assert (len > 0);
        float maxScore = topK.scoreDocs[0].score;
        Arrays.sort(topK.scoreDocs, Comparator.comparingInt(a -> a.doc));
        int[] docs = new int[len];
        float[] scores = new float[len];
        for (int i = 0; i < len; ++i) {
            docs[i] = topK.scoreDocs[i].doc;
            scores[i] = topK.scoreDocs[i].score;
        }
        int[] segmentStarts = DocAndScoreQuery.findSegmentStarts(reader.leaves(), docs);
        return new DocAndScoreQuery(docs, scores, maxScore, segmentStarts, topK.totalHits.value(), reader.getContext().id());
    }

    static int[] findSegmentStarts(List<LeafReaderContext> leaves, int[] docs) {
        int[] starts = new int[leaves.size() + 1];
        starts[starts.length - 1] = docs.length;
        if (starts.length == 2) {
            return starts;
        }
        int resultIndex = 0;
        for (int i = 1; i < starts.length - 1; ++i) {
            int upper = leaves.get((int)i).docBase;
            if ((resultIndex = Arrays.binarySearch(docs, resultIndex, docs.length, upper)) < 0) {
                resultIndex = -1 - resultIndex;
            }
            starts[i] = resultIndex;
        }
        return starts;
    }
}

