/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.profile;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.opensearch.knn.index.query.ExactSearcher;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.memoryoptsearch.MemoryOptimizedKNNWeight;
import org.opensearch.knn.profile.KNNProfileUtil;
import org.opensearch.knn.profile.LongMetric;
import org.opensearch.knn.profile.query.KNNQueryTimingType;
import org.opensearch.search.profile.ContextualProfileBreakdown;

public class ProfileMemoryOptKNNWeight
extends MemoryOptimizedKNNWeight {
    protected final ContextualProfileBreakdown profile;

    public ProfileMemoryOptKNNWeight(KNNQuery query, float boost, Weight filterWeight, IndexSearcher searcher, int k, ContextualProfileBreakdown profile) {
        super(query, boost, filterWeight, searcher, k);
        this.profile = profile;
    }

    @Override
    protected BitSet getFilteredDocsBitSet(LeafReaderContext ctx) throws IOException {
        BitSet filterBitSet = (BitSet)KNNProfileUtil.profileBreakdown(this.profile, ctx, KNNQueryTimingType.BITSET_CREATION, () -> super.getFilteredDocsBitSet(ctx));
        LongMetric cardMetric = (LongMetric)this.profile.context((Object)ctx).getMetric("cardinality");
        cardMetric.setValue(Long.valueOf(filterBitSet.cardinality()));
        return filterBitSet;
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, BitSet filterIdsBitSet, int cardinality, int k) throws IOException {
        return (TopDocs)KNNProfileUtil.profileBreakdown(this.profile, context, KNNQueryTimingType.ANN_SEARCH, () -> super.approximateSearch(context, filterIdsBitSet, cardinality, k));
    }

    @Override
    public TopDocs exactSearch(LeafReaderContext leafReaderContext, ExactSearcher.ExactSearcherContext exactSearcherContext) throws IOException {
        return (TopDocs)KNNProfileUtil.profileBreakdown(this.profile, leafReaderContext, KNNQueryTimingType.EXACT_SEARCH, () -> super.exactSearch(leafReaderContext, exactSearcherContext));
    }
}

