/**
 * ./src/lib/select_keyboard_model.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import inquirer from 'inquirer';
import Keyboards from '../../classes/keyboards.js';
/**
 *
 */
export default async function selectKeyboardModel(selected = '') {
    const keyboards = new Keyboards();
    const models = keyboards.getModels();
    const supported = [];
    for (const m of models) {
        supported.push(m.code);
    }
    const questions = [
        {
            choices: supported,
            default: selected,
            message: 'Select model: ',
            name: 'model',
            type: 'list'
        }
    ];
    return new Promise((resolve) => {
        inquirer.prompt(questions).then((options) => {
            resolve(options.model);
        });
    });
}
