# 11 "tools/coqdep/lib/lexer.mll"
 

  open Filename
  open Lexing

  type qualid = string list

  type load = Logical of string | Physical of string

  type coq_token =
    | Require of qualid option * qualid list
    | Declare of string list
    | Load of load
    | External of qualid * string

  exception Fin_fichier
  exception Syntax_error of int*int

  let unquote_string s =
    String.sub s 1 (String.length s - 2)

  let unquote_vfile_string s =
    let f = unquote_string s in
    if check_suffix f ".v" then chop_suffix f ".v" else f

  let backtrack lexbuf = lexbuf.lex_curr_pos <- lexbuf.lex_start_pos;
    lexbuf.lex_curr_p <- lexbuf.lex_start_p

  let syntax_error lexbuf =
    raise (Syntax_error (Lexing.lexeme_start lexbuf, Lexing.lexeme_end lexbuf))

  let check_valid lexbuf s =
    match Unicode.ident_refutation s with
    | None -> s
    | Some _ -> syntax_error lexbuf

  let get_ident lexbuf =
    let s = Lexing.lexeme lexbuf in check_valid lexbuf s

  let get_field_name lexbuf =
    let s = Lexing.lexeme lexbuf in
    check_valid lexbuf (String.sub s 1 (String.length s - 1))


# 47 "tools/coqdep/lib/lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\243\255\244\255\000\000\002\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\001\000\000\000\000\000\001\000\001\000\
    \002\000\007\000\009\000\000\000\000\000\001\000\000\000\014\000\
    \020\000\003\000\008\000\001\000\013\000\002\000\017\000\034\000\
    \045\000\002\000\040\000\047\000\008\000\020\000\004\000\015\000\
    \024\000\117\000\119\000\124\000\126\000\032\000\030\000\043\000\
    \027\000\041\000\134\000\144\000\004\000\150\000\152\000\034\000\
    \046\000\031\000\042\000\051\000\158\000\160\000\046\000\063\000\
    \165\000\055\000\170\000\061\000\176\000\185\000\196\000\178\000\
    \070\000\084\000\190\000\245\000\087\000\092\000\103\000\097\000\
    \095\000\097\000\250\000\252\000\099\000\103\000\106\000\001\001\
    \003\001\247\255\245\255\185\000\252\255\017\000\254\255\003\000\
    \255\255\253\255\025\000\067\001\251\255\252\255\195\001\014\001\
    \006\000\255\255\021\001\029\000\253\255\027\001\019\000\255\255\
    \039\000\252\255\234\001\250\255\251\255\032\001\096\000\109\000\
    \020\000\255\255\108\000\112\000\110\000\110\000\123\001\115\000\
    \119\000\117\000\116\000\125\001\002\002\251\255\123\000\156\000\
    \130\001\022\000\255\255\151\000\154\000\169\000\161\000\187\000\
    \132\001\137\001\178\000\185\000\203\000\139\001\004\002\202\000\
    \192\000\204\000\196\000\207\000\207\000\200\000\213\000\192\000\
    \157\001\251\001\023\001\249\255\250\255\142\001\024\000\027\000\
    \255\255\254\255\004\002\032\000\253\255\025\002\035\000\252\255\
    \037\002\036\000\251\255\113\001\251\255\252\255\253\255\039\000\
    \255\255\003\003\252\255\253\255\131\003\058\000\255\255\060\000\
    \009\004\250\255\251\255\137\004\016\002\090\002\041\000\255\255\
    \254\255\095\002\128\001\252\255\253\255\102\002\043\000\255\255\
    \254\255\036\002\098\001\253\255\254\255\116\002\255\255\123\002\
    \170\002\251\255\252\255\015\005\128\002\044\000\255\255\143\005\
    \021\006\250\255\251\255\149\006\130\002\045\000\255\255\179\002\
    \251\255\252\255\117\001\047\000\136\002\254\255\253\255\131\001\
    ";
  Lexing.lex_backtrk =
   "\255\255\255\255\255\255\012\000\009\000\012\000\012\000\012\000\
    \012\000\012\000\012\000\012\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\001\000\255\255\003\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\002\000\255\255\255\255\
    \255\255\255\255\004\000\255\255\255\255\255\255\255\255\005\000\
    \255\255\255\255\255\255\006\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \007\000\255\255\255\255\255\255\255\255\003\000\255\255\003\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\002\000\001\000\
    \004\000\255\255\255\255\255\255\255\255\001\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\005\000\005\000\
    \005\000\255\255\255\255\255\255\255\255\255\255\001\000\255\255\
    \255\255\255\255\255\255\002\000\255\255\255\255\004\000\004\000\
    \001\000\004\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\002\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\003\000\255\255\255\255\255\255\006\000\006\000\006\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\001\000\
    \255\255\255\255\255\255\255\255\001\000\003\000\255\255\255\255\
    \255\255\255\255\255\255\003\000\002\000\005\000\001\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\003\000\255\255\
    \255\255\001\000\255\255\255\255\255\255\002\000\255\255\000\000\
    \255\255\255\255\255\255\004\000\001\000\004\000\255\255\002\000\
    \255\255\255\255\255\255\003\000\002\000\001\000\255\255\255\255\
    \255\255\255\255\004\000\004\000\000\000\255\255\255\255\255\255\
    ";
  Lexing.lex_default =
   "\001\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\092\000\000\000\098\000\000\000\255\255\
    \000\000\000\000\098\000\102\000\000\000\000\000\102\000\255\255\
    \255\255\000\000\255\255\112\000\000\000\255\255\255\255\000\000\
    \112\000\000\000\115\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\133\000\000\000\255\255\255\255\
    \255\255\255\255\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\163\000\000\000\000\000\171\000\255\255\255\255\
    \000\000\000\000\255\255\255\255\000\000\255\255\255\255\000\000\
    \255\255\255\255\000\000\180\000\000\000\000\000\000\000\255\255\
    \000\000\188\000\000\000\000\000\188\000\191\000\000\000\191\000\
    \195\000\000\000\000\000\195\000\255\255\255\255\255\255\000\000\
    \000\000\255\255\203\000\000\000\000\000\255\255\255\255\000\000\
    \000\000\255\255\211\000\000\000\000\000\255\255\000\000\255\255\
    \217\000\000\000\000\000\223\000\255\255\255\255\000\000\223\000\
    \227\000\000\000\000\000\227\000\255\255\255\255\000\000\232\000\
    \000\000\000\000\239\000\255\255\255\255\000\000\000\000\239\000\
    ";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\004\000\004\000\004\000\004\000\000\000\004\000\
    \018\000\018\000\018\000\018\000\018\000\000\000\018\000\024\000\
    \024\000\000\000\000\000\024\000\000\000\024\000\024\000\000\000\
    \004\000\024\000\004\000\005\000\000\000\000\000\000\000\018\000\
    \003\000\018\000\090\000\032\000\032\000\096\000\024\000\032\000\
    \105\000\035\000\035\000\097\000\024\000\035\000\032\000\032\000\
    \035\000\035\000\032\000\097\000\035\000\111\000\121\000\255\255\
    \138\000\169\000\032\000\006\000\009\000\168\000\007\000\172\000\
    \035\000\113\000\175\000\178\000\010\000\032\000\034\000\035\000\
    \053\000\184\000\011\000\199\000\008\000\207\000\222\000\230\000\
    \025\000\237\000\000\000\089\000\190\000\000\000\190\000\000\000\
    \000\000\020\000\022\000\021\000\043\000\045\000\012\000\017\000\
    \026\000\062\000\015\000\027\000\023\000\028\000\029\000\076\000\
    \019\000\013\000\072\000\016\000\030\000\014\000\031\000\037\000\
    \038\000\039\000\033\000\040\000\036\000\041\000\042\000\042\000\
    \042\000\042\000\042\000\046\000\042\000\044\000\044\000\044\000\
    \044\000\044\000\047\000\044\000\048\000\049\000\050\000\051\000\
    \051\000\056\000\057\000\051\000\058\000\042\000\059\000\042\000\
    \060\000\051\000\051\000\063\000\044\000\051\000\044\000\054\000\
    \054\000\054\000\054\000\054\000\064\000\054\000\051\000\061\000\
    \061\000\061\000\061\000\061\000\067\000\061\000\066\000\066\000\
    \051\000\068\000\066\000\066\000\066\000\073\000\054\000\066\000\
    \054\000\069\000\069\000\071\000\071\000\069\000\061\000\071\000\
    \061\000\074\000\069\000\069\000\077\000\066\000\069\000\075\000\
    \075\000\078\000\066\000\075\000\079\000\071\000\071\000\080\000\
    \069\000\071\000\071\000\081\000\082\000\085\000\086\000\087\000\
    \127\000\069\000\122\000\093\000\123\000\052\000\075\000\124\000\
    \125\000\095\000\126\000\128\000\071\000\055\000\129\000\130\000\
    \131\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\146\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\075\000\075\000\
    \002\000\139\000\075\000\083\000\083\000\083\000\083\000\083\000\
    \140\000\083\000\088\000\088\000\088\000\088\000\088\000\141\000\
    \088\000\255\255\142\000\143\000\065\000\075\000\094\000\103\000\
    \103\000\255\255\083\000\103\000\083\000\255\255\109\000\109\000\
    \144\000\088\000\109\000\088\000\109\000\109\000\147\000\255\255\
    \109\000\117\000\117\000\148\000\149\000\117\000\103\000\152\000\
    \153\000\154\000\155\000\156\000\157\000\109\000\158\000\107\000\
    \159\000\160\000\255\255\109\000\255\255\110\000\165\000\167\000\
    \117\000\166\000\084\000\100\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\100\000\103\000\103\000\100\000\100\000\
    \103\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\103\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\104\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\100\000\100\000\100\000\100\000\100\000\
    \100\000\100\000\100\000\100\000\126\000\126\000\131\000\131\000\
    \126\000\000\000\131\000\136\000\136\000\145\000\145\000\136\000\
    \213\000\145\000\145\000\145\000\150\000\150\000\145\000\238\000\
    \150\000\183\000\182\000\126\000\000\000\131\000\100\000\100\000\
    \100\000\100\000\136\000\100\000\145\000\238\000\161\000\161\000\
    \206\000\145\000\161\000\150\000\000\000\000\000\205\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\000\000\000\000\
    \000\000\255\255\000\000\000\000\000\000\161\000\100\000\100\000\
    \100\000\100\000\100\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\170\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\117\000\117\000\000\000\000\000\117\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\161\000\161\000\000\000\000\000\
    \161\000\000\000\117\000\136\000\136\000\150\000\150\000\136\000\
    \000\000\150\000\120\000\000\000\000\000\108\000\000\000\164\000\
    \000\000\196\000\196\000\161\000\000\000\196\000\255\255\255\255\
    \255\255\255\255\136\000\255\255\150\000\000\000\000\000\000\000\
    \000\000\000\000\137\000\174\000\000\000\209\000\209\000\118\000\
    \196\000\209\000\000\000\119\000\173\000\173\000\173\000\173\000\
    \173\000\173\000\173\000\173\000\173\000\173\000\255\255\255\255\
    \255\255\255\255\255\255\101\000\209\000\000\000\000\000\134\000\
    \151\000\176\000\176\000\176\000\176\000\176\000\176\000\176\000\
    \176\000\176\000\176\000\000\000\135\000\177\000\177\000\177\000\
    \177\000\177\000\177\000\177\000\177\000\177\000\177\000\000\000\
    \174\000\000\000\212\000\201\000\201\000\000\000\174\000\201\000\
    \201\000\201\000\000\000\000\000\201\000\000\000\000\000\209\000\
    \209\000\181\000\174\000\209\000\000\000\255\255\174\000\000\000\
    \174\000\000\000\201\000\000\000\000\000\215\000\215\000\201\000\
    \204\000\215\000\200\000\255\255\215\000\215\000\209\000\200\000\
    \215\000\220\000\220\000\228\000\228\000\220\000\255\255\228\000\
    \000\000\236\000\236\000\000\000\215\000\236\000\000\000\000\000\
    \000\000\000\000\000\000\215\000\000\000\000\000\000\000\000\000\
    \220\000\000\000\228\000\000\000\000\000\000\000\000\000\000\000\
    \236\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\220\000\220\000\000\000\000\000\220\000\
    \000\000\000\000\000\000\000\000\236\000\236\000\000\000\000\000\
    \236\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\220\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\221\000\236\000\000\000\234\000\000\000\000\000\
    \219\000\000\000\000\000\235\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\116\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\189\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\186\000\186\000\186\000\186\000\
    \186\000\186\000\186\000\186\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\186\000\186\000\
    \186\000\186\000\000\000\186\000\000\000\000\000\208\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\214\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\186\000\186\000\
    \186\000\186\000\186\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\218\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\233\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\255\255\
    \255\255\255\255\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\255\255\255\255\
    \255\255\255\255\255\255\187\000\000\000\000\000\000\000\000\000\
    \000\000\193\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\193\000\196\000\196\000\193\000\193\000\196\000\193\000\
    \193\000\193\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\193\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\196\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\198\000\193\000\193\000\193\000\193\000\197\000\193\000\
    \193\000\193\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\193\000\193\000\193\000\193\000\193\000\193\000\193\000\
    \193\000\193\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\193\000\193\000\193\000\193\000\
    \000\000\193\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\193\000\193\000\193\000\193\000\
    \193\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\255\255\255\255\255\255\
    \000\000\255\255\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\255\255\255\255\255\255\255\255\
    \255\255\194\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\255\255\255\255\255\255\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\255\255\255\255\255\255\000\000\255\255\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\000\000\000\000\000\000\000\000\225\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\225\000\228\000\228\000\
    \225\000\225\000\228\000\225\000\225\000\225\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\225\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\228\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\229\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\225\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\225\000\225\000\225\000\
    \225\000\225\000\225\000\225\000\225\000\225\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \225\000\225\000\225\000\225\000\000\000\225\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \225\000\225\000\225\000\225\000\225\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\000\000\255\255\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \255\255\255\255\255\255\255\255\255\255\226\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\000\000\004\000\004\000\000\000\255\255\004\000\
    \017\000\017\000\018\000\018\000\017\000\255\255\018\000\023\000\
    \023\000\255\255\255\255\023\000\255\255\024\000\024\000\255\255\
    \000\000\024\000\004\000\000\000\255\255\255\255\255\255\017\000\
    \000\000\018\000\003\000\031\000\031\000\095\000\023\000\031\000\
    \104\000\034\000\034\000\093\000\024\000\034\000\032\000\032\000\
    \035\000\035\000\032\000\098\000\035\000\110\000\120\000\107\000\
    \137\000\166\000\031\000\000\000\000\000\167\000\000\000\171\000\
    \034\000\112\000\174\000\177\000\000\000\032\000\033\000\035\000\
    \052\000\183\000\000\000\198\000\000\000\206\000\221\000\229\000\
    \024\000\235\000\255\255\005\000\189\000\255\255\191\000\255\255\
    \255\255\019\000\021\000\019\000\020\000\009\000\011\000\016\000\
    \025\000\008\000\014\000\026\000\022\000\027\000\028\000\006\000\
    \010\000\012\000\007\000\015\000\029\000\013\000\030\000\036\000\
    \037\000\038\000\032\000\039\000\035\000\040\000\041\000\041\000\
    \042\000\042\000\041\000\045\000\042\000\043\000\043\000\044\000\
    \044\000\043\000\046\000\044\000\047\000\048\000\049\000\050\000\
    \050\000\055\000\056\000\050\000\057\000\041\000\058\000\042\000\
    \059\000\051\000\051\000\062\000\043\000\051\000\044\000\053\000\
    \053\000\054\000\054\000\053\000\063\000\054\000\050\000\060\000\
    \060\000\061\000\061\000\060\000\065\000\061\000\064\000\064\000\
    \051\000\067\000\064\000\066\000\066\000\072\000\053\000\066\000\
    \054\000\068\000\068\000\071\000\071\000\068\000\060\000\071\000\
    \061\000\073\000\069\000\069\000\076\000\064\000\069\000\074\000\
    \074\000\077\000\066\000\074\000\078\000\070\000\070\000\079\000\
    \068\000\070\000\071\000\080\000\081\000\084\000\085\000\086\000\
    \118\000\069\000\119\000\091\000\122\000\051\000\074\000\123\000\
    \124\000\091\000\125\000\127\000\070\000\054\000\128\000\129\000\
    \130\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\134\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\075\000\075\000\
    \000\000\135\000\075\000\082\000\082\000\083\000\083\000\082\000\
    \139\000\083\000\087\000\087\000\088\000\088\000\087\000\140\000\
    \088\000\093\000\141\000\142\000\064\000\075\000\091\000\103\000\
    \103\000\098\000\082\000\103\000\083\000\107\000\106\000\106\000\
    \143\000\087\000\106\000\088\000\109\000\109\000\146\000\112\000\
    \109\000\117\000\117\000\147\000\148\000\117\000\103\000\151\000\
    \152\000\153\000\154\000\155\000\156\000\106\000\157\000\106\000\
    \158\000\159\000\189\000\109\000\191\000\106\000\162\000\162\000\
    \117\000\162\000\083\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\099\000\099\000\099\000\099\000\
    \099\000\099\000\099\000\099\000\126\000\126\000\131\000\131\000\
    \126\000\255\255\131\000\136\000\136\000\144\000\144\000\136\000\
    \210\000\144\000\145\000\145\000\149\000\149\000\145\000\234\000\
    \149\000\179\000\179\000\126\000\255\255\131\000\099\000\099\000\
    \099\000\099\000\136\000\099\000\144\000\239\000\160\000\160\000\
    \202\000\145\000\160\000\149\000\255\255\255\255\202\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\165\000\255\255\255\255\
    \255\255\091\000\255\255\255\255\255\255\160\000\099\000\099\000\
    \099\000\099\000\099\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\102\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\102\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\102\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\102\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\165\000\102\000\102\000\102\000\102\000\102\000\
    \102\000\102\000\102\000\114\000\114\000\255\255\255\255\114\000\
    \255\255\255\255\255\255\255\255\255\255\102\000\102\000\102\000\
    \102\000\102\000\102\000\102\000\161\000\161\000\255\255\255\255\
    \161\000\255\255\114\000\132\000\132\000\150\000\150\000\132\000\
    \255\255\150\000\114\000\255\255\255\255\106\000\255\255\162\000\
    \255\255\196\000\196\000\161\000\255\255\196\000\102\000\102\000\
    \102\000\102\000\132\000\102\000\150\000\255\255\255\255\255\255\
    \255\255\255\255\132\000\170\000\255\255\209\000\209\000\114\000\
    \196\000\209\000\255\255\114\000\170\000\170\000\170\000\170\000\
    \170\000\170\000\170\000\170\000\170\000\170\000\102\000\102\000\
    \102\000\102\000\102\000\099\000\209\000\255\255\255\255\132\000\
    \150\000\173\000\173\000\173\000\173\000\173\000\173\000\173\000\
    \173\000\173\000\173\000\255\255\132\000\176\000\176\000\176\000\
    \176\000\176\000\176\000\176\000\176\000\176\000\176\000\255\255\
    \170\000\255\255\210\000\197\000\197\000\255\255\170\000\197\000\
    \201\000\201\000\255\255\255\255\201\000\255\255\255\255\205\000\
    \205\000\179\000\170\000\205\000\255\255\234\000\170\000\255\255\
    \170\000\255\255\197\000\255\255\255\255\213\000\213\000\201\000\
    \202\000\213\000\197\000\239\000\215\000\215\000\205\000\201\000\
    \215\000\220\000\220\000\228\000\228\000\220\000\165\000\228\000\
    \255\255\236\000\236\000\255\255\213\000\236\000\255\255\255\255\
    \255\255\255\255\255\255\215\000\255\255\255\255\255\255\255\255\
    \220\000\255\255\228\000\255\255\255\255\255\255\255\255\255\255\
    \236\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\216\000\216\000\255\255\255\255\216\000\
    \255\255\255\255\255\255\255\255\231\000\231\000\255\255\255\255\
    \231\000\255\255\255\255\102\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\216\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\216\000\231\000\255\255\231\000\255\255\255\255\
    \216\000\255\255\255\255\231\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\114\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\132\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\185\000\185\000\185\000\185\000\
    \185\000\185\000\185\000\185\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\185\000\185\000\
    \185\000\185\000\255\255\185\000\255\255\255\255\205\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\213\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\185\000\185\000\
    \185\000\185\000\185\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\188\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\188\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\188\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\188\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\216\000\188\000\188\000\188\000\188\000\188\000\
    \188\000\188\000\188\000\231\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\188\000\188\000\188\000\
    \188\000\188\000\188\000\188\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\188\000\188\000\
    \188\000\188\000\255\255\188\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\188\000\188\000\
    \188\000\188\000\188\000\185\000\255\255\255\255\255\255\255\255\
    \255\255\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\192\000\192\000\192\000\192\000\192\000\192\000\
    \192\000\192\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\192\000\192\000\192\000\192\000\
    \255\255\192\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\188\000\192\000\192\000\192\000\192\000\
    \192\000\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \195\000\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \195\000\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \195\000\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \195\000\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \255\255\195\000\195\000\195\000\195\000\195\000\195\000\195\000\
    \195\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\195\000\195\000\195\000\195\000\195\000\
    \195\000\195\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\195\000\195\000\195\000\195\000\
    \255\255\195\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\195\000\195\000\195\000\195\000\
    \195\000\192\000\255\255\255\255\255\255\255\255\255\255\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \219\000\219\000\219\000\219\000\219\000\219\000\219\000\219\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\219\000\219\000\219\000\219\000\255\255\219\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\195\000\219\000\219\000\219\000\219\000\219\000\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\223\000\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\223\000\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\223\000\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\223\000\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\255\255\223\000\
    \223\000\223\000\223\000\223\000\223\000\223\000\223\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\223\000\223\000\223\000\223\000\223\000\223\000\223\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\223\000\223\000\223\000\223\000\255\255\223\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\223\000\223\000\223\000\223\000\223\000\219\000\
    \255\255\255\255\255\255\255\255\255\255\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\224\000\224\000\
    \224\000\224\000\224\000\224\000\224\000\224\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \224\000\224\000\224\000\224\000\255\255\224\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\000\
    \224\000\224\000\224\000\224\000\224\000\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\227\000\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\227\000\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\227\000\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\227\000\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\255\255\227\000\227\000\227\000\
    \227\000\227\000\227\000\227\000\227\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\227\000\
    \227\000\227\000\227\000\227\000\227\000\227\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \227\000\227\000\227\000\227\000\255\255\227\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \227\000\227\000\227\000\227\000\227\000\224\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\227\000";
  Lexing.lex_base_code =
   "";
  Lexing.lex_backtrk_code =
   "";
  Lexing.lex_default_code =
   "";
  Lexing.lex_trans_code =
   "";
  Lexing.lex_check_code =
   "";
  Lexing.lex_code =
   "";
}

let rec coq_action lexbuf =
   __ocaml_lex_coq_action_rec lexbuf 0
and __ocaml_lex_coq_action_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 72 "tools/coqdep/lib/lexer.mll"
      ( require_modifiers None lexbuf )
# 654 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 74 "tools/coqdep/lib/lexer.mll"
      ( modules [] lexbuf )
# 659 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 76 "tools/coqdep/lib/lexer.mll"
      ( modules [] lexbuf )
# 664 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 78 "tools/coqdep/lib/lexer.mll"
      ( load_file lexbuf )
# 669 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 80 "tools/coqdep/lib/lexer.mll"
      ( coq_action lexbuf )
# 674 "tools/coqdep/lib/lexer.ml"

  | 5 ->
# 82 "tools/coqdep/lib/lexer.mll"
      ( coq_action lexbuf )
# 679 "tools/coqdep/lib/lexer.ml"

  | 6 ->
# 84 "tools/coqdep/lib/lexer.mll"
      ( from_rule false lexbuf )
# 684 "tools/coqdep/lib/lexer.ml"

  | 7 ->
# 86 "tools/coqdep/lib/lexer.mll"
      ( from_rule true lexbuf )
# 689 "tools/coqdep/lib/lexer.ml"

  | 8 ->
# 88 "tools/coqdep/lib/lexer.mll"
      ( skip_attribute lexbuf; coq_action lexbuf )
# 694 "tools/coqdep/lib/lexer.ml"

  | 9 ->
# 90 "tools/coqdep/lib/lexer.mll"
      ( coq_action lexbuf )
# 699 "tools/coqdep/lib/lexer.ml"

  | 10 ->
# 92 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; coq_action lexbuf )
# 704 "tools/coqdep/lib/lexer.ml"

  | 11 ->
# 94 "tools/coqdep/lib/lexer.mll"
      ( raise Fin_fichier)
# 709 "tools/coqdep/lib/lexer.ml"

  | 12 ->
# 96 "tools/coqdep/lib/lexer.mll"
      ( skip_to_dot lexbuf; coq_action lexbuf )
# 714 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_coq_action_rec lexbuf __ocaml_lex_state

and skip_attribute lexbuf =
   __ocaml_lex_skip_attribute_rec lexbuf 91
and __ocaml_lex_skip_attribute_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 100 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; skip_attribute lexbuf )
# 726 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 102 "tools/coqdep/lib/lexer.mll"
      ( () )
# 731 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 104 "tools/coqdep/lib/lexer.mll"
      ( skip_attribute lexbuf )
# 736 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 106 "tools/coqdep/lib/lexer.mll"
      ( skip_attribute lexbuf )
# 741 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_attribute_rec lexbuf __ocaml_lex_state

and from_rule only_extra_dep lexbuf =
   __ocaml_lex_from_rule_rec only_extra_dep lexbuf 99
and __ocaml_lex_from_rule_rec only_extra_dep lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 110 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; from_rule only_extra_dep lexbuf )
# 753 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 112 "tools/coqdep/lib/lexer.mll"
      ( from_rule only_extra_dep lexbuf )
# 758 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 114 "tools/coqdep/lib/lexer.mll"
      ( let from = coq_qual_id_tail [get_ident lexbuf] lexbuf in
        consume_require_or_extradeps only_extra_dep (Some from) lexbuf )
# 764 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 117 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 769 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 119 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 774 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_from_rule_rec only_extra_dep lexbuf __ocaml_lex_state

and extra_dep_rule from lexbuf =
   __ocaml_lex_extra_dep_rule_rec from lexbuf 106
and __ocaml_lex_extra_dep_rule_rec from lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 123 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; extra_dep_rule from lexbuf )
# 786 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 125 "tools/coqdep/lib/lexer.mll"
      ( extra_dep_rule from lexbuf )
# 791 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 127 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 796 "tools/coqdep/lib/lexer.ml"

  | 3 ->
let
# 128 "tools/coqdep/lib/lexer.mll"
                     f
# 802 "tools/coqdep/lib/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 1) (lexbuf.Lexing.lex_curr_pos + -1) in
# 129 "tools/coqdep/lib/lexer.mll"
      ( skip_to_dot lexbuf;
        External (from,f) )
# 807 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_extra_dep_rule_rec from lexbuf __ocaml_lex_state

and require_modifiers from lexbuf =
   __ocaml_lex_require_modifiers_rec from lexbuf 114
and __ocaml_lex_require_modifiers_rec from lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 134 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; require_modifiers from lexbuf )
# 819 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 136 "tools/coqdep/lib/lexer.mll"
      ( require_file from lexbuf )
# 824 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 138 "tools/coqdep/lib/lexer.mll"
      ( require_file from lexbuf )
# 829 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 140 "tools/coqdep/lib/lexer.mll"
      ( require_modifiers from lexbuf )
# 834 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 142 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 839 "tools/coqdep/lib/lexer.ml"

  | 5 ->
# 144 "tools/coqdep/lib/lexer.mll"
      ( backtrack lexbuf ; require_file from lexbuf )
# 844 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_require_modifiers_rec from lexbuf __ocaml_lex_state

and consume_require_or_extradeps only_extra_dep from lexbuf =
   __ocaml_lex_consume_require_or_extradeps_rec only_extra_dep from lexbuf 132
and __ocaml_lex_consume_require_or_extradeps_rec only_extra_dep from lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 148 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; consume_require_or_extradeps only_extra_dep from lexbuf )
# 856 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 150 "tools/coqdep/lib/lexer.mll"
      ( consume_require_or_extradeps only_extra_dep from lexbuf )
# 861 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 152 "tools/coqdep/lib/lexer.mll"
      ( if only_extra_dep then syntax_error lexbuf; require_modifiers from lexbuf )
# 866 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 154 "tools/coqdep/lib/lexer.mll"
      ( match from with
        | None -> syntax_error lexbuf (* Extra Dependency requires From *)
        | Some from -> extra_dep_rule from lexbuf )
# 873 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 158 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 878 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_consume_require_or_extradeps_rec only_extra_dep from lexbuf __ocaml_lex_state

and comment lexbuf =
   __ocaml_lex_comment_rec lexbuf 162
and __ocaml_lex_comment_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 162 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; comment lexbuf )
# 890 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 164 "tools/coqdep/lib/lexer.mll"
      ( () )
# 895 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 166 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf )
# 900 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 168 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf )
# 905 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 170 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf )
# 910 "tools/coqdep/lib/lexer.ml"

  | 5 ->
# 172 "tools/coqdep/lib/lexer.mll"
      ( raise Fin_fichier )
# 915 "tools/coqdep/lib/lexer.ml"

  | 6 ->
# 174 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf )
# 920 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_comment_rec lexbuf __ocaml_lex_state

and skip_parenthesized lexbuf =
   __ocaml_lex_skip_parenthesized_rec lexbuf 179
and __ocaml_lex_skip_parenthesized_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 178 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; skip_parenthesized lexbuf )
# 932 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 180 "tools/coqdep/lib/lexer.mll"
      ( skip_parenthesized lexbuf; skip_parenthesized lexbuf )
# 937 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 182 "tools/coqdep/lib/lexer.mll"
      ( () )
# 942 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 184 "tools/coqdep/lib/lexer.mll"
      ( raise Fin_fichier )
# 947 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 186 "tools/coqdep/lib/lexer.mll"
    ( skip_parenthesized lexbuf )
# 952 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_parenthesized_rec lexbuf __ocaml_lex_state

and load_file lexbuf =
   __ocaml_lex_load_file_rec lexbuf 185
and __ocaml_lex_load_file_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 190 "tools/coqdep/lib/lexer.mll"
      ( let s = lexeme lexbuf in
        parse_dot lexbuf;
        Load (Physical (unquote_vfile_string s)) )
# 966 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 194 "tools/coqdep/lib/lexer.mll"
      ( let s = get_ident lexbuf in skip_to_dot lexbuf; Load (Logical s) )
# 971 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 196 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 976 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 198 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 981 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_load_file_rec lexbuf __ocaml_lex_state

and require_file from lexbuf =
   __ocaml_lex_require_file_rec from lexbuf 192
and __ocaml_lex_require_file_rec from lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 202 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; require_file from lexbuf )
# 993 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 204 "tools/coqdep/lib/lexer.mll"
    ( skip_parenthesized lexbuf; require_file from lexbuf )
# 998 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 206 "tools/coqdep/lib/lexer.mll"
      ( require_file from lexbuf )
# 1003 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 208 "tools/coqdep/lib/lexer.mll"
      ( let name = coq_qual_id_tail [get_ident lexbuf] lexbuf in
        let qid = coq_qual_id_list [name] lexbuf in
        parse_dot lexbuf;
        Require (from, qid) )
# 1011 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 213 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1016 "tools/coqdep/lib/lexer.ml"

  | 5 ->
# 215 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1021 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_require_file_rec from lexbuf __ocaml_lex_state

and skip_to_dot lexbuf =
   __ocaml_lex_skip_to_dot_rec lexbuf 202
and __ocaml_lex_skip_to_dot_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 219 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; skip_to_dot lexbuf )
# 1033 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 220 "tools/coqdep/lib/lexer.mll"
        ( () )
# 1038 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 221 "tools/coqdep/lib/lexer.mll"
        ( syntax_error lexbuf )
# 1043 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 222 "tools/coqdep/lib/lexer.mll"
        ( skip_to_dot lexbuf )
# 1048 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_to_dot_rec lexbuf __ocaml_lex_state

and parse_dot lexbuf =
   __ocaml_lex_parse_dot_rec lexbuf 210
and __ocaml_lex_parse_dot_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 225 "tools/coqdep/lib/lexer.mll"
        ( () )
# 1060 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 226 "tools/coqdep/lib/lexer.mll"
        ( syntax_error lexbuf )
# 1065 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 227 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1070 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_parse_dot_rec lexbuf __ocaml_lex_state

and coq_qual_id_tail module_name lexbuf =
   __ocaml_lex_coq_qual_id_tail_rec module_name lexbuf 216
and __ocaml_lex_coq_qual_id_tail_rec module_name lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 231 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; coq_qual_id_tail module_name lexbuf )
# 1082 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 233 "tools/coqdep/lib/lexer.mll"
      ( coq_qual_id_tail module_name lexbuf )
# 1087 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 235 "tools/coqdep/lib/lexer.mll"
      ( coq_qual_id_tail (get_field_name lexbuf :: module_name) lexbuf )
# 1092 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 237 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1097 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 239 "tools/coqdep/lib/lexer.mll"
      ( backtrack lexbuf;
        List.rev module_name )
# 1103 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_coq_qual_id_tail_rec module_name lexbuf __ocaml_lex_state

and coq_qual_id_list module_names lexbuf =
   __ocaml_lex_coq_qual_id_list_rec module_names lexbuf 224
and __ocaml_lex_coq_qual_id_list_rec module_names lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 244 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; coq_qual_id_list module_names lexbuf )
# 1115 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 246 "tools/coqdep/lib/lexer.mll"
    ( skip_parenthesized lexbuf; coq_qual_id_list module_names lexbuf )
# 1120 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 248 "tools/coqdep/lib/lexer.mll"
      ( coq_qual_id_list module_names lexbuf )
# 1125 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 250 "tools/coqdep/lib/lexer.mll"
      ( let name = coq_qual_id_tail [get_ident lexbuf] lexbuf in
        coq_qual_id_list (name :: module_names) lexbuf
      )
# 1132 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 254 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1137 "tools/coqdep/lib/lexer.ml"

  | 5 ->
# 256 "tools/coqdep/lib/lexer.mll"
      ( backtrack lexbuf;
        List.rev module_names )
# 1143 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_coq_qual_id_list_rec module_names lexbuf __ocaml_lex_state

and modules mllist lexbuf =
   __ocaml_lex_modules_rec mllist lexbuf 231
and __ocaml_lex_modules_rec mllist lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 261 "tools/coqdep/lib/lexer.mll"
      ( modules mllist lexbuf )
# 1155 "tools/coqdep/lib/lexer.ml"

  | 1 ->
# 263 "tools/coqdep/lib/lexer.mll"
      ( comment lexbuf; modules mllist lexbuf )
# 1160 "tools/coqdep/lib/lexer.ml"

  | 2 ->
# 265 "tools/coqdep/lib/lexer.mll"
      ( let lex = (Lexing.lexeme lexbuf) in
        let str = String.sub lex 1 (String.length lex - 2) in
        modules (str :: mllist) lexbuf)
# 1167 "tools/coqdep/lib/lexer.ml"

  | 3 ->
# 269 "tools/coqdep/lib/lexer.mll"
      ( syntax_error lexbuf )
# 1172 "tools/coqdep/lib/lexer.ml"

  | 4 ->
# 271 "tools/coqdep/lib/lexer.mll"
      ( Declare (List.rev mllist) )
# 1177 "tools/coqdep/lib/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_modules_rec mllist lexbuf __ocaml_lex_state

;;

