
# 13 "vernac/g_vernac.mlg"
 

open Pp
open Util
open Names
open Glob_term
open Vernacexpr
open Constrexpr
open Constrexpr_ops
open Extend
open Decls
open Declaremods

module C = Constr

open Procq
open Procq.Prim
open Procq.Constr
open Procq.Module
open Pvernac.Vernac_
open Attributes

(* Rem: do not join the different GEXTEND into one, it breaks native *)
(* compilation on PowerPC and Sun architectures *)

let query_command = Entry.make "query_command"

let search_query = Entry.make "search_query"
let search_queries = Entry.make "search_queries"

let subprf = Entry.make "subprf"
let subprf_with_selector = Entry.make "subprf_with_selector"

let quoted_attributes = Entry.make "quoted_attributes"
let attribute_list = Entry.make "attribute_list"
let coercion_class = Entry.make "coercion_class"
let thm_token = Entry.make "thm_token"
let def_token = Entry.make "def_token"
let assumption_token = Entry.make "assumption_token"
let def_body = Entry.make "def_body"
let notation_declaration = Entry.make "notation_declaration"
let decl_notations = Entry.make "decl_notations"
let record_field = Entry.make "record_field"
let of_type = Entry.make "of_type"
let of_type_inst = Entry.make "of_type_inst"
let section_subset_expr = Entry.make "section_subset_expr"
let scope_delimiter = Entry.make "scope_delimiter"
let syntax_modifiers = Entry.make "syntax_modifiers"
let goal_selector = Entry.make "goal_selector"
let toplevel_selector = Entry.make "toplevel_selector"

let make_bullet s =
  let open Proof_bullet in
  let n = String.length s in
  match s.[0] with
  | '-' -> Dash n
  | '+' -> Plus n
  | '*' -> Star n
  | _ -> assert false

(* For now we just keep the top-level location of the whole
   vernacular, that is to say, including attributes and control flags;
   this is not very convenient for advanced clients tho, so in the
   future it'd be cool to actually locate the attributes and control
   flags individually too. *)
let add_control_flag ~loc ~flag { CAst.v = cmd } =
  CAst.make ~loc { cmd with control = flag :: cmd.control }

let test_hash_ident =
  let open Procq.Lookahead in
  to_entry "test_hash_ident" begin
    lk_kw "#" >> lk_ident >> check_no_space
  end

let test_id_colon =
  let open Procq.Lookahead in
  to_entry "test_id_colon" begin
    lk_ident >> lk_kw ":"
  end

let warn_chdir_pwd = CWarnings.create ~name:"change-dir-pwd-deprecated" ~category:Deprecation.Version.v8_20
    (fun () -> strbrk "Command \"Cd\" as a synonym of \"Pwd\" is deprecated." ++ spc () ++
               strbrk "Use \"Pwd\" instead.")


# 89 "vernac/g_vernac.ml"

let _ =
  let decorated_vernac = Procq.Entry.make "decorated_vernac"
  and attribute = Procq.Entry.make "attribute"
  and attr_value = Procq.Entry.make "attr_value"
  and legacy_attr = Procq.Entry.make "legacy_attr"
  and vernac_aux = Procq.Entry.make "vernac_aux"
  in
  let () =
  Procq.grammar_extend vernac_control
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm decorated_vernac)))
                            (fun v loc -> 
# 117 "vernac/g_vernac.mlg"
          let (attrs, expr) = v in CAst.make ~loc { control = []; attrs; expr = expr } 
# 108 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Succeed"))))))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c _ loc -> 
# 115 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:ControlSucceed c 
# 119 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Fail"))))))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c _ loc -> 
# 113 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:ControlFail c 
# 130 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Timeout"))))))
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c n _ loc -> 
# 111 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:(ControlTimeout n) c 
# 143 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Redirect"))))))
                             ((Procq.Symbol.nterm ne_string)))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c s _ loc -> 
# 109 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:(ControlRedirect s) c 
# 156 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Profile"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PSTRING (None))))))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c f _ loc -> 
# 107 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:(ControlProfile f) c 
# 169 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Instructions"))))))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c _ loc -> 
# 105 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:ControlInstructions c 
# 180 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Time"))))))
                            ((Procq.Symbol.nterm vernac_control)))
                           (fun c _ loc -> 
# 103 "vernac/g_vernac.mlg"
          add_control_flag ~loc ~flag:ControlTime c 
# 191 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty decorated_vernac) in
  let () =
  Procq.grammar_extend decorated_vernac
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm quoted_attributes)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm legacy_attr))))
                             ((Procq.Symbol.nterm vernac_aux)))
                            (fun v a' a loc -> 
# 122 "vernac/g_vernac.mlg"
          (List.append a a', v) 
# 208 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty quoted_attributes) in
  let () =
  Procq.grammar_extend quoted_attributes
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0 (Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD ("#[")))))
                                                 ((Procq.Symbol.nterm attribute_list)))
                                                ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                                               (fun _ a _ loc -> 
# 125 "vernac/g_vernac.mlg"
                                                         a 
# 228 "vernac/g_vernac.ml"
)]))))
                            (fun l loc -> 
# 125 "vernac/g_vernac.mlg"
                                                                    List.flatten l 
# 233 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty attribute_list) in
  let () =
  Procq.grammar_extend attribute_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm attribute)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            (fun a loc -> 
# 129 "vernac/g_vernac.mlg"
                                         a 
# 246 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty attribute) in
  let () =
  Procq.grammar_extend attribute
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("using"))))))
                             ((Procq.Symbol.nterm attr_value)))
                            (fun v _ loc -> 
# 135 "vernac/g_vernac.mlg"
                                            CAst.make ~loc ("using", v) 
# 262 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            ((Procq.Symbol.nterm attr_value)))
                           (fun v k loc -> 
# 133 "vernac/g_vernac.mlg"
                                        CAst.make ~loc (Names.Id.to_string k, v) 
# 272 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty attr_value) in
  let () =
  Procq.grammar_extend attr_value
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 142 "vernac/g_vernac.mlg"
             VernacFlagEmpty 
# 283 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm attribute_list)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ a _ loc -> 
# 141 "vernac/g_vernac.mlg"
                                            VernacFlagList a 
# 295 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                            ((Procq.Symbol.nterm qualid)))
                           (fun v _ loc -> 
# 140 "vernac/g_vernac.mlg"
                              VernacFlagLeaf (FlagQualid v) 
# 305 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                            ((Procq.Symbol.nterm string)))
                           (fun v _ loc -> 
# 139 "vernac/g_vernac.mlg"
                              VernacFlagLeaf (FlagString v) 
# 315 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty legacy_attr) in
  let () =
  Procq.grammar_extend legacy_attr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Program"))))))
                            (fun _ loc -> 
# 161 "vernac/g_vernac.mlg"
          CAst.make ~loc ("program", VernacFlagEmpty) 
# 329 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Private"))))))
                           (fun _ loc -> 
# 159 "vernac/g_vernac.mlg"
          CAst.make ~loc ("private", VernacFlagList [CAst.make ~loc ("matching", VernacFlagEmpty)]) 
# 338 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("NonCumulative"))))))
                           (fun _ loc -> 
# 157 "vernac/g_vernac.mlg"
          CAst.make ~loc ("universes", VernacFlagList [CAst.make ~loc ("cumulative", VernacFlagLeaf (FlagQualid (Libnames.qualid_of_string "no")))]) 
# 347 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Cumulative"))))))
                           (fun _ loc -> 
# 155 "vernac/g_vernac.mlg"
          CAst.make ~loc ("universes", VernacFlagList [CAst.make ~loc ("cumulative", VernacFlagEmpty)]) 
# 356 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Monomorphic"))))))
                           (fun _ loc -> 
# 153 "vernac/g_vernac.mlg"
          Attributes.vernac_monomorphic_flag (Some loc) 
# 365 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Polymorphic"))))))
                           (fun _ loc -> 
# 151 "vernac/g_vernac.mlg"
          Attributes.vernac_polymorphic_flag (Some loc) 
# 374 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Global"))))))
                           (fun _ loc -> 
# 149 "vernac/g_vernac.mlg"
          CAst.make ~loc ("global", VernacFlagEmpty) 
# 383 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Local"))))))
                           (fun _ loc -> 
# 147 "vernac/g_vernac.mlg"
          CAst.make ~loc ("local", VernacFlagEmpty) 
# 392 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty vernac_aux) in
  let () =
  Procq.grammar_extend vernac_aux
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm syntax)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                            (fun _ c loc -> 
# 170 "vernac/g_vernac.mlg"
                             c 
# 407 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm command)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ c loc -> 
# 169 "vernac/g_vernac.mlg"
                              c 
# 417 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm gallina_ext)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ g loc -> 
# 168 "vernac/g_vernac.mlg"
                                  g 
# 427 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm gallina)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ g loc -> 
# 167 "vernac/g_vernac.mlg"
                              VernacSynPure g 
# 437 "vernac/g_vernac.ml"
)])]))
  in let () =
  Procq.grammar_extend vernac_aux
  (Procq.Fresh
  (Gramlib.Gramext.Last, [(None, None,
                          [Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm command_entry)))
                           (fun prfcom loc -> 
# 174 "vernac/g_vernac.mlg"
                                    prfcom 
# 449 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty noedit_mode) in
  let () =
  Procq.grammar_extend noedit_mode
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm query_command)))
                            (fun c loc -> 
# 177 "vernac/g_vernac.mlg"
                                          VernacSynPure (c None) 
# 462 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty subprf) in
  let () =
  Procq.grammar_extend subprf
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ loc -> 
# 182 "vernac/g_vernac.mlg"
               VernacEndSubproof 
# 475 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PBULLET (None)))))
                           (fun s loc -> 
# 181 "vernac/g_vernac.mlg"
                      VernacBullet (make_bullet s) 
# 483 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty subprf_with_selector) in
  let () =
  Procq.grammar_extend subprf_with_selector
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm query_command)))
                            (fun c loc -> 
# 188 "vernac/g_vernac.mlg"
                             c 
# 496 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                           (fun _ loc -> 
# 186 "vernac/g_vernac.mlg"
               fun g -> VernacSubproof g 
# 504 "vernac/g_vernac.ml"
)])]))
  in ()


# 194 "vernac/g_vernac.mlg"
 

let warn_plural_command =
  CWarnings.create ~name:"plural-command" ~category:CWarnings.CoreCategories.pedantic ~default:CWarnings.Disabled
         (fun kwd -> strbrk (Printf.sprintf "Command \"%s\" expects more than one assumption." kwd))

let test_plural_form loc kwd = function
  | [(_,([_],_))] ->
     warn_plural_command ~loc kwd
  | _ -> ()

let test_plural_form_types loc kwd = function
  | [([_],_)] ->
     warn_plural_command ~loc kwd
  | _ -> ()

let test_plural_form_rules loc kwd = function
  | [_] ->
     warn_plural_command ~loc kwd
  | _ -> ()

let lname_of_lident : lident -> lname =
  CAst.map (fun s -> Name s)

let name_of_ident_decl : ident_decl -> name_decl =
  on_fst lname_of_lident

let test_variance_ident =
  let open Procq.Lookahead in
  to_entry "test_variance_ident" begin
    lk_kws ["=";"+";"*"] >> lk_ident
  end

let test_doublepipe_univ_decl =
  let open Procq.Lookahead in
  to_entry "test_doublepipe_univ_decl" (lk_ident_list >> lk_kw "|" >> lk_ident_list >> (lk_kw "+" <+> lk_empty) >> (lk_kw "|" <+> lk_kw "|}"))

let test_doublepipe_cumul_univ_decl =
  let open Procq.Lookahead in
  let lk_list_variance_ident = lk_list (lk_kw "+" <+> lk_kw "*" <+> lk_kw "=" <+> lk_ident) in
  to_entry "test_doublepipe_cumul_univ_decl" (lk_ident_list >> lk_kw "|" >> lk_list_variance_ident >> (lk_kw "+" <+> lk_empty) >> (lk_kw "|" <+> lk_kw "|}"))

let test_semicolon_cumul_univ_decl =
  let open Procq.Lookahead in
  to_entry "test_semicolon_cumul_univ_decl" (lk_ident_list >> lk_kw ";")


# 557 "vernac/g_vernac.ml"

let _ =
  let register_token = Procq.Entry.make "register_token"
  and assumptions_token = Procq.Entry.make "assumptions_token"
  and inline = Procq.Entry.make "inline"
  and univ_constraint = Procq.Entry.make "univ_constraint"
  and univ_decl_constraints = Procq.Entry.make "univ_decl_constraints"
  and variance = Procq.Entry.make "variance"
  and variance_identref = Procq.Entry.make "variance_identref"
  and cumul_univ_decl = Procq.Entry.make "cumul_univ_decl"
  and cumul_ident_decl = Procq.Entry.make "cumul_ident_decl"
  and inductive_token = Procq.Entry.make "inductive_token"
  and finite_token = Procq.Entry.make "finite_token"
  and reduce = Procq.Entry.make "reduce"
  and decl_sep = Procq.Entry.make "decl_sep"
  and opt_constructors_or_fields =
    Procq.Entry.make "opt_constructors_or_fields"
  and constructors_or_record = Procq.Entry.make "constructors_or_record"
  and default_inhabitant_ident = Procq.Entry.make "default_inhabitant_ident"
  and opt_coercion = Procq.Entry.make "opt_coercion"
  and cofix_definition = Procq.Entry.make "cofix_definition"
  and rw_pattern = Procq.Entry.make "rw_pattern"
  and rewrite_rule = Procq.Entry.make "rewrite_rule"
  and scheme = Procq.Entry.make "scheme"
  and scheme_kind = Procq.Entry.make "scheme_kind"
  and scheme_type = Procq.Entry.make "scheme_type"
  and record_fields = Procq.Entry.make "record_fields"
  and field_body = Procq.Entry.make "field_body"
  and record_binder = Procq.Entry.make "record_binder"
  and assum_list = Procq.Entry.make "assum_list"
  and assum_coe = Procq.Entry.make "assum_coe"
  and assumpt = Procq.Entry.make "assumpt"
  and constructor_type = Procq.Entry.make "constructor_type"
  and constructor = Procq.Entry.make "constructor"
  in
  let () = assert (Procq.Entry.is_empty gallina) in
  let () =
  Procq.grammar_extend gallina
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("Rewrite"))))))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Rules"))))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                              ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD ("|"))))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm rewrite_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                            (fun rules _ _ id _ _ loc -> 
# 305 "vernac/g_vernac.mlg"
            test_plural_form_rules loc "Rewrite Rules" rules;
            VernacAddRewRule (id, rules) 
# 617 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Rewrite"))))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Rule"))))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD ("|"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm rewrite_rule)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun rules _ _ id _ _ loc -> 
# 303 "vernac/g_vernac.mlg"
            VernacAddRewRule (id, rules) 
# 637 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Constraint"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm univ_constraint)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun l _ loc -> 
# 301 "vernac/g_vernac.mlg"
                                                                   VernacConstraint l 
# 648 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Sorts"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                           (fun l _ loc -> 
# 300 "vernac/g_vernac.mlg"
                                               VernacSort l 
# 659 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Sort"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                           (fun l _ loc -> 
# 299 "vernac/g_vernac.mlg"
                                              VernacSort l 
# 670 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Universes"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                           (fun l _ loc -> 
# 298 "vernac/g_vernac.mlg"
                                                   VernacUniverse l 
# 681 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Universe"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                           (fun l _ loc -> 
# 297 "vernac/g_vernac.mlg"
                                                  VernacUniverse l 
# 692 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Primitive"))))))
                               ((Procq.Symbol.nterm ident_decl)))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                                 ((Procq.Symbol.nterm lconstr)))
                                                (fun typ _ loc -> 
# 295 "vernac/g_vernac.mlg"
                                                                                   typ 
# 712 "vernac/g_vernac.ml"
)]))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm register_token)))
                           (fun r _ typopt id _ loc -> 
# 296 "vernac/g_vernac.mlg"
            VernacPrimitive(id, r, typopt) 
# 719 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Register"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Inline"))))))
                            ((Procq.Symbol.nterm global)))
                           (fun g _ _ loc -> 
# 294 "vernac/g_vernac.mlg"
            VernacRegister(g, RegisterInline) 
# 733 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("Register"))))))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Scheme"))))))
                                ((Procq.Symbol.nterm global)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                              ((Procq.Symbol.nterm qualid)))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("for"))))))
                            ((Procq.Symbol.nterm global)))
                           (fun g' _ qid _ g _ _ loc -> 
# 292 "vernac/g_vernac.mlg"
          VernacRegister(g, RegisterScheme {inductive = g'; scheme_kind = qid}) 
# 756 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Register"))))))
                              ((Procq.Symbol.nterm global)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm qualid)))
                           (fun quid _ g _ loc -> 
# 290 "vernac/g_vernac.mlg"
            VernacRegister(g, RegisterCoqlib quid) 
# 771 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Combined"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Scheme"))))))
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("from"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm identref)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                           (fun l _ id _ _ loc -> 
# 288 "vernac/g_vernac.mlg"
                                              VernacCombinedScheme (id, l) 
# 790 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Scheme"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Boolean"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Equality"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("for"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun id _ _ _ _ loc -> 
# 286 "vernac/g_vernac.mlg"
            VernacSchemeEquality (SchemeBooleanEquality,id) 
# 810 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Scheme"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Equality"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("for"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun id _ _ _ loc -> 
# 284 "vernac/g_vernac.mlg"
            VernacSchemeEquality (SchemeEquality,id) 
# 827 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scheme"))))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm scheme)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun l _ loc -> 
# 282 "vernac/g_vernac.mlg"
                                                         VernacScheme l 
# 838 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Let"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("CoFixpoint")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm cofix_definition)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun corecs _ _ loc -> 
# 281 "vernac/g_vernac.mlg"
            VernacCoFixpoint (DoDischarge, corecs) 
# 851 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("CoFixpoint")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm cofix_definition)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun corecs _ loc -> 
# 279 "vernac/g_vernac.mlg"
            VernacCoFixpoint (NoDischarge, corecs) 
# 861 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Let"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Fixpoint")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm fix_definition)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun recs _ _ loc -> 
# 277 "vernac/g_vernac.mlg"
            VernacFixpoint (DoDischarge, List.split recs) 
# 874 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Fixpoint")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm fix_definition)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun recs _ loc -> 
# 275 "vernac/g_vernac.mlg"
            VernacFixpoint (NoDischarge, List.split recs) 
# 884 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm inductive_token)))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm inductive_or_record_definition)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("with"))])) false)))
                           (fun indl f loc -> 
# 273 "vernac/g_vernac.mlg"
            VernacInductive (f, indl) 
# 894 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm finite_token)))
                            ((Procq.Symbol.nterm inductive_or_record_definition)))
                           (fun ind f loc -> 
# 271 "vernac/g_vernac.mlg"
            VernacInductive (f, [ind]) 
# 904 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Let"))))))
                             ((Procq.Symbol.nterm ident_decl)))
                            ((Procq.Symbol.nterm def_body)))
                           (fun b id _ loc -> 
# 268 "vernac/g_vernac.mlg"
            VernacDefinition ((DoDischarge, Let), name_of_ident_decl id, b) 
# 917 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Symbols"))))))
                            ((Procq.Symbol.nterm assum_list)))
                           (fun bl _ loc -> 
# 265 "vernac/g_vernac.mlg"
            test_plural_form loc "Symbols" bl;
            VernacSymbol bl 
# 929 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Symbol"))))))
                            ((Procq.Symbol.nterm assum_list)))
                           (fun bl _ loc -> 
# 263 "vernac/g_vernac.mlg"
            VernacSymbol bl 
# 940 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm def_token)))
                             ((Procq.Symbol.nterm ident_decl)))
                            ((Procq.Symbol.nterm def_body)))
                           (fun b id d loc -> 
# 261 "vernac/g_vernac.mlg"
            VernacDefinition (d, name_of_ident_decl id, b) 
# 952 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm assumptions_token)))
                             ((Procq.Symbol.nterm inline)))
                            ((Procq.Symbol.nterm assum_list)))
                           (fun bl nl tk loc -> 
# 257 "vernac/g_vernac.mlg"
            let (kwd,stre) = tk in
            test_plural_form loc kwd bl;
            VernacAssumption (stre, nl, bl) 
# 966 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm assumption_token)))
                             ((Procq.Symbol.nterm inline)))
                            ((Procq.Symbol.nterm assum_list)))
                           (fun bl nl stre loc -> 
# 255 "vernac/g_vernac.mlg"
            VernacAssumption (stre, nl, bl) 
# 978 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm thm_token)))
                                ((Procq.Symbol.nterm ident_decl)))
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.list0 (Procq.Symbol.rules 
                            [Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.next_norec
                                                (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.next_norec
                                                   (Procq.Rule.stop)
                                                   ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                                                  ((Procq.Symbol.nterm ident_decl)))
                                                 ((Procq.Symbol.nterm binders)))
                                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                               ((Procq.Symbol.nterm lconstr)))
                                              (fun c _ bl id _ loc -> 
                                              
# 252 "vernac/g_vernac.mlg"
            (id,(bl,c)) 
# 1008 "vernac/g_vernac.ml"
)]))))
                           (fun l c _ bl id thm loc -> 
# 253 "vernac/g_vernac.mlg"
            VernacStartTheoremProof (thm, (id,(bl,c))::l) 
# 1013 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty register_token) in
  let () =
  Procq.grammar_extend register_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_hash_ident)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("#")))))
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            (fun r _ _ loc -> 
# 310 "vernac/g_vernac.mlg"
                                             CPrimitives.parse_op_or_type ~loc r 
# 1030 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty thm_token) in
  let () =
  Procq.grammar_extend thm_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Property"))))))
                            (fun _ loc -> 
# 319 "vernac/g_vernac.mlg"
                              Property 
# 1044 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Proposition"))))))
                           (fun _ loc -> 
# 318 "vernac/g_vernac.mlg"
                                 Proposition 
# 1053 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Corollary"))))))
                           (fun _ loc -> 
# 317 "vernac/g_vernac.mlg"
                               Corollary 
# 1062 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Remark"))))))
                           (fun _ loc -> 
# 316 "vernac/g_vernac.mlg"
                            Remark 
# 1071 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Fact"))))))
                           (fun _ loc -> 
# 315 "vernac/g_vernac.mlg"
                          Fact 
# 1080 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Lemma"))))))
                           (fun _ loc -> 
# 314 "vernac/g_vernac.mlg"
                           Lemma 
# 1089 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Theorem")))))
                           (fun _ loc -> 
# 313 "vernac/g_vernac.mlg"
                       Theorem 
# 1097 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty def_token) in
  let () =
  Procq.grammar_extend def_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("SubClass"))))))
                            (fun _ loc -> 
# 324 "vernac/g_vernac.mlg"
                              (NoDischarge,SubClass) 
# 1111 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Example"))))))
                           (fun _ loc -> 
# 323 "vernac/g_vernac.mlg"
                             (NoDischarge,Example) 
# 1120 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Definition")))))
                           (fun _ loc -> 
# 322 "vernac/g_vernac.mlg"
                          (NoDischarge,Definition) 
# 1128 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assumption_token) in
  let () =
  Procq.grammar_extend assumption_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Conjecture"))))))
                            (fun _ loc -> 
# 331 "vernac/g_vernac.mlg"
                                (NoDischarge, Conjectural) 
# 1142 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Parameter")))))
                           (fun _ loc -> 
# 330 "vernac/g_vernac.mlg"
                         (NoDischarge, Definitional) 
# 1150 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Axiom")))))
                           (fun _ loc -> 
# 329 "vernac/g_vernac.mlg"
                     (NoDischarge, Logical) 
# 1158 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Variable")))))
                           (fun _ loc -> 
# 328 "vernac/g_vernac.mlg"
                        (DoDischarge, Definitional) 
# 1166 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Hypothesis")))))
                           (fun _ loc -> 
# 327 "vernac/g_vernac.mlg"
                          (DoDischarge, Logical) 
# 1174 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assumptions_token) in
  let () =
  Procq.grammar_extend assumptions_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Conjectures"))))))
                            (fun _ loc -> 
# 338 "vernac/g_vernac.mlg"
                                 ("Conjectures", (NoDischarge, Conjectural)) 
# 1188 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Parameters"))))))
                           (fun _ loc -> 
# 337 "vernac/g_vernac.mlg"
                                ("Parameters", (NoDischarge, Definitional)) 
# 1197 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Axioms"))))))
                           (fun _ loc -> 
# 336 "vernac/g_vernac.mlg"
                            ("Axioms", (NoDischarge, Logical)) 
# 1206 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Variables"))))))
                           (fun _ loc -> 
# 335 "vernac/g_vernac.mlg"
                               ("Variables", (DoDischarge, Definitional)) 
# 1215 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Hypotheses"))))))
                           (fun _ loc -> 
# 334 "vernac/g_vernac.mlg"
                                ("Hypotheses", (DoDischarge, Logical)) 
# 1224 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty inline) in
  let () =
  Procq.grammar_extend inline
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 343 "vernac/g_vernac.mlg"
             NoInline 
# 1235 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Inline"))))))
                           (fun _ loc -> 
# 342 "vernac/g_vernac.mlg"
                            DefaultInline 
# 1244 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Inline"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ i _ _ loc -> 
# 341 "vernac/g_vernac.mlg"
                                                   InlineAt i 
# 1259 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_constraint) in
  let () =
  Procq.grammar_extend univ_constraint
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm universe_name)))
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.next_norec
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("<=")))))
                                                   (fun _ loc -> 
# 346 "vernac/g_vernac.mlg"
                                                                                       Univ.Le 
# 1278 "vernac/g_vernac.ml"
);
                                                   Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 346 "vernac/g_vernac.mlg"
                                                                 Univ.Eq 
# 1289 "vernac/g_vernac.ml"
);
                                                   Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("<")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 346 "vernac/g_vernac.mlg"
                                            Univ.Lt 
# 1300 "vernac/g_vernac.ml"
)])))
                             ((Procq.Symbol.nterm universe_name)))
                            (fun r ord l loc -> 
# 347 "vernac/g_vernac.mlg"
                               (l, ord, r) 
# 1306 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_decl_constraints) in
  let () =
  Procq.grammar_extend univ_decl_constraints
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.rules [Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.nterm bar_cbrace)))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 352 "vernac/g_vernac.mlg"
                                                  false 
# 1324 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 352 "vernac/g_vernac.mlg"
                         true 
# 1334 "vernac/g_vernac.ml"
)])))
                            (fun ext loc -> 
# 352 "vernac/g_vernac.mlg"
                                                                 ([], ext) 
# 1339 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                              ((Procq.Symbol.list0sep ((Procq.Symbol.nterm univ_constraint)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 351 "vernac/g_vernac.mlg"
                                       false 
# 1354 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 351 "vernac/g_vernac.mlg"
                         true 
# 1364 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                           (fun _ ext l' _ loc -> 
# 351 "vernac/g_vernac.mlg"
                                                           (l',ext) 
# 1370 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_decl) in
  let () =
  Procq.grammar_extend univ_decl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                               ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.stop) (fun
                                                   loc -> 
# 376 "vernac/g_vernac.mlg"
                                                                false 
# 1389 "vernac/g_vernac.ml"
);
                                                   Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 376 "vernac/g_vernac.mlg"
                                                  true 
# 1400 "vernac/g_vernac.ml"
)])))
                             ((Procq.Symbol.nterm univ_decl_constraints)))
                            (fun cs ext l _ loc -> 
# 379 "vernac/g_vernac.mlg"
           let open UState in
         { univdecl_qualities = [];
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1412 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 366 "vernac/g_vernac.mlg"
                                                                                           false 
# 1431 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 366 "vernac/g_vernac.mlg"
                                                                             true 
# 1441 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.nterm univ_decl_constraints)))
                           (fun cs ext l _ l0 _ loc -> 
# 369 "vernac/g_vernac.mlg"
           let open UState in
         { univdecl_qualities = l0;
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1453 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                 ((Procq.Symbol.nterm test_doublepipe_univ_decl)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                               ((Procq.Symbol.rules [Procq.Rules.make 
                                                    (Procq.Rule.next_norec
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                    (fun _ loc -> 
# 355 "vernac/g_vernac.mlg"
                                                                                     loc 
# 1473 "vernac/g_vernac.ml"
)])))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 355 "vernac/g_vernac.mlg"
                                                                                                                                                  false 
# 1482 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 355 "vernac/g_vernac.mlg"
                                                                                                                                    true 
# 1492 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.nterm univ_decl_constraints)))
                           (fun cs ext l pipe_loc l0 _ _ loc -> 
# 358 "vernac/g_vernac.mlg"
           let open UState in
           G_constr.warn_old_sort_syntax ~loc:pipe_loc ();
         { univdecl_qualities = l0;
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1505 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty variance) in
  let () =
  Procq.grammar_extend variance
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            (fun _ loc -> 
# 391 "vernac/g_vernac.mlg"
                 UVars.Variance.Irrelevant 
# 1518 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("=")))))
                           (fun _ loc -> 
# 390 "vernac/g_vernac.mlg"
                 UVars.Variance.Invariant 
# 1526 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                           (fun _ loc -> 
# 389 "vernac/g_vernac.mlg"
                 UVars.Variance.Covariant 
# 1534 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty variance_identref) in
  let () =
  Procq.grammar_extend variance_identref
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_variance_ident)))
                              ((Procq.Symbol.nterm variance)))
                             ((Procq.Symbol.nterm identref)))
                            (fun id v _ loc -> 
# 396 "vernac/g_vernac.mlg"
                                                              (id, Some v) 
# 1551 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm identref)))
                           (fun id loc -> 
# 395 "vernac/g_vernac.mlg"
                           (id, None) 
# 1559 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cumul_univ_decl) in
  let () =
  Procq.grammar_extend cumul_univ_decl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                               ((Procq.Symbol.list0 (Procq.Symbol.nterm variance_identref))))
                              ((Procq.Symbol.rules [Procq.Rules.make 
                                                   (Procq.Rule.stop) (fun
                                                   loc -> 
# 427 "vernac/g_vernac.mlg"
                                                                            false 
# 1578 "vernac/g_vernac.ml"
);
                                                   Procq.Rules.make (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 427 "vernac/g_vernac.mlg"
                                                              true 
# 1589 "vernac/g_vernac.ml"
)])))
                             ((Procq.Symbol.nterm univ_decl_constraints)))
                            (fun cs ext l _ loc -> 
# 430 "vernac/g_vernac.mlg"
           let open UState in
         { univdecl_qualities = [];
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1601 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                 ((Procq.Symbol.nterm test_semicolon_cumul_univ_decl)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm variance_identref))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 416 "vernac/g_vernac.mlg"
                                                                    false 
# 1622 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 416 "vernac/g_vernac.mlg"
                                                      true 
# 1632 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.nterm univ_decl_constraints)))
                           (fun cs ext l _ l0 _ _ loc -> 
# 419 "vernac/g_vernac.mlg"
           let open UState in
         { univdecl_qualities = l0;
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1644 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                                 ((Procq.Symbol.nterm test_doublepipe_cumul_univ_decl)))
                                ((Procq.Symbol.list0 (Procq.Symbol.nterm identref))))
                               ((Procq.Symbol.rules [Procq.Rules.make 
                                                    (Procq.Rule.next_norec
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                    (fun _ loc -> 
# 402 "vernac/g_vernac.mlg"
                                                                                           loc 
# 1664 "vernac/g_vernac.ml"
)])))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm variance_identref))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 403 "vernac/g_vernac.mlg"
                                                                    false 
# 1673 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 403 "vernac/g_vernac.mlg"
                                                      true 
# 1683 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.nterm univ_decl_constraints)))
                           (fun cs ext l pipe_loc l0 _ _ loc -> 
# 406 "vernac/g_vernac.mlg"
           let open UState in
           G_constr.warn_old_sort_syntax ~loc:pipe_loc ();
         { univdecl_qualities = l0;
           univdecl_extensible_qualities = false;
           univdecl_instance = l;
           univdecl_extensible_instance = ext;
           univdecl_constraints = fst cs;
           univdecl_extensible_constraints = snd cs } 
# 1696 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ident_decl) in
  let () =
  Procq.grammar_extend ident_decl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm univ_decl))))
                            (fun l i loc -> 
# 440 "vernac/g_vernac.mlg"
                                             (i, l) 
# 1711 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cumul_ident_decl) in
  let () =
  Procq.grammar_extend cumul_ident_decl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm cumul_univ_decl))))
                            (fun l i loc -> 
# 444 "vernac/g_vernac.mlg"
                                                   (i, l) 
# 1726 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty inductive_token) in
  let () =
  Procq.grammar_extend inductive_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("CoInductive"))))))
                            (fun _ loc -> 
# 449 "vernac/g_vernac.mlg"
                                 CoInductive 
# 1740 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Inductive"))))))
                           (fun _ loc -> 
# 448 "vernac/g_vernac.mlg"
                               Inductive_kw 
# 1749 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty finite_token) in
  let () =
  Procq.grammar_extend finite_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Class"))))))
                            (fun _ loc -> 
# 455 "vernac/g_vernac.mlg"
                           Class true 
# 1763 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Structure"))))))
                           (fun _ loc -> 
# 454 "vernac/g_vernac.mlg"
                               Structure 
# 1772 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Record"))))))
                           (fun _ loc -> 
# 453 "vernac/g_vernac.mlg"
                            Record 
# 1781 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Variant"))))))
                           (fun _ loc -> 
# 452 "vernac/g_vernac.mlg"
                             Variant 
# 1790 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty def_body) in
  let () =
  Procq.grammar_extend def_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun t _ bl loc -> 
# 466 "vernac/g_vernac.mlg"
          ProveBody (bl, t) 
# 1807 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm binders)))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                               ((Procq.Symbol.nterm lconstr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm reduce)))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun c red _ t _ bl loc -> 
# 464 "vernac/g_vernac.mlg"
          DefineBody (bl, red, c, Some t) 
# 1825 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm reduce)))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun c red _ bl loc -> 
# 460 "vernac/g_vernac.mlg"
          match c.CAst.v with
          | CCast(c, Some C.DEFAULTcast, t) -> DefineBody (bl, red, c, Some t)
          | _ -> DefineBody (bl, red, c, None) 
# 1841 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty reduce) in
  let () =
  Procq.grammar_extend reduce
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 470 "vernac/g_vernac.mlg"
             None 
# 1852 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Eval"))))))
                             ((Procq.Symbol.nterm red_expr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                           (fun _ r _ loc -> 
# 469 "vernac/g_vernac.mlg"
                                              Some r 
# 1865 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty notation_declaration) in
  let () =
  Procq.grammar_extend notation_declaration
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm lstring)))
                                ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                               ((Procq.Symbol.nterm constr)))
                              ((Procq.Symbol.nterm syntax_modifiers)))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                                                    (fun sc _
                                                                    loc -> 
                                                                    
# 475 "vernac/g_vernac.mlg"
                                           sc 
# 1895 "vernac/g_vernac.ml"
)]))))
                            (fun scopt modl c _ ntn loc -> 
# 476 "vernac/g_vernac.mlg"
        { ntn_decl_string = ntn; ntn_decl_interp = c;
          ntn_decl_scope = scopt;
          ntn_decl_modifiers = modl;
      } 
# 1903 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty decl_sep) in
  let () =
  Procq.grammar_extend decl_sep
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("and"))))))
                            (fun _ loc -> 
# 482 "vernac/g_vernac.mlg"
                         () 
# 1917 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty decl_notations) in
  let () =
  Procq.grammar_extend decl_notations
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 486 "vernac/g_vernac.mlg"
           [] 
# 1928 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("where")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm notation_declaration)) ((Procq.Symbol.rules 
                            [Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.stop)
                                               ((Procq.Symbol.nterm decl_sep)))
                                              (fun _ loc -> ())])) false)))
                           (fun l _ loc -> 
# 485 "vernac/g_vernac.mlg"
                                                                  l 
# 1942 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty opt_constructors_or_fields)
  in
  let () =
  Procq.grammar_extend opt_constructors_or_fields
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 492 "vernac/g_vernac.mlg"
             RecordDecl (None, [], None) 
# 1954 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                           (fun _ loc -> 
# 491 "vernac/g_vernac.mlg"
                  Constructors [] 
# 1962 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm constructors_or_record)))
                           (fun lc _ loc -> 
# 490 "vernac/g_vernac.mlg"
                                               lc 
# 1972 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty inductive_or_record_definition)
  in
  let () =
  Procq.grammar_extend inductive_or_record_definition
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next
                                  (Procq.Rule.next (Procq.Rule.stop)
                                   ((Procq.Symbol.nterm opt_coercion)))
                                  ((Procq.Symbol.nterm cumul_ident_decl)))
                                 ((Procq.Symbol.nterm binders)))
                                ((Procq.Symbol.opt (Procq.Symbol.rules 
                                [Procq.Rules.make (Procq.Rule.next_norec
                                                   (Procq.Rule.next_norec
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                   ((Procq.Symbol.nterm binders)))
                                                  (fun p _ loc -> 
# 496 "vernac/g_vernac.mlg"
                                               p 
# 2000 "vernac/g_vernac.ml"
)]))))
                               ((Procq.Symbol.opt (Procq.Symbol.rules 
                               [Procq.Rules.make (Procq.Rule.next_norec
                                                  (Procq.Rule.next_norec
                                                   (Procq.Rule.stop)
                                                   ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                                  ((Procq.Symbol.nterm lconstr)))
                                                 (fun c _ loc -> 
# 497 "vernac/g_vernac.mlg"
                                        c 
# 2011 "vernac/g_vernac.ml"
)]))))
                              ((Procq.Symbol.nterm opt_constructors_or_fields)))
                             ((Procq.Symbol.nterm decl_notations)))
                            (fun ntn lc c extrapar indpar id oc loc -> 
# 499 "vernac/g_vernac.mlg"
             (((oc,id),(indpar,extrapar),c,lc),ntn) 
# 2018 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constructors_or_record) in
  let () =
  Procq.grammar_extend constructors_or_record
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.nterm record_fields)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                             ((Procq.Symbol.nterm default_inhabitant_ident)))
                            (fun id _ fs _ loc -> 
# 512 "vernac/g_vernac.mlg"
                                                                        RecordDecl (None,fs,id) 
# 2037 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm quoted_attributes)))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.nterm record_fields)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            ((Procq.Symbol.nterm default_inhabitant_ident)))
                           (fun id _ fs _ cstr attr loc -> 
# 510 "vernac/g_vernac.mlg"
            let () = unsupported_attributes attr in
            RecordDecl (Some cstr,fs,id) 
# 2056 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm quoted_attributes)))
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.nterm constructor_type)))
                           (fun c id attr loc -> 
# 507 "vernac/g_vernac.mlg"
            Constructors [ c attr id ] 
# 2068 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm quoted_attributes)))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.nterm constructor_type)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constructor)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun l _ c id attr loc -> 
# 505 "vernac/g_vernac.mlg"
            Constructors ((c attr id)::l) 
# 2084 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                            ((Procq.Symbol.list1sep ((Procq.Symbol.nterm constructor)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                           (fun l _ loc -> 
# 502 "vernac/g_vernac.mlg"
                                                Constructors l 
# 2094 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty default_inhabitant_ident)
  in
  let () =
  Procq.grammar_extend default_inhabitant_ident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 516 "vernac/g_vernac.mlg"
             None 
# 2106 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 515 "vernac/g_vernac.mlg"
                                 Some id 
# 2116 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty opt_coercion) in
  let () =
  Procq.grammar_extend opt_coercion
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 525 "vernac/g_vernac.mlg"
              NoCoercion 
# 2127 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD (">")))))
                           (fun _ loc -> 
# 524 "vernac/g_vernac.mlg"
                 AddCoercion 
# 2135 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fix_definition) in
  let () =
  Procq.grammar_extend fix_definition
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm ident_decl)))
                                ((Procq.Symbol.nterm binders_fixannot)))
                               ((Procq.Symbol.nterm type_cstr)))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Procq.Symbol.nterm lconstr)))
                                                (fun def _ loc -> 
# 532 "vernac/g_vernac.mlg"
                                                 def 
# 2160 "vernac/g_vernac.ml"
)]))))
                             ((Procq.Symbol.nterm decl_notations)))
                            (fun notations body_def rtype bl id_decl loc -> 
# 533 "vernac/g_vernac.mlg"
            let binders, rec_order = bl in
            ((rec_order : Constrexpr.fixpoint_order_expr option), {fname = fst id_decl; univs = snd id_decl; binders; rtype; body_def; notations})
          
# 2168 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty cofix_definition) in
  let () =
  Procq.grammar_extend cofix_definition
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm ident_decl)))
                                ((Procq.Symbol.nterm binders)))
                               ((Procq.Symbol.nterm type_cstr)))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                 ((Procq.Symbol.nterm lconstr)))
                                                (fun def _ loc -> 
# 539 "vernac/g_vernac.mlg"
                                                 def 
# 2193 "vernac/g_vernac.ml"
)]))))
                             ((Procq.Symbol.nterm decl_notations)))
                            (fun notations body_def rtype binders id_decl
                            loc -> 
# 540 "vernac/g_vernac.mlg"
          {fname = fst id_decl; univs = snd id_decl; binders; rtype; body_def; notations}
        
# 2201 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rw_pattern) in
  let () =
  Procq.grammar_extend rw_pattern
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm lconstr)))
                            (fun p loc -> 
# 545 "vernac/g_vernac.mlg"
                         p 
# 2214 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty rewrite_rule) in
  let () =
  Procq.grammar_extend rewrite_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.opt (Procq.Symbol.rules 
                                [Procq.Rules.make (Procq.Rule.next_norec
                                                   (Procq.Rule.next_norec
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.nterm univ_decl)))
                                                   ((Procq.Symbol.token (Tok.PKEYWORD ("|-")))))
                                                  (fun _ u loc -> 
# 547 "vernac/g_vernac.mlg"
                                           u 
# 2235 "vernac/g_vernac.ml"
)]))))
                               ((Procq.Symbol.nterm rw_pattern)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun rhs _ lhs u loc -> 
# 549 "vernac/g_vernac.mlg"
          (u, lhs, rhs)
        
# 2244 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty scheme) in
  let () =
  Procq.grammar_extend scheme
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm scheme_kind)))
                            (fun kind _ id loc -> 
# 555 "vernac/g_vernac.mlg"
                                                     (Some id,kind) 
# 2261 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm scheme_kind)))
                           (fun kind loc -> 
# 554 "vernac/g_vernac.mlg"
                                (None,kind) 
# 2269 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty scheme_kind) in
  let () =
  Procq.grammar_extend scheme_kind
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.nterm scheme_type)))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("for")))))
                               ((Procq.Symbol.nterm smart_global)))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Sort"))))))
                             ((Procq.Symbol.nterm sort_quality_or_set)))
                            (fun sch_sort _ sch_qualid _ sch_type loc -> 
# 559 "vernac/g_vernac.mlg"
           {sch_type; sch_qualid; sch_sort} 
# 2291 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty scheme_type) in
  let () =
  Procq.grammar_extend scheme_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Case"))))))
                            (fun _ loc -> 
# 566 "vernac/g_vernac.mlg"
                          SchemeCase 
# 2305 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Elimination"))))))
                           (fun _ loc -> 
# 565 "vernac/g_vernac.mlg"
                                 SchemeElimination 
# 2314 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Minimality"))))))
                           (fun _ loc -> 
# 564 "vernac/g_vernac.mlg"
                                SchemeMinimality 
# 2323 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Induction"))))))
                           (fun _ loc -> 
# 563 "vernac/g_vernac.mlg"
                               SchemeInduction 
# 2332 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_field) in
  let () =
  Procq.grammar_extend record_field
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm quoted_attributes)))
                               ((Procq.Symbol.nterm record_binder)))
                              ((Procq.Symbol.opt (Procq.Symbol.rules 
                              [Procq.Rules.make (Procq.Rule.next_norec
                                                 (Procq.Rule.next_norec
                                                  (Procq.Rule.stop)
                                                  ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                 ((Procq.Symbol.nterm natural)))
                                                (fun n _ loc -> 
# 584 "vernac/g_vernac.mlg"
                                                                     n 
# 2355 "vernac/g_vernac.ml"
)]))))
                             ((Procq.Symbol.nterm decl_notations)))
                            (fun rfu_notation rfu_priority bd rfu_attrs
                            loc -> 
# 585 "vernac/g_vernac.mlg"
                                        
      let (rfu_coercion, rfu_instance), rf_decl = bd in
      rf_decl,
      { rfu_attrs ; rfu_coercion ; rfu_instance ; rfu_priority ;
        rfu_notation } 
# 2366 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_fields) in
  let () =
  Procq.grammar_extend record_fields
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 594 "vernac/g_vernac.mlg"
             [] 
# 2377 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm record_field)))
                           (fun f loc -> 
# 593 "vernac/g_vernac.mlg"
                              [f] 
# 2385 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm record_field)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (";")))))
                            ((Procq.Symbol.nterm record_fields)))
                           (fun fs _ f loc -> 
# 592 "vernac/g_vernac.mlg"
                                                       f :: fs 
# 2397 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty field_body) in
  let () =
  Procq.grammar_extend field_body
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun b _ l loc -> 
# 603 "vernac/g_vernac.mlg"
                                            fun id ->
        (* Why are we dropping cast info here? *)
         match b.CAst.v with
         | CCast(b', _, t) ->
             ((NoCoercion,NoInstance),DefExpr(id,l,b',Some t))
         | _ ->
             ((NoCoercion,NoInstance),DefExpr(id,l,b,None)) 
# 2420 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm binders)))
                               ((Procq.Symbol.nterm of_type_inst)))
                              ((Procq.Symbol.nterm lconstr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun b _ t oc l loc -> 
# 601 "vernac/g_vernac.mlg"
                                             fun id ->
           (oc,DefExpr (id,l,b,Some t)) 
# 2437 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm binders)))
                             ((Procq.Symbol.nterm of_type_inst)))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun t oc l loc -> 
# 599 "vernac/g_vernac.mlg"
                          fun id -> (oc,AssumExpr (id,l,t)) 
# 2449 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty record_binder) in
  let () =
  Procq.grammar_extend record_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.nterm field_body)))
                            (fun f id loc -> 
# 613 "vernac/g_vernac.mlg"
                                       f id 
# 2464 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm name)))
                           (fun id loc -> 
# 612 "vernac/g_vernac.mlg"
                       ((NoCoercion,NoInstance),AssumExpr(id, [], CAst.make ~loc @@ CHole (None))) 
# 2472 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assum_list) in
  let () =
  Procq.grammar_extend assum_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm assumpt)))
                            (fun b loc -> 
# 616 "vernac/g_vernac.mlg"
                                                          [b] 
# 2485 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm assum_coe)))))
                           (fun bl loc -> 
# 616 "vernac/g_vernac.mlg"
                                  bl 
# 2493 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assum_coe) in
  let () =
  Procq.grammar_extend assum_coe
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm assumpt)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ a _ loc -> 
# 619 "vernac/g_vernac.mlg"
                                   a 
# 2510 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty assumpt) in
  let () =
  Procq.grammar_extend assumpt
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm ident_decl)))))
                              ((Procq.Symbol.nterm of_type)))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c oc idl loc -> 
# 623 "vernac/g_vernac.mlg"
          (oc,(idl,c)) 
# 2527 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constructor_type) in
  let () =
  Procq.grammar_extend constructor_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm binders)))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 631 "vernac/g_vernac.mlg"
                   fun l attr id -> ((attr,NoCoercion,NoInstance),(id,mkProdCN ~loc l (CAst.make ~loc @@ CHole (None)))) 
# 2544 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.nterm of_type_inst)))
                                                                    ((Procq.Symbol.nterm lconstr)))
                                                                   (fun c coe
                                                                   loc -> 
                                                                   
# 629 "vernac/g_vernac.mlg"
                      fun l attr id -> ((attr, fst coe, snd coe),(id,mkProdCN ~loc l c)) 
# 2557 "vernac/g_vernac.ml"
)])))
                            (fun t l loc -> 
# 632 "vernac/g_vernac.mlg"
              t l 
# 2562 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty constructor) in
  let () =
  Procq.grammar_extend constructor
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm quoted_attributes)))
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.nterm constructor_type)))
                            (fun c id attr loc -> 
# 638 "vernac/g_vernac.mlg"
                                               c attr id 
# 2579 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty of_type) in
  let () =
  Procq.grammar_extend of_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            (fun _ loc -> 
# 643 "vernac/g_vernac.mlg"
                   NoCoercion 
# 2592 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (">")))))
                           (fun _ _ loc -> 
# 642 "vernac/g_vernac.mlg"
                        AddCoercion 
# 2602 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD (":>")))))
                           (fun _ loc -> 
# 641 "vernac/g_vernac.mlg"
                    AddCoercion 
# 2610 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty of_type_inst) in
  let () =
  Procq.grammar_extend of_type_inst
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            (fun _ loc -> 
# 650 "vernac/g_vernac.mlg"
                   (NoCoercion, NoInstance) 
# 2623 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("::>")))))
                           (fun _ loc -> 
# 649 "vernac/g_vernac.mlg"
                     (AddCoercion, BackInstance) 
# 2631 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("::")))))
                           (fun _ loc -> 
# 648 "vernac/g_vernac.mlg"
                    (NoCoercion, BackInstance) 
# 2639 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (">")))))
                           (fun _ _ loc -> 
# 647 "vernac/g_vernac.mlg"
                        (AddCoercion, NoInstance) 
# 2649 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD (":>")))))
                           (fun _ loc -> 
# 646 "vernac/g_vernac.mlg"
                    (AddCoercion, NoInstance) 
# 2657 "vernac/g_vernac.ml"
)])]))
  in ()


# 654 "vernac/g_vernac.mlg"
 

let test_only_starredidentrefs =
  let open Procq.Lookahead in
  to_entry "test_only_starredidentrefs" begin
    lk_list (lk_ident <+> lk_kws ["Type"; "*"]) >> (lk_kws [".";")"])
  end

let starredidentreflist_to_expr l =
  match l with
  | [] -> SsEmpty
  | x :: xs -> List.fold_right (fun i acc -> SsUnion(i,acc)) xs x

let warn_deprecated_include_type =
  CWarnings.create ~name:"deprecated-include-type" ~category:Deprecation.Version.v8_3
         (fun () -> strbrk "Include Type is deprecated; use Include instead")

let warn_deprecated_as_ident_kind =
  CWarnings.create ~name:"deprecated-as-ident-kind" ~category:Deprecation.Version.v8_14
         (fun () -> strbrk "grammar kind \"as ident\" no longer accepts \"_\"; use \"as name\" instead to accept \"_\", too, or silence the warning if you actually intended to accept only identifiers.")


# 2685 "vernac/g_vernac.ml"

let _ =
  let import_categories = Procq.Entry.make "import_categories"
  and filtered_import = Procq.Entry.make "filtered_import"
  and one_import_filter_name = Procq.Entry.make "one_import_filter_name"
  and export_token = Procq.Entry.make "export_token"
  and ext_module_type = Procq.Entry.make "ext_module_type"
  and ext_module_expr = Procq.Entry.make "ext_module_expr"
  and check_module_type = Procq.Entry.make "check_module_type"
  and check_module_types = Procq.Entry.make "check_module_types"
  and of_module_type = Procq.Entry.make "of_module_type"
  and is_module_type = Procq.Entry.make "is_module_type"
  and is_module_expr = Procq.Entry.make "is_module_expr"
  and functor_app_annot = Procq.Entry.make "functor_app_annot"
  and module_expr_inl = Procq.Entry.make "module_expr_inl"
  and module_type_inl = Procq.Entry.make "module_type_inl"
  and module_binder = Procq.Entry.make "module_binder"
  and module_expr_atom = Procq.Entry.make "module_expr_atom"
  and with_declaration = Procq.Entry.make "with_declaration"
  and starredidentref = Procq.Entry.make "starredidentref"
  and ssexpr = Procq.Entry.make "ssexpr"
  in
  let () = assert (Procq.Entry.is_empty gallina_ext) in
  let () =
  Procq.grammar_extend gallina_ext
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Include"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                              ((Procq.Symbol.nterm module_type_inl)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm ext_module_type))))
                            (fun l e _ _ loc -> 
# 723 "vernac/g_vernac.mlg"
           warn_deprecated_include_type ~loc ();
        VernacSynterp (VernacInclude(e::l)) 
# 2727 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Include"))))))
                             ((Procq.Symbol.nterm module_type_inl)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm ext_module_type))))
                           (fun l e _ loc -> 
# 721 "vernac/g_vernac.mlg"
            VernacSynterp (VernacInclude(e::l)) 
# 2740 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Export"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm import_categories))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm filtered_import)))))
                           (fun qidl cats _ loc -> 
# 719 "vernac/g_vernac.mlg"
          VernacSynterp (VernacImport ((Export,cats),qidl)) 
# 2753 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Import"))))))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm import_categories))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm filtered_import)))))
                           (fun qidl cats _ loc -> 
# 717 "vernac/g_vernac.mlg"
          VernacSynterp (VernacImport ((Import,cats),qidl)) 
# 2766 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("From"))))))
                               ((Procq.Symbol.nterm global)))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Require"))))))
                             ((Procq.Symbol.nterm export_token)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm filtered_import)))))
                           (fun qidl export _ ns _ loc -> 
# 715 "vernac/g_vernac.mlg"
          VernacSynterp (VernacRequire (Some ns, export, qidl)) 
# 2784 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Require"))))))
                             ((Procq.Symbol.nterm export_token)))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm filtered_import)))))
                           (fun qidl export _ loc -> 
# 712 "vernac/g_vernac.mlg"
            VernacSynterp (VernacRequire (None, export, qidl)) 
# 2797 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("From"))))))
                                ((Procq.Symbol.nterm global)))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Extra"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Dependency"))))))
                             ((Procq.Symbol.nterm ne_string)))
                            ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                   (Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                                                   (fun id _
                                                                   loc -> 
                                                                   
# 707 "vernac/g_vernac.mlg"
                                         id 
# 2826 "vernac/g_vernac.ml"
)]))))
                           (fun id f _ _ ns _ loc -> 
# 708 "vernac/g_vernac.mlg"
            VernacSynterp (VernacExtraDependency (ns, f, Option.map Id.of_string id)) 
# 2831 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Collection"))))))
                              ((Procq.Symbol.nterm identref)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm section_subset_expr)))
                           (fun expr _ id _ loc -> 
# 702 "vernac/g_vernac.mlg"
            VernacSynPure (VernacNameSectionHypSet (id, expr)) 
# 2846 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("End"))))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 698 "vernac/g_vernac.mlg"
                                        VernacSynterp (VernacEndSegment id) 
# 2857 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Section"))))))
                            ((Procq.Symbol.nterm identref)))
                           (fun id _ loc -> 
# 695 "vernac/g_vernac.mlg"
                                            VernacSynterp (VernacBeginSection id) 
# 2868 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("Declare"))))))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Module"))))))
                                ((Procq.Symbol.nterm export_token)))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm module_binder))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm module_type_inl)))
                           (fun mty _ bl id export _ _ loc -> 
# 693 "vernac/g_vernac.mlg"
            VernacSynterp (VernacDeclareModule (export, id, bl, mty)) 
# 2890 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Module"))))))
                                ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm module_binder))))
                             ((Procq.Symbol.nterm check_module_types)))
                            ((Procq.Symbol.nterm is_module_type)))
                           (fun body sign bl id _ _ loc -> 
# 690 "vernac/g_vernac.mlg"
            VernacSynterp (VernacDeclareModuleType (id, bl, sign, body)) 
# 2909 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Module"))))))
                                ((Procq.Symbol.nterm export_token)))
                               ((Procq.Symbol.nterm identref)))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm module_binder))))
                             ((Procq.Symbol.nterm of_module_type)))
                            ((Procq.Symbol.nterm is_module_expr)))
                           (fun body sign bl id export _ loc -> 
# 686 "vernac/g_vernac.mlg"
            VernacSynterp (VernacDefineModule (export, id, bl, sign, body)) 
# 2928 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty import_categories) in
  let () =
  Procq.grammar_extend import_categories
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD ("-"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm qualid)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ cats _ negative loc -> 
# 728 "vernac/g_vernac.mlg"
        let cats = List.map (fun cat -> CAst.make ?loc:cat.CAst.loc (Libnames.string_of_qualid cat)) cats in
        { negative=Option.has_some negative; import_cats = cats } 
# 2948 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty filtered_import) in
  let () =
  Procq.grammar_extend filtered_import
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm global)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.nterm one_import_filter_name)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ ns _ m loc -> 
# 734 "vernac/g_vernac.mlg"
                                                                             (m, ImportNames ns) 
# 2967 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm global)))
                           (fun m loc -> 
# 733 "vernac/g_vernac.mlg"
                        (m, ImportAll) 
# 2975 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty one_import_filter_name) in
  let () =
  Procq.grammar_extend one_import_filter_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm global)))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("..")))))
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                                                                    (fun _ _
                                                                    _ loc ->
                                                                    
# 737 "vernac/g_vernac.mlg"
                                                    () 
# 3002 "vernac/g_vernac.ml"
)]))))
                            (fun etc n loc -> 
# 737 "vernac/g_vernac.mlg"
                                                                n, Option.has_some etc 
# 3007 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty export_token) in
  let () =
  Procq.grammar_extend export_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 742 "vernac/g_vernac.mlg"
              None 
# 3018 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Export"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm import_categories))))
                           (fun cats _ loc -> 
# 741 "vernac/g_vernac.mlg"
                                                          Some (Export,cats) 
# 3029 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Import"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm import_categories))))
                           (fun cats _ loc -> 
# 740 "vernac/g_vernac.mlg"
                                                          Some (Import,cats) 
# 3040 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ext_module_type) in
  let () =
  Procq.grammar_extend ext_module_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("<+")))))
                             ((Procq.Symbol.nterm module_type_inl)))
                            (fun mty _ loc -> 
# 745 "vernac/g_vernac.mlg"
                                         mty 
# 3055 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ext_module_expr) in
  let () =
  Procq.grammar_extend ext_module_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("<+")))))
                             ((Procq.Symbol.nterm module_expr_inl)))
                            (fun mexpr _ loc -> 
# 748 "vernac/g_vernac.mlg"
                                           mexpr 
# 3070 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty check_module_type) in
  let () =
  Procq.grammar_extend check_module_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("<:")))))
                             ((Procq.Symbol.nterm module_type_inl)))
                            (fun mty _ loc -> 
# 751 "vernac/g_vernac.mlg"
                                         mty 
# 3085 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty check_module_types) in
  let () =
  Procq.grammar_extend check_module_types
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm check_module_type))))
                            (fun mtys loc -> 
# 754 "vernac/g_vernac.mlg"
                                            mtys 
# 3098 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty of_module_type) in
  let () =
  Procq.grammar_extend of_module_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm check_module_types)))
                            (fun mtys loc -> 
# 758 "vernac/g_vernac.mlg"
                                       Check mtys 
# 3111 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm module_type_inl)))
                           (fun mty _ loc -> 
# 757 "vernac/g_vernac.mlg"
                                        Enforce mty 
# 3121 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty is_module_type) in
  let () =
  Procq.grammar_extend is_module_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 762 "vernac/g_vernac.mlg"
             [] 
# 3132 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm module_type_inl)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm ext_module_type))))
                           (fun l mty _ loc -> 
# 761 "vernac/g_vernac.mlg"
                                                                     (mty::l) 
# 3144 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty is_module_expr) in
  let () =
  Procq.grammar_extend is_module_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 766 "vernac/g_vernac.mlg"
             [] 
# 3155 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm module_expr_inl)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm ext_module_expr))))
                           (fun l mexpr _ loc -> 
# 765 "vernac/g_vernac.mlg"
                                                                      (mexpr::l) 
# 3167 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty functor_app_annot) in
  let () =
  Procq.grammar_extend functor_app_annot
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 772 "vernac/g_vernac.mlg"
             DefaultInline 
# 3178 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("no"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("inline"))))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ _ _ _ loc -> 
# 771 "vernac/g_vernac.mlg"
                                                  NoInline 
# 3194 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("inline"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("level"))))))
                             ((Procq.Symbol.nterm natural)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ i _ _ _ _ loc -> 
# 770 "vernac/g_vernac.mlg"
          InlineAt i 
# 3214 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_expr_inl) in
  let () =
  Procq.grammar_extend module_expr_inl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm module_expr)))
                             ((Procq.Symbol.nterm functor_app_annot)))
                            (fun a me loc -> 
# 777 "vernac/g_vernac.mlg"
                                                     (me,a) 
# 3229 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm module_expr)))
                           (fun me _ loc -> 
# 776 "vernac/g_vernac.mlg"
                                   (me,NoInline) 
# 3239 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_type_inl) in
  let () =
  Procq.grammar_extend module_type_inl
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm module_type)))
                             ((Procq.Symbol.nterm functor_app_annot)))
                            (fun a me loc -> 
# 781 "vernac/g_vernac.mlg"
                                                     (me,a) 
# 3254 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.nterm module_type)))
                           (fun me _ loc -> 
# 780 "vernac/g_vernac.mlg"
                                   (me,NoInline) 
# 3264 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_binder) in
  let () =
  Procq.grammar_extend module_binder
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                                 ((Procq.Symbol.nterm export_token)))
                                ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                               ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                              ((Procq.Symbol.nterm module_type_inl)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ mty _ idl export _ loc -> 
# 786 "vernac/g_vernac.mlg"
                                         (export,idl,mty) 
# 3287 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_expr) in
  let () =
  Procq.grammar_extend module_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm module_expr)))
                             ((Procq.Symbol.nterm module_expr_atom)))
                            (fun me2 me1 loc -> 
# 791 "vernac/g_vernac.mlg"
                                                       CAst.make ~loc @@ CMapply (me1,me2) 
# 3302 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm module_expr_atom)))
                           (fun me loc -> 
# 790 "vernac/g_vernac.mlg"
                                   CAst.make ~loc @@ CMident me 
# 3310 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_expr_atom) in
  let () =
  Procq.grammar_extend module_expr_atom
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm module_expr_atom)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ me _ loc -> 
# 795 "vernac/g_vernac.mlg"
                                                                       me 
# 3327 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm qualid)))
                           (fun qid loc -> 
# 795 "vernac/g_vernac.mlg"
                          qid 
# 3335 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty with_declaration) in
  let () =
  Procq.grammar_extend with_declaration
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Module"))))))
                               ((Procq.Symbol.nterm fullyqualid)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm qualid)))
                            (fun qid _ fqid _ loc -> 
# 801 "vernac/g_vernac.mlg"
            CWith_Module (fqid,qid) 
# 3355 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("Definition")))))
                               ((Procq.Symbol.nterm fullyqualid)))
                              ((Procq.Symbol.opt (Procq.Symbol.nterm univ_decl))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm Constr.lconstr)))
                           (fun c _ udecl fqid _ loc -> 
# 799 "vernac/g_vernac.mlg"
            CWith_Definition (fqid,udecl,c) 
# 3371 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty module_type) in
  let () =
  Procq.grammar_extend module_type
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm module_type)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                             ((Procq.Symbol.nterm with_declaration)))
                            (fun decl _ mty loc -> 
# 810 "vernac/g_vernac.mlg"
            CAst.make ~loc @@ CMwith (mty,decl) 
# 3388 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm module_type)))
                            ((Procq.Symbol.nterm module_expr_atom)))
                           (fun me mty loc -> 
# 808 "vernac/g_vernac.mlg"
            CAst.make ~loc @@ CMapply (mty,me) 
# 3398 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm module_type)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ mt _ loc -> 
# 806 "vernac/g_vernac.mlg"
                                        mt 
# 3410 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm qualid)))
                           (fun qid loc -> 
# 805 "vernac/g_vernac.mlg"
                          CAst.make ~loc @@ CMident qid 
# 3418 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty section_subset_expr) in
  let () =
  Procq.grammar_extend section_subset_expr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ssexpr)))
                            (fun e loc -> 
# 817 "vernac/g_vernac.mlg"
                        e 
# 3431 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm test_only_starredidentrefs)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm starredidentref))))
                           (fun l _ loc -> 
# 816 "vernac/g_vernac.mlg"
            starredidentreflist_to_expr l 
# 3441 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty starredidentref) in
  let () =
  Procq.grammar_extend starredidentref
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                            (fun _ _ loc -> 
# 823 "vernac/g_vernac.mlg"
                         SsFwdClose SsType 
# 3456 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                           (fun _ loc -> 
# 822 "vernac/g_vernac.mlg"
                    SsType 
# 3464 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ i loc -> 
# 821 "vernac/g_vernac.mlg"
                               SsFwdClose(SsSingl i) 
# 3474 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm identref)))
                           (fun i loc -> 
# 820 "vernac/g_vernac.mlg"
                          SsSingl i 
# 3482 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ssexpr) in
  let () =
  Procq.grammar_extend ssexpr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(Some ("35"), None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                             ((Procq.Symbol.nterm ssexpr)))
                            (fun e _ loc -> 
# 827 "vernac/g_vernac.mlg"
                             SsCompl e 
# 3497 "vernac/g_vernac.ml"
)]);
                          (Some ("50"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ssexpr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                            ((Procq.Symbol.nterm ssexpr)))
                           (fun e2 _ e1 loc -> 
# 830 "vernac/g_vernac.mlg"
                                          SsUnion(e1,e2) 
# 3510 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ssexpr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                           ((Procq.Symbol.nterm ssexpr)))
                          (fun e2 _ e1 loc -> 
# 829 "vernac/g_vernac.mlg"
                                          SsSubstr(e1,e2) 
# 3522 "vernac/g_vernac.ml"
)]);
                          (Some ("0"), None,
                          [Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm ssexpr)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ _ e _ loc -> 
# 839 "vernac/g_vernac.mlg"
                                       SsFwdClose e 
# 3537 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                            ((Procq.Symbol.nterm ssexpr)))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ e _ loc -> 
# 838 "vernac/g_vernac.mlg"
                                 e 
# 3549 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm test_only_starredidentrefs)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm starredidentref))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                          (fun _ _ l _ _ loc -> 
# 837 "vernac/g_vernac.mlg"
            SsFwdClose(starredidentreflist_to_expr l) 
# 3565 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.nterm test_only_starredidentrefs)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm starredidentref))))
                           ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                          (fun _ l _ _ loc -> 
# 835 "vernac/g_vernac.mlg"
            starredidentreflist_to_expr l 
# 3579 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PKEYWORD ("()")))))
                          (fun _ loc -> 
# 833 "vernac/g_vernac.mlg"
                  SsEmpty 
# 3587 "vernac/g_vernac.ml"
);
                          Procq.Production.make
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.nterm starredidentref)))
                          (fun i loc -> 
# 832 "vernac/g_vernac.mlg"
                                 i 
# 3595 "vernac/g_vernac.ml"
)])]))
  in ()

let _ =
  let args_modifier = Procq.Entry.make "args_modifier"
  and argument_spec = Procq.Entry.make "argument_spec"
  and arg_specs = Procq.Entry.make "arg_specs"
  and implicits_alt = Procq.Entry.make "implicits_alt"
  and instance_name = Procq.Entry.make "instance_name"
  and reserv_list = Procq.Entry.make "reserv_list"
  and reserv_tuple = Procq.Entry.make "reserv_tuple"
  and simple_reserv = Procq.Entry.make "simple_reserv"
  in
  let () =
  Procq.grammar_extend gallina_ext
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Generalizable"))))))
                        ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.next_norec
                                                                (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.rules 
                                                                 [Procq.Rules.make 
                                                                 (Procq.Rule.next_norec
                                                                  (Procq.Rule.stop)
                                                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                  ("Variables"))))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 927 "vernac/g_vernac.mlg"
                                                              () 
# 3630 "vernac/g_vernac.ml"
);
                                                                 Procq.Rules.make 
                                                                 (Procq.Rule.next_norec
                                                                  (Procq.Rule.stop)
                                                                  ((Procq.Symbol.token (Tok.PKEYWORD ("Variable")))))
                                                                 (fun _
                                                                 loc -> 
                                                                 
# 927 "vernac/g_vernac.mlg"
                                () 
# 3641 "vernac/g_vernac.ml"
)])))
                                                                ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                                                               (fun idl _
                                                               loc -> 
                                                               
# 928 "vernac/g_vernac.mlg"
                                            Some idl 
# 3649 "vernac/g_vernac.ml"
);
                                             Procq.Rules.make (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                ("No"))))))
                                                               ((Procq.Symbol.token (Tok.PIDENT (Some
                                                               ("Variables"))))))
                                                              (fun _ _ loc ->
                                                              
# 926 "vernac/g_vernac.mlg"
                                                  None 
# 3662 "vernac/g_vernac.ml"
);
                                             Procq.Rules.make (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                ("All"))))))
                                                               ((Procq.Symbol.token (Tok.PIDENT (Some
                                                               ("Variables"))))))
                                                              (fun _ _ loc ->
                                                              
# 925 "vernac/g_vernac.mlg"
                                                      Some [] 
# 3675 "vernac/g_vernac.ml"
)])))
                       (fun gen _ loc -> 
# 929 "vernac/g_vernac.mlg"
               VernacSynPure (VernacGeneralizable gen) 
# 3680 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Implicit"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Types"))))))
                       ((Procq.Symbol.nterm reserv_list)))
                      (fun bl _ _ loc -> 
# 921 "vernac/g_vernac.mlg"
            test_plural_form_types loc "Implicit Types" bl;
           VernacSynPure (VernacReserve bl) 
# 3694 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Implicit"))))))
                        ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                       ((Procq.Symbol.nterm reserv_list)))
                      (fun bl _ _ loc -> 
# 918 "vernac/g_vernac.mlg"
             VernacSynPure (VernacReserve bl) 
# 3707 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("Arguments"))))))
                          ((Procq.Symbol.nterm smart_global)))
                         ((Procq.Symbol.list0 (Procq.Symbol.nterm arg_specs))))
                        ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                                                                ((Procq.Symbol.list1sep ((Procq.Symbol.rules 
                                                                [Procq.Rules.make 
                                                                (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.list0 (Procq.Symbol.nterm implicits_alt))))
                                                                (fun impl
                                                                loc -> 
                                                                
# 909 "vernac/g_vernac.mlg"
                                              List.flatten impl 
# 3734 "vernac/g_vernac.ml"
)])) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                               (fun impl _
                                                               loc -> 
                                                               
# 910 "vernac/g_vernac.mlg"
                         impl 
# 3741 "vernac/g_vernac.ml"
)]))))
                       ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                                                               ((Procq.Symbol.list1sep ((Procq.Symbol.nterm args_modifier)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                                                              (fun l _ loc ->
                                                              
# 912 "vernac/g_vernac.mlg"
                                                               l 
# 3753 "vernac/g_vernac.ml"
)]))))
                      (fun mods more_implicits args qid _ loc -> 
# 913 "vernac/g_vernac.mlg"
           let mods = match mods with None -> [] | Some l -> List.flatten l in
         let more_implicits = Option.default [] more_implicits in
         VernacSynPure (VernacArguments (qid, List.flatten args, more_implicits, mods)) 
# 3760 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Existing"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Class"))))))
                       ((Procq.Symbol.nterm global)))
                      (fun is _ _ loc -> 
# 902 "vernac/g_vernac.mlg"
                                                          VernacSynPure (VernacExistingClass is) 
# 3773 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Existing"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Instances"))))))
                        ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                       ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                                                               ((Procq.Symbol.nterm natural)))
                                                              (fun i _ loc ->
                                                              
# 897 "vernac/g_vernac.mlg"
                                          i 
# 3795 "vernac/g_vernac.ml"
)]))))
                      (fun pri ids _ _ loc -> 
# 898 "vernac/g_vernac.mlg"
           let info = { Typeclasses.hint_priority = pri; hint_pattern = None } in
         let insts = List.map (fun i -> (i, info)) ids in
          VernacSynPure (VernacExistingInstance insts) 
# 3802 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Existing"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Instance"))))))
                        ((Procq.Symbol.nterm global)))
                       ((Procq.Symbol.nterm hint_info)))
                      (fun info id _ _ loc -> 
# 894 "vernac/g_vernac.mlg"
            VernacSynPure (VernacExistingInstance [id, info]) 
# 3818 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Instance"))))))
                           ((Procq.Symbol.nterm instance_name)))
                          ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                         ((Procq.Symbol.nterml term ("200"))))
                        ((Procq.Symbol.nterm hint_info)))
                       ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                              (fun loc -> 
                                                              
# 889 "vernac/g_vernac.mlg"
                                                            None 
# 3838 "vernac/g_vernac.ml"
);
                                            Procq.Rules.make (Procq.Rule.next_norec
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.stop)
                                                               ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                              ((Procq.Symbol.nterm lconstr)))
                                                             (fun c _ loc ->
                                                             
# 889 "vernac/g_vernac.mlg"
                                    Some (false,c) 
# 3849 "vernac/g_vernac.ml"
);
                                            Procq.Rules.make (Procq.Rule.next_norec
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                                                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                                                               ((Procq.Symbol.nterm record_declaration)))
                                                              ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                                                             (fun _ r _ _
                                                             loc -> 
# 888 "vernac/g_vernac.mlg"
                                                               Some (true,r) 
# 3864 "vernac/g_vernac.ml"
)])))
                      (fun props info t _ namesup _ loc -> 
# 890 "vernac/g_vernac.mlg"
             VernacSynPure (VernacInstance (fst namesup,snd namesup,t,props,info)) 
# 3869 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some
                        ("Context"))))))
                       ((Procq.Symbol.list1 ((Procq.Symbol.nterm binder)))))
                      (fun c _ loc -> 
# 883 "vernac/g_vernac.mlg"
            VernacSynPure (VernacContext (List.flatten c)) 
# 3880 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Coercion"))))))
                           ((Procq.Symbol.nterm by_notation)))
                          ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                         ((Procq.Symbol.nterm coercion_class)))
                        ((Procq.Symbol.token (Tok.PKEYWORD (">->")))))
                       ((Procq.Symbol.nterm coercion_class)))
                      (fun t _ s _ ntn _ loc -> 
# 880 "vernac/g_vernac.mlg"
            VernacSynPure (VernacCoercion (CAst.make ~loc @@ ByNotation ntn, Some (s, t))) 
# 3899 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Coercion"))))))
                           ((Procq.Symbol.nterm global)))
                          ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                         ((Procq.Symbol.nterm coercion_class)))
                        ((Procq.Symbol.token (Tok.PKEYWORD (">->")))))
                       ((Procq.Symbol.nterm coercion_class)))
                      (fun t _ s _ qid _ loc -> 
# 877 "vernac/g_vernac.mlg"
            VernacSynPure (VernacCoercion (CAst.make ~loc @@ AN qid, Some(s, t))) 
# 3918 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Identity"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Coercion"))))))
                           ((Procq.Symbol.nterm identref)))
                          ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                         ((Procq.Symbol.nterm coercion_class)))
                        ((Procq.Symbol.token (Tok.PKEYWORD (">->")))))
                       ((Procq.Symbol.nterm coercion_class)))
                      (fun t _ s _ f _ _ loc -> 
# 874 "vernac/g_vernac.mlg"
             VernacSynPure (VernacIdentityCoercion (f, s, t)) 
# 3940 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Coercion"))))))
                        ((Procq.Symbol.nterm global)))
                       ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.opt (Procq.Symbol.nterm univ_decl))))
                                                               ((Procq.Symbol.nterm def_body)))
                                                              (fun d u loc ->
                                                              
# 868 "vernac/g_vernac.mlg"
                                                                                        u, d 
# 3959 "vernac/g_vernac.ml"
)]))))
                      (fun ud qid _ loc -> 
# 869 "vernac/g_vernac.mlg"
            match ud with Some (u, d) -> let s = coerce_reference_to_id qid in
          VernacSynPure (VernacDefinition ((NoDischarge,Coercion),((CAst.make ?loc:qid.CAst.loc (Name s)),u),d))
          | None -> VernacSynPure (VernacCoercion (CAst.make ~loc @@ AN qid, None)) 
# 3966 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Canonical"))))))
                        ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                ("Structure"))))))
                                                               (fun _ loc ->
                                                               
# 864 "vernac/g_vernac.mlg"
                                                       ()
# 3983 "vernac/g_vernac.ml"
)]))))
                       ((Procq.Symbol.nterm by_notation)))
                      (fun ntn _ _ loc -> 
# 865 "vernac/g_vernac.mlg"
            VernacSynPure (VernacCanonical CAst.(make ~loc @@ ByNotation ntn)) 
# 3989 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Canonical"))))))
                         ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                (Procq.Rule.next_norec
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                 ("Structure"))))))
                                                                (fun _ loc ->
                                                                
# 857 "vernac/g_vernac.mlg"
                                                       ()
# 4007 "vernac/g_vernac.ml"
)]))))
                        ((Procq.Symbol.nterm global)))
                       ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.opt (Procq.Symbol.nterm univ_decl))))
                                                               ((Procq.Symbol.nterm def_body)))
                                                              (fun d u loc ->
                                                              
# 857 "vernac/g_vernac.mlg"
                                                                                                                            (u,d) 
# 4020 "vernac/g_vernac.ml"
)]))))
                      (fun ud qid _ _ loc -> 
# 858 "vernac/g_vernac.mlg"
            match ud with
           | None ->
             VernacSynPure (VernacCanonical CAst.(make ?loc:qid.CAst.loc @@ AN qid))
           | Some (u,d) ->
             let s = coerce_reference_to_id qid in
             VernacSynPure (VernacDefinition ((NoDischarge,CanonicalStructure),((CAst.make ?loc:qid.CAst.loc (Name s)),u),d)) 
# 4030 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some
                        ("Strategy"))))))
                       ((Procq.Symbol.list1 ((Procq.Symbol.rules [Procq.Rules.make 
                                                                 (Procq.Rule.next_norec
                                                                  (Procq.Rule.next_norec
                                                                   (Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.nterm strategy_level)))
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                   ((Procq.Symbol.list1 ((Procq.Symbol.nterm smart_global)))))
                                                                  ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                                                                 (fun _ q _ v
                                                                 loc -> 
                                                                 
# 854 "vernac/g_vernac.mlg"
                                                                        (v,q) 
# 4053 "vernac/g_vernac.ml"
)])))))
                      (fun l _ loc -> 
# 855 "vernac/g_vernac.mlg"
              VernacSynPure (VernacSetStrategy l) 
# 4058 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Opaque"))))))
                        ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                               (fun _ loc ->
                                                               
# 851 "vernac/g_vernac.mlg"
                                          ()
# 4074 "vernac/g_vernac.ml"
)]))))
                       ((Procq.Symbol.list1 ((Procq.Symbol.nterm smart_global)))))
                      (fun l o _ loc -> 
# 852 "vernac/g_vernac.mlg"
            VernacSynPure (VernacSetOpacity ((Conv_oracle.Opaque, l), o <> None)) 
# 4080 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("Transparent"))))))
                        ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                                                               (fun _ loc ->
                                                               
# 849 "vernac/g_vernac.mlg"
                                               ()
# 4096 "vernac/g_vernac.ml"
)]))))
                       ((Procq.Symbol.list1 ((Procq.Symbol.nterm smart_global)))))
                      (fun l o _ loc -> 
# 850 "vernac/g_vernac.mlg"
            VernacSynPure (VernacSetOpacity ((Conv_oracle.transparent, l), o <> None)) 
# 4102 "vernac/g_vernac.ml"
)]))
  in let () = assert (Procq.Entry.is_empty args_modifier) in
  let () =
  Procq.grammar_extend args_modifier
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("clear"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("implicits"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("and"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("scopes"))))))
                            (fun _ _ _ _ loc -> 
# 945 "vernac/g_vernac.mlg"
            [`ClearImplicits; `ClearScopes] 
# 4125 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("clear"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("scopes"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("and"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("implicits"))))))
                           (fun _ _ _ _ loc -> 
# 943 "vernac/g_vernac.mlg"
            [`ClearImplicits; `ClearScopes] 
# 4143 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("extra"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("scopes"))))))
                           (fun _ _ loc -> 
# 941 "vernac/g_vernac.mlg"
                                           [`ExtraScopes] 
# 4155 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("assert"))))))
                           (fun _ loc -> 
# 940 "vernac/g_vernac.mlg"
                            [`Assert] 
# 4164 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("rename"))))))
                           (fun _ loc -> 
# 939 "vernac/g_vernac.mlg"
                            [`Rename] 
# 4173 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("clear"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("bidirectionality"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("hint"))))))
                           (fun _ _ _ loc -> 
# 938 "vernac/g_vernac.mlg"
                                                                   [`ClearBidiHint] 
# 4188 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("clear"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("scopes"))))))
                           (fun _ _ loc -> 
# 937 "vernac/g_vernac.mlg"
                                           [`ClearScopes] 
# 4200 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("clear"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("implicits"))))))
                           (fun _ _ loc -> 
# 936 "vernac/g_vernac.mlg"
                                              [`ClearImplicits] 
# 4212 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("default"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("implicits"))))))
                           (fun _ _ loc -> 
# 935 "vernac/g_vernac.mlg"
                                                [`DefaultImplicits] 
# 4224 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("clear"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("simpl"))))))
                           (fun _ _ loc -> 
# 934 "vernac/g_vernac.mlg"
                                          [`ClearReduction] 
# 4236 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("simpl"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("never"))))))
                           (fun _ _ loc -> 
# 933 "vernac/g_vernac.mlg"
                                          [`SimplNeverUnfold] 
# 4248 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("simpl"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("nomatch"))))))
                           (fun _ _ loc -> 
# 932 "vernac/g_vernac.mlg"
                                            [`SimplDontExposeCase] 
# 4260 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty scope_delimiter) in
  let () =
  Procq.grammar_extend scope_delimiter
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("%_")))))
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            (fun key _ loc -> 
# 950 "vernac/g_vernac.mlg"
                               DelimOnlyTmpScope, key 
# 4275 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun key _ loc -> 
# 949 "vernac/g_vernac.mlg"
                              DelimUnboundedScope, key 
# 4285 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty argument_spec) in
  let () =
  Procq.grammar_extend argument_spec
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PKEYWORD ("!"))))))
                              ((Procq.Symbol.nterm name)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm scope_delimiter))))
                            (fun s id b loc -> 
# 954 "vernac/g_vernac.mlg"
         id.CAst.v, not (Option.is_empty b), List.map (fun x -> CAst.make ~loc x) s 
# 4302 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty arg_specs) in
  let () =
  Procq.grammar_extend arg_specs
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm argument_spec)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm scope_delimiter))))
                            (fun scl _ items _ loc -> 
# 979 "vernac/g_vernac.mlg"
         let scl = List.map (CAst.make ~loc) scl in
       List.map (fun (name,recarg_like,notation_scope) ->
           RealArg { name=name; recarg_like=recarg_like;
                 notation_scope = notation_scope @ scl;
                 implicit_status = MaxImplicit}) items 
# 4325 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.list1 ((Procq.Symbol.nterm argument_spec)))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm scope_delimiter))))
                           (fun scl _ items _ loc -> 
# 973 "vernac/g_vernac.mlg"
         let scl = List.map (CAst.make ~loc) scl in
       List.map (fun (name,recarg_like,notation_scope) ->
           RealArg { name=name; recarg_like=recarg_like;
                 notation_scope = notation_scope @ scl;
                 implicit_status = NonMaxImplicit}) items 
# 4343 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list1 ((Procq.Symbol.nterm argument_spec)))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm scope_delimiter))))
                           (fun scl _ items _ loc -> 
# 967 "vernac/g_vernac.mlg"
         let scl = List.map (CAst.make ~loc) scl in
       List.map (fun (name,recarg_like,notation_scope) ->
           RealArg { name=name; recarg_like=recarg_like;
                 notation_scope = notation_scope @ scl;
                 implicit_status = Explicit}) items 
# 4361 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("&")))))
                           (fun _ loc -> 
# 965 "vernac/g_vernac.mlg"
               [BidiArg] 
# 4369 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("/")))))
                           (fun _ loc -> 
# 964 "vernac/g_vernac.mlg"
               [VolatileArg] 
# 4377 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm argument_spec)))
                           (fun item loc -> 
# 960 "vernac/g_vernac.mlg"
        let name, recarg_like, notation_scope = item in
      [RealArg { name=name; recarg_like=recarg_like;
             notation_scope=notation_scope;
             implicit_status = Explicit}] 
# 4388 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty implicits_alt) in
  let () =
  Procq.grammar_extend implicits_alt
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("{")))))
                              ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ items _ loc -> 
# 992 "vernac/g_vernac.mlg"
         List.map (fun name -> (name.CAst.v, MaxImplicit)) items 
# 4405 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm name)))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                           (fun _ items _ loc -> 
# 990 "vernac/g_vernac.mlg"
         List.map (fun name -> (name.CAst.v, NonMaxImplicit)) items 
# 4417 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm name)))
                           (fun name loc -> 
# 988 "vernac/g_vernac.mlg"
                       [(name.CAst.v, Explicit)] 
# 4425 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty instance_name) in
  let () =
  Procq.grammar_extend instance_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 998 "vernac/g_vernac.mlg"
             ((CAst.make ~loc Anonymous), None), []  
# 4436 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident_decl)))
                            ((Procq.Symbol.nterm binders)))
                           (fun bl name loc -> 
# 997 "vernac/g_vernac.mlg"
            (CAst.map (fun id -> Name id) (fst name), snd name), bl 
# 4446 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hint_info) in
  let () =
  Procq.grammar_extend hint_info
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1003 "vernac/g_vernac.mlg"
             { Typeclasses.hint_priority = None; hint_pattern = None } 
# 4457 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm natural))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm constr_pattern))))
                           (fun pat i _ loc -> 
# 1002 "vernac/g_vernac.mlg"
           { Typeclasses.hint_priority = i; hint_pattern = pat } 
# 4469 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty reserv_list) in
  let () =
  Procq.grammar_extend reserv_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm simple_reserv)))
                            (fun b loc -> 
# 1006 "vernac/g_vernac.mlg"
                                                                   [b] 
# 4482 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm reserv_tuple)))))
                           (fun bl loc -> 
# 1006 "vernac/g_vernac.mlg"
                                     bl 
# 4490 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty reserv_tuple) in
  let () =
  Procq.grammar_extend reserv_tuple
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.nterm simple_reserv)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ a _ loc -> 
# 1009 "vernac/g_vernac.mlg"
                                         a 
# 4507 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty simple_reserv) in
  let () =
  Procq.grammar_extend simple_reserv
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.list1 ((Procq.Symbol.nterm identref)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm lconstr)))
                            (fun c _ idl loc -> 
# 1012 "vernac/g_vernac.mlg"
                                                    (idl,c) 
# 4524 "vernac/g_vernac.ml"
)])]))
  in ()


# 1017 "vernac/g_vernac.mlg"
 

(* Hack to parse "[ id" without dropping [ *)
let test_bracket_ident =
  let open Procq.Lookahead in
  to_entry "test_bracket_ident" begin
    lk_kw "[" >> lk_ident
  end


# 4540 "vernac/g_vernac.ml"

let _ = let range_selector = Procq.Entry.make "range_selector"
        in
        let () =
  assert (Procq.Entry.is_empty range_selector) in
  let () =
  Procq.grammar_extend range_selector
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm test_bracket_ident)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.nterm ident)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ id _ _ loc -> 
# 1033 "vernac/g_vernac.mlg"
                                                      Proofview.IdSelector id 
# 4562 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm natural)))
                           (fun n loc -> 
# 1032 "vernac/g_vernac.mlg"
                         Proofview.NthSelector n 
# 4570 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm natural)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                            ((Procq.Symbol.nterm natural)))
                           (fun m _ n loc -> 
# 1031 "vernac/g_vernac.mlg"
                                             Proofview.RangeSelector (n, m) 
# 4582 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty goal_selector) in
  let () =
  Procq.grammar_extend goal_selector
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm range_selector)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            (fun l loc -> 
# 1036 "vernac/g_vernac.mlg"
                                            Goal_select.SelectList l 
# 4595 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty toplevel_selector) in
  let () =
  Procq.grammar_extend toplevel_selector
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("all"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            (fun _ _ loc -> 
# 1041 "vernac/g_vernac.mlg"
                              Goal_select.SelectAll 
# 4611 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                           (fun _ _ loc -> 
# 1040 "vernac/g_vernac.mlg"
                      Goal_select.SelectAlreadyFocused 
# 4621 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm goal_selector)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                           (fun _ sel loc -> 
# 1039 "vernac/g_vernac.mlg"
                                      sel 
# 4631 "vernac/g_vernac.ml"
)])]))
  in ()

let _ =
  let printable = Procq.Entry.make "printable"
  and debug_univ_name = Procq.Entry.make "debug_univ_name"
  and printunivs_subgraph = Procq.Entry.make "printunivs_subgraph"
  and locatable = Procq.Entry.make "locatable"
  and option_setting = Procq.Entry.make "option_setting"
  and table_value = Procq.Entry.make "table_value"
  and setting_name = Procq.Entry.make "setting_name"
  and ne_in_or_out_modules = Procq.Entry.make "ne_in_or_out_modules"
  and in_or_out_modules = Procq.Entry.make "in_or_out_modules"
  and comment = Procq.Entry.make "comment"
  and positive_search_mark = Procq.Entry.make "positive_search_mark"
  and search_item = Procq.Entry.make "search_item"
  and logical_kind = Procq.Entry.make "logical_kind"
  and extended_def_token = Procq.Entry.make "extended_def_token"
  and search_where = Procq.Entry.make "search_where"
  and univ_name_list = Procq.Entry.make "univ_name_list"
  in
  let () =
  Procq.grammar_extend gallina_ext
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Export"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Unset"))))))
                        ((Procq.Symbol.nterm setting_name)))
                       (fun table _ _ loc -> 
# 1052 "vernac/g_vernac.mlg"
            VernacSynterp (VernacSetOption (true, table, OptionUnset)) 
# 4666 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Export"))))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                        ((Procq.Symbol.nterm setting_name)))
                       ((Procq.Symbol.nterm option_setting)))
                      (fun v table _ _ loc -> 
# 1050 "vernac/g_vernac.mlg"
          VernacSynterp (VernacSetOption (true, table, v)) 
# 4681 "vernac/g_vernac.ml"
)]))
  in let () = assert (Procq.Entry.is_empty command) in
  let () =
  Procq.grammar_extend command
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Remove"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm table_value)))))
                            (fun v table _ loc -> 
# 1124 "vernac/g_vernac.mlg"
            VernacSynPure (VernacRemoveOption ([table], v)) 
# 4699 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Remove"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm table_value)))))
                           (fun v field table _ loc -> 
# 1122 "vernac/g_vernac.mlg"
             VernacSynPure (VernacRemoveOption ([table;field], v)) 
# 4714 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Test"))))))
                            ((Procq.Symbol.nterm setting_name)))
                           (fun table _ loc -> 
# 1119 "vernac/g_vernac.mlg"
            VernacSynPure (VernacPrintOption table) 
# 4725 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Test"))))))
                              ((Procq.Symbol.nterm setting_name)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("for")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm table_value)))))
                           (fun v _ table _ loc -> 
# 1117 "vernac/g_vernac.mlg"
             VernacSynPure (VernacMemOption (table, v)) 
# 4740 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Add"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm table_value)))))
                           (fun v table _ loc -> 
# 1114 "vernac/g_vernac.mlg"
            VernacSynPure (VernacAddOption ([table], v)) 
# 4753 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Add"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm table_value)))))
                           (fun v field table _ loc -> 
# 1108 "vernac/g_vernac.mlg"
             VernacSynPure (VernacAddOption ([table;field], v)) 
# 4768 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Print"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Table"))))))
                            ((Procq.Symbol.nterm setting_name)))
                           (fun table _ _ loc -> 
# 1105 "vernac/g_vernac.mlg"
            VernacSynPure (VernacPrintOption table) 
# 4782 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Unset"))))))
                            ((Procq.Symbol.nterm setting_name)))
                           (fun table _ loc -> 
# 1102 "vernac/g_vernac.mlg"
            VernacSynterp (VernacSetOption (false, table, OptionUnset)) 
# 4793 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("Set")))))
                             ((Procq.Symbol.nterm setting_name)))
                            ((Procq.Symbol.nterm option_setting)))
                           (fun v table _ loc -> 
# 1100 "vernac/g_vernac.mlg"
            VernacSynterp (VernacSetOption (false, table, v)) 
# 4805 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Inspect"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 1096 "vernac/g_vernac.mlg"
                                          VernacSynPure (VernacPrint (PrintInspect n)) 
# 4816 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Print"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Namespace"))))))
                            ((Procq.Symbol.nterm dirpath)))
                           (fun ns _ _ loc -> 
# 1095 "vernac/g_vernac.mlg"
            VernacSynPure (VernacPrint (PrintNamespace ns)) 
# 4830 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Print"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Module"))))))
                            ((Procq.Symbol.nterm global)))
                           (fun qid _ _ loc -> 
# 1093 "vernac/g_vernac.mlg"
            VernacSynPure (VernacPrint (PrintModule qid)) 
# 4844 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Print"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Module"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                            ((Procq.Symbol.nterm global)))
                           (fun qid _ _ _ loc -> 
# 1091 "vernac/g_vernac.mlg"
            VernacSynPure (VernacPrint (PrintModuleType qid)) 
# 4860 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Print"))))))
                             ((Procq.Symbol.nterm smart_global)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm univ_name_list))))
                           (fun l qid _ loc -> 
# 1089 "vernac/g_vernac.mlg"
                                                                       VernacSynPure (VernacPrint (PrintName (qid,l))) 
# 4873 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Print"))))))
                            ((Procq.Symbol.nterm printable)))
                           (fun p _ loc -> 
# 1088 "vernac/g_vernac.mlg"
                                          VernacSynPure (VernacPrint p) 
# 4884 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("Type")))))
                            ((Procq.Symbol.nterm lconstr)))
                           (fun c _ loc -> 
# 1085 "vernac/g_vernac.mlg"
                                 VernacSynPure (VernacGlobalCheck c) 
# 4894 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Locate"))))))
                            ((Procq.Symbol.nterm locatable)))
                           (fun l _ loc -> 
# 1082 "vernac/g_vernac.mlg"
                                           VernacSynPure (VernacLocate l) 
# 4905 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Declare"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("ML"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Module"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm ne_string)))))
                           (fun l _ _ _ loc -> 
# 1080 "vernac/g_vernac.mlg"
            VernacSynterp (VernacDeclareMLModule l) 
# 4922 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Load"))))))
                             ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                                    (fun
                                                                    loc -> 
                                                                    
# 1076 "vernac/g_vernac.mlg"
                                                                       false 
# 4936 "vernac/g_vernac.ml"
);
                                                  Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("Verbose"))))))
                                                                   (fun _
                                                                   loc -> 
                                                                   
# 1076 "vernac/g_vernac.mlg"
                                                         true 
# 4947 "vernac/g_vernac.ml"
)])))
                            ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                                                   (fun s
                                                                   loc -> 
                                                                   
# 1077 "vernac/g_vernac.mlg"
                                                      s 
# 4957 "vernac/g_vernac.ml"
);
                                                 Procq.Rules.make (Procq.Rule.next_norec
                                                                   (Procq.Rule.stop)
                                                                   ((Procq.Symbol.nterm ne_string)))
                                                                  (fun s
                                                                  loc -> 
                                                                  
# 1077 "vernac/g_vernac.mlg"
                                 s 
# 4967 "vernac/g_vernac.ml"
)])))
                           (fun s verbosely _ loc -> 
# 1078 "vernac/g_vernac.mlg"
            VernacSynterp (VernacLoad (verbosely, s)) 
# 4972 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Cd"))))))
                            ((Procq.Symbol.nterm ne_string)))
                           (fun dir _ loc -> 
# 1074 "vernac/g_vernac.mlg"
                                         VernacSynterp (VernacChdir (Some dir)) 
# 4983 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some ("Cd"))))))
                           (fun _ loc -> 
# 1073 "vernac/g_vernac.mlg"
                        warn_chdir_pwd (); VernacSynterp (VernacChdir None) 
# 4991 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Pwd"))))))
                           (fun _ loc -> 
# 1072 "vernac/g_vernac.mlg"
                         VernacSynterp (VernacChdir None) 
# 5000 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Declare"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun sc _ _ loc -> 
# 1069 "vernac/g_vernac.mlg"
            VernacSynPure (VernacDeclareScope sc) 
# 5014 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.token (Tok.PIDENT (Some
                                  ("Declare"))))))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Instance"))))))
                                ((Procq.Symbol.nterm ident_decl)))
                               ((Procq.Symbol.nterm binders)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterml term ("200"))))
                            ((Procq.Symbol.nterm hint_info)))
                           (fun info t _ bl id _ _ loc -> 
# 1065 "vernac/g_vernac.mlg"
             VernacSynPure (VernacDeclareInstance (id, bl, t, info)) 
# 5036 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Attributes"))))))
                            ((Procq.Symbol.nterm attribute_list)))
                           (fun attr _ loc -> 
# 1059 "vernac/g_vernac.mlg"
          VernacSynPure (VernacAttributes attr) 
# 5047 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Comments"))))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm comment))))
                           (fun l _ loc -> 
# 1056 "vernac/g_vernac.mlg"
                                                 VernacSynPure (VernacComments l) 
# 5058 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty query_command) in
  let () =
  Procq.grammar_extend query_command
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Search"))))))
                               ((Procq.Symbol.nterm search_query)))
                              ((Procq.Symbol.nterm search_queries)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                            (fun _ l s _ loc -> 
# 1141 "vernac/g_vernac.mlg"
            let (sl,m) = l in fun g -> VernacSearch (Search (s::sl),g, m) 
# 5078 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("SearchRewrite"))))))
                              ((Procq.Symbol.nterm constr_pattern)))
                             ((Procq.Symbol.nterm in_or_out_modules)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ l c _ loc -> 
# 1139 "vernac/g_vernac.mlg"
            fun g -> VernacSearch (SearchRewrite c,g, l) 
# 5093 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("SearchPattern"))))))
                              ((Procq.Symbol.nterm constr_pattern)))
                             ((Procq.Symbol.nterm in_or_out_modules)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ l c _ loc -> 
# 1137 "vernac/g_vernac.mlg"
            fun g -> VernacSearch (SearchPattern c,g, l) 
# 5108 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("About"))))))
                              ((Procq.Symbol.nterm smart_global)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm univ_name_list))))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ l qid _ loc -> 
# 1135 "vernac/g_vernac.mlg"
           fun g -> VernacPrint (PrintAbout (qid,l,g)) 
# 5123 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Check"))))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ c _ loc -> 
# 1132 "vernac/g_vernac.mlg"
           fun g -> VernacCheckMayEval (None, g, c) 
# 5136 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Compute"))))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ c _ loc -> 
# 1130 "vernac/g_vernac.mlg"
            fun g -> VernacCheckMayEval (Some (Genredexpr.CbvVm None), g, c) 
# 5149 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Eval"))))))
                               ((Procq.Symbol.nterm red_expr)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.nterm lconstr)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (".")))))
                           (fun _ c _ r _ loc -> 
# 1128 "vernac/g_vernac.mlg"
            fun g -> VernacCheckMayEval (Some r, g, c) 
# 5166 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty printable) in
  let () =
  Procq.grammar_extend printable
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Registered"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Schemes"))))))
                            (fun _ _ loc -> 
# 1202 "vernac/g_vernac.mlg"
                                                 PrintRegisteredSchemes 
# 5183 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Registered"))))))
                           (fun _ loc -> 
# 1201 "vernac/g_vernac.mlg"
                                PrintRegistered 
# 5192 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Strategies"))))))
                           (fun _ loc -> 
# 1200 "vernac/g_vernac.mlg"
                                PrintStrategy None 
# 5201 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Strategy"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1199 "vernac/g_vernac.mlg"
                                                  PrintStrategy (Some qid) 
# 5212 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("All"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Dependencies"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ _ loc -> 
# 1198 "vernac/g_vernac.mlg"
                                                                   PrintAssumptions (true, true, qid) 
# 5226 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Transparent"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Dependencies"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ _ loc -> 
# 1197 "vernac/g_vernac.mlg"
                                                                           PrintAssumptions (false, true, qid) 
# 5240 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Opaque"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Dependencies"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ _ loc -> 
# 1196 "vernac/g_vernac.mlg"
                                                                      PrintAssumptions (true, false, qid) 
# 5254 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Assumptions"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1195 "vernac/g_vernac.mlg"
                                                     PrintAssumptions (false, false, qid) 
# 5265 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Sorts"))))))
                           (fun _ loc -> 
# 1194 "vernac/g_vernac.mlg"
                           PrintSorts 
# 5274 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.rules [Procq.Rules.make 
                                                     (Procq.Rule.stop) (fun
                                                     loc -> 
# 1187 "vernac/g_vernac.mlg"
                                                false 
# 5287 "vernac/g_vernac.ml"
);
                                                     Procq.Rules.make 
                                                     (Procq.Rule.next_norec
                                                      (Procq.Rule.stop)
                                                      ((Procq.Symbol.token (Tok.PIDENT (Some
                                                      ("Sorted"))))))
                                                     (fun _ loc -> 
# 1187 "vernac/g_vernac.mlg"
                                  true 
# 5297 "vernac/g_vernac.ml"
)])))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Universes"))))))
                              ((Procq.Symbol.opt (Procq.Symbol.nterm printunivs_subgraph))))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.rules 
                                                                    [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("Without"))))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 1190 "vernac/g_vernac.mlg"
                                                                false 
# 5322 "vernac/g_vernac.ml"
);
                                                                    Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("With"))))))
                                                                    (fun _
                                                                    loc -> 
                                                                    
# 1190 "vernac/g_vernac.mlg"
                                  true 
# 5335 "vernac/g_vernac.ml"
)])))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("Constraint"))))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("Sources"))))))
                                                                    (fun _ _
                                                                    b loc ->
                                                                    
# 1191 "vernac/g_vernac.mlg"
                                                   b 
# 5346 "vernac/g_vernac.ml"
)]))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm ne_string))))
                           (fun fopt with_sources g _ b loc -> 
# 1193 "vernac/g_vernac.mlg"
          PrintUniverses {sort=b; subgraph=g; with_sources; file=fopt;} 
# 5352 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Implicit"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1186 "vernac/g_vernac.mlg"
                                                  PrintImplicit qid 
# 5363 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Visibility"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.token (Tok.PIDENT (None))))))
                           (fun s _ loc -> 
# 1185 "vernac/g_vernac.mlg"
                                               PrintVisibility s 
# 5374 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun s _ loc -> 
# 1184 "vernac/g_vernac.mlg"
                                      PrintScope s 
# 5385 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Scopes"))))))
                           (fun _ loc -> 
# 1183 "vernac/g_vernac.mlg"
                            PrintScopes 
# 5394 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("HintDb"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun s _ loc -> 
# 1182 "vernac/g_vernac.mlg"
                                       PrintHintDbName s 
# 5405 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Hint"))))))
                            ((Procq.Symbol.token (Tok.PKEYWORD ("*")))))
                           (fun _ _ loc -> 
# 1181 "vernac/g_vernac.mlg"
                               PrintHintDb 
# 5416 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Hint"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1180 "vernac/g_vernac.mlg"
                                              PrintHint qid 
# 5427 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Hint"))))))
                           (fun _ loc -> 
# 1179 "vernac/g_vernac.mlg"
                          PrintHintGoal 
# 5436 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Options"))))))
                           (fun _ loc -> 
# 1178 "vernac/g_vernac.mlg"
                             PrintTables (* A Synonymous to Tables *) 
# 5445 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Tables"))))))
                           (fun _ loc -> 
# 1177 "vernac/g_vernac.mlg"
                            PrintTables 
# 5454 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Typing"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Flags"))))))
                           (fun _ _ loc -> 
# 1176 "vernac/g_vernac.mlg"
                                           PrintTypingFlags 
# 5466 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Canonical"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Projections"))))))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm smart_global))))
                           (fun qids _ _ loc -> 
# 1175 "vernac/g_vernac.mlg"
            PrintCanonicalConversions qids 
# 5480 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Coercion"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Paths"))))))
                             ((Procq.Symbol.nterm coercion_class)))
                            ((Procq.Symbol.nterm coercion_class)))
                           (fun t s _ _ loc -> 
# 1173 "vernac/g_vernac.mlg"
            PrintCoercionPaths (s,t) 
# 5496 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Coercions"))))))
                           (fun _ loc -> 
# 1171 "vernac/g_vernac.mlg"
                               PrintCoercions 
# 5505 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Instances"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1170 "vernac/g_vernac.mlg"
                                                   PrintInstances qid 
# 5516 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Typeclasses"))))))
                           (fun _ loc -> 
# 1169 "vernac/g_vernac.mlg"
                                 PrintTypeclasses 
# 5525 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Classes"))))))
                           (fun _ loc -> 
# 1168 "vernac/g_vernac.mlg"
                              PrintClasses 
# 5534 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Graph"))))))
                           (fun _ loc -> 
# 1167 "vernac/g_vernac.mlg"
                           PrintGraph 
# 5543 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Debug"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some ("GC"))))))
                           (fun _ _ loc -> 
# 1166 "vernac/g_vernac.mlg"
                                       PrintDebugGC 
# 5554 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("ML"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Modules"))))))
                           (fun _ _ loc -> 
# 1165 "vernac/g_vernac.mlg"
                                         PrintMLModules 
# 5566 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("ML"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Path"))))))
                           (fun _ _ loc -> 
# 1164 "vernac/g_vernac.mlg"
                                      PrintMLLoadPath 
# 5578 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Notation"))))))
                               ((Procq.Symbol.nterm string)))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("in"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("custom"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun ent _ _ ntn _ loc -> 
# 1162 "vernac/g_vernac.mlg"
          PrintNotation (Constrexpr.InCustomEntry ent, ntn) 
# 5597 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Notation"))))))
                            ((Procq.Symbol.nterm string)))
                           (fun ntn _ loc -> 
# 1160 "vernac/g_vernac.mlg"
          PrintNotation (Constrexpr.InConstrEntry, ntn) 
# 5608 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Libraries"))))))
                           (fun _ loc -> 
# 1157 "vernac/g_vernac.mlg"
                               PrintLibraries 
# 5617 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("LoadPath"))))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm dirpath))))
                           (fun dir _ loc -> 
# 1156 "vernac/g_vernac.mlg"
                                                 PrintLoadPath dir 
# 5628 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Keywords"))))))
                           (fun _ loc -> 
# 1155 "vernac/g_vernac.mlg"
            PrintKeywords 
# 5637 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Custom"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Grammar"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun ent _ _ loc -> 
# 1153 "vernac/g_vernac.mlg"
            PrintCustomGrammar ent 
# 5651 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Grammar"))))))
                            ((Procq.Symbol.list0 (Procq.Symbol.token (Tok.PIDENT (None))))))
                           (fun ents _ loc -> 
# 1150 "vernac/g_vernac.mlg"
            PrintGrammar ents 
# 5662 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Section"))))))
                            ((Procq.Symbol.nterm global)))
                           (fun s _ loc -> 
# 1147 "vernac/g_vernac.mlg"
                                         PrintSectionContext s 
# 5673 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("All"))))))
                           (fun _ loc -> 
# 1146 "vernac/g_vernac.mlg"
                         PrintFullContext 
# 5682 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Term"))))))
                             ((Procq.Symbol.nterm smart_global)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm univ_name_list))))
                           (fun l qid _ loc -> 
# 1145 "vernac/g_vernac.mlg"
                                                                      PrintName (qid,l) 
# 5695 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty debug_univ_name) in
  let () =
  Procq.grammar_extend debug_univ_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PSTRING (None)))))
                            (fun x loc -> 
# 1207 "vernac/g_vernac.mlg"
                        RawUniv (CAst.make ~loc x) 
# 5708 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm reference)))
                           (fun x loc -> 
# 1206 "vernac/g_vernac.mlg"
                           NamedUniv x 
# 5716 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty printunivs_subgraph) in
  let () =
  Procq.grammar_extend printunivs_subgraph
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Subgraph"))))))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm debug_univ_name))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                            (fun _ l _ _ loc -> 
# 1211 "vernac/g_vernac.mlg"
                                                                   l 
# 5736 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty coercion_class) in
  let () =
  Procq.grammar_extend coercion_class
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm smart_global)))
                            (fun qid loc -> 
# 1216 "vernac/g_vernac.mlg"
                                RefClass qid 
# 5749 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Sortclass"))))))
                           (fun _ loc -> 
# 1215 "vernac/g_vernac.mlg"
                               SortClass 
# 5758 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Funclass"))))))
                           (fun _ loc -> 
# 1214 "vernac/g_vernac.mlg"
                              FunClass 
# 5767 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty locatable) in
  let () =
  Procq.grammar_extend locatable
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Module"))))))
                             ((Procq.Symbol.nterm global)))
                            (fun qid _ loc -> 
# 1223 "vernac/g_vernac.mlg"
                                          LocateModule qid 
# 5783 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Library"))))))
                            ((Procq.Symbol.nterm global)))
                           (fun qid _ loc -> 
# 1222 "vernac/g_vernac.mlg"
                                           LocateLibrary qid 
# 5794 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("File"))))))
                            ((Procq.Symbol.nterm ne_string)))
                           (fun f _ loc -> 
# 1221 "vernac/g_vernac.mlg"
                                         LocateFile f 
# 5805 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Term"))))))
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid _ loc -> 
# 1220 "vernac/g_vernac.mlg"
                                              LocateTerm qid 
# 5816 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm smart_global)))
                           (fun qid loc -> 
# 1219 "vernac/g_vernac.mlg"
                                LocateAny qid 
# 5824 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty option_setting) in
  let () =
  Procq.grammar_extend option_setting
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PSTRING (None)))))
                            (fun s loc -> 
# 1228 "vernac/g_vernac.mlg"
                            OptionSetString s 
# 5837 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm integer)))
                           (fun n loc -> 
# 1227 "vernac/g_vernac.mlg"
                            OptionSetInt n 
# 5845 "vernac/g_vernac.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 1226 "vernac/g_vernac.mlg"
             OptionSetTrue 
# 5851 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty table_value) in
  let () =
  Procq.grammar_extend table_value
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PSTRING (None)))))
                            (fun s loc -> 
# 1232 "vernac/g_vernac.mlg"
                           Goptions.StringRefValue s 
# 5864 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm global)))
                           (fun id loc -> 
# 1231 "vernac/g_vernac.mlg"
                           Goptions.QualidRefValue id 
# 5872 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty setting_name) in
  let () =
  Procq.grammar_extend setting_name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.stop)
                                                ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                               (fun x loc -> 
# 1235 "vernac/g_vernac.mlg"
                                    x 
# 5888 "vernac/g_vernac.ml"
)])))))
                            (fun fl loc -> 
# 1235 "vernac/g_vernac.mlg"
                                               fl 
# 5893 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ne_in_or_out_modules) in
  let () =
  Procq.grammar_extend ne_in_or_out_modules
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("outside"))))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                            (fun l _ loc -> 
# 1240 "vernac/g_vernac.mlg"
                                               SearchOutside l 
# 5909 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun l _ loc -> 
# 1239 "vernac/g_vernac.mlg"
                                    SearchInside l 
# 5919 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("inside"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun l _ loc -> 
# 1238 "vernac/g_vernac.mlg"
                                              SearchInside l 
# 5930 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty in_or_out_modules) in
  let () =
  Procq.grammar_extend in_or_out_modules
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1244 "vernac/g_vernac.mlg"
             SearchOutside [] 
# 5941 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ne_in_or_out_modules)))
                           (fun m loc -> 
# 1243 "vernac/g_vernac.mlg"
                                      m 
# 5949 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty comment) in
  let () =
  Procq.grammar_extend comment
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm natural)))
                            (fun n loc -> 
# 1249 "vernac/g_vernac.mlg"
                         CommentInt n 
# 5962 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PSTRING (None)))))
                           (fun s loc -> 
# 1248 "vernac/g_vernac.mlg"
                        CommentString s 
# 5970 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm constr)))
                           (fun c loc -> 
# 1247 "vernac/g_vernac.mlg"
                        CommentConstr c 
# 5978 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty positive_search_mark) in
  let () =
  Procq.grammar_extend positive_search_mark
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1252 "vernac/g_vernac.mlg"
                                true 
# 5989 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                           (fun _ loc -> 
# 1252 "vernac/g_vernac.mlg"
                 false 
# 5997 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty search_query) in
  let () =
  Procq.grammar_extend search_query
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm positive_search_mark)))
                               ((Procq.Symbol.token (Tok.PKEYWORD ("[")))))
                              ((Procq.Symbol.list1sep ((Procq.Symbol.list1 ((Procq.Symbol.nterm search_query)))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("]")))))
                            (fun _ l _ b loc -> 
# 1256 "vernac/g_vernac.mlg"
                                                                                        (b, SearchDisjConj l) 
# 6016 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm positive_search_mark)))
                            ((Procq.Symbol.nterm search_item)))
                           (fun s b loc -> 
# 1255 "vernac/g_vernac.mlg"
                                                       (b, SearchLiteral s) 
# 6026 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty search_item) in
  let () =
  Procq.grammar_extend search_item
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr_pattern)))
                            (fun p loc -> 
# 1269 "vernac/g_vernac.mlg"
              SearchSubPattern ((Anywhere,false),p) 
# 6039 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_id_colon)))
                              ((Procq.Symbol.nterm search_where)))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm constr_pattern)))
                           (fun p _ where _ loc -> 
# 1267 "vernac/g_vernac.mlg"
              SearchSubPattern (where,p) 
# 6053 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ne_string)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm scope_delimiter))))
                           (fun sc s loc -> 
# 1265 "vernac/g_vernac.mlg"
              SearchString ((Anywhere,false),s,sc) 
# 6063 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("is"))))))
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.nterm logical_kind)))
                           (fun kl _ _ loc -> 
# 1263 "vernac/g_vernac.mlg"
              SearchKind kl 
# 6076 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.nterm test_id_colon)))
                               ((Procq.Symbol.nterm search_where)))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.nterm ne_string)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm scope_delimiter))))
                           (fun sc s _ where _ loc -> 
# 1261 "vernac/g_vernac.mlg"
              SearchString (where,s,sc) 
# 6092 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty logical_kind) in
  let () =
  Procq.grammar_extend logical_kind
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Symbol"))))))
                            (fun _ loc -> 
# 1278 "vernac/g_vernac.mlg"
                            IsSymbol 
# 6106 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Primitive"))))))
                           (fun _ loc -> 
# 1277 "vernac/g_vernac.mlg"
                               IsPrimitive 
# 6115 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm extended_def_token)))
                           (fun k loc -> 
# 1276 "vernac/g_vernac.mlg"
                                    IsDefinition k 
# 6123 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Context"))))))
                           (fun k loc -> 
# 1275 "vernac/g_vernac.mlg"
                                 IsAssumption Context 
# 6132 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm assumption_token)))
                           (fun k loc -> 
# 1274 "vernac/g_vernac.mlg"
                                  IsAssumption (snd k) 
# 6140 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm thm_token)))
                           (fun k loc -> 
# 1273 "vernac/g_vernac.mlg"
                           IsProof k 
# 6148 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty extended_def_token) in
  let () =
  Procq.grammar_extend extended_def_token
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Method"))))))
                            (fun _ loc -> 
# 1289 "vernac/g_vernac.mlg"
                            Method 
# 6162 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Field"))))))
                           (fun _ loc -> 
# 1288 "vernac/g_vernac.mlg"
                           StructureComponent 
# 6171 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Canonical"))))))
                           (fun _ loc -> 
# 1287 "vernac/g_vernac.mlg"
                               CanonicalStructure 
# 6180 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Scheme"))))))
                           (fun _ loc -> 
# 1286 "vernac/g_vernac.mlg"
                            Scheme 
# 6189 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Instance"))))))
                           (fun _ loc -> 
# 1285 "vernac/g_vernac.mlg"
                              Instance 
# 6198 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("CoFixpoint"))))))
                           (fun _ loc -> 
# 1284 "vernac/g_vernac.mlg"
                                CoFixpoint 
# 6207 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Fixpoint"))))))
                           (fun _ loc -> 
# 1283 "vernac/g_vernac.mlg"
                              Fixpoint 
# 6216 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Coercion"))))))
                           (fun _ loc -> 
# 1282 "vernac/g_vernac.mlg"
                              Coercion 
# 6225 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm def_token)))
                           (fun k loc -> 
# 1281 "vernac/g_vernac.mlg"
                           snd k 
# 6233 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty search_where) in
  let () =
  Procq.grammar_extend search_where
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("headconcl"))))))
                            (fun _ loc -> 
# 1296 "vernac/g_vernac.mlg"
                               InConcl, true 
# 6247 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("headhyp"))))))
                           (fun _ loc -> 
# 1295 "vernac/g_vernac.mlg"
                             InHyp, true 
# 6256 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("concl"))))))
                           (fun _ loc -> 
# 1294 "vernac/g_vernac.mlg"
                           InConcl, false 
# 6265 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("hyp"))))))
                           (fun _ loc -> 
# 1293 "vernac/g_vernac.mlg"
                         InHyp, false 
# 6274 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("head"))))))
                           (fun _ loc -> 
# 1292 "vernac/g_vernac.mlg"
                          Anywhere, true 
# 6283 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty search_queries) in
  let () =
  Procq.grammar_extend search_queries
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1302 "vernac/g_vernac.mlg"
             ([],SearchOutside []) 
# 6294 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm search_query)))
                            ((Procq.Symbol.nterm search_queries)))
                           (fun l s loc -> 
# 1301 "vernac/g_vernac.mlg"
          let (sl,m) = l in (s::sl,m) 
# 6304 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ne_in_or_out_modules)))
                           (fun m loc -> 
# 1299 "vernac/g_vernac.mlg"
                                      ([],m) 
# 6312 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty univ_name_list) in
  let () =
  Procq.grammar_extend univ_name_list
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("@{")))))
                              ((Procq.Symbol.list0 (Procq.Symbol.nterm name))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ l _ loc -> 
# 1306 "vernac/g_vernac.mlg"
                                         [],l 
# 6329 "vernac/g_vernac.ml"
)])]))
  in ()

let _ = let () =
  Procq.grammar_extend command
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("Declare"))))))
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Custom"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Entry"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (None)))))
                       (fun s _ _ _ loc -> 
# 1337 "vernac/g_vernac.mlg"
             VernacSynterp (VernacDeclareCustomEntry s) 
# 6349 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("Declare"))))))
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Reduction"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (None)))))
                        ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                       ((Procq.Symbol.nterm red_expr)))
                      (fun r _ s _ _ loc -> 
# 1332 "vernac/g_vernac.mlg"
             VernacSynPure (VernacDeclareReduction (s,r)) 
# 6367 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Debug"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Off"))))))
                      (fun _ _ loc -> 
# 1326 "vernac/g_vernac.mlg"
            VernacSynterp (VernacSetOption (false, ["Ltac";"Debug"], OptionUnset)) 
# 6377 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Debug"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("On"))))))
                      (fun _ _ loc -> 
# 1323 "vernac/g_vernac.mlg"
            VernacSynterp (VernacSetOption (false, ["Ltac";"Debug"], OptionSetTrue)) 
# 6387 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Back"))))))
                       ((Procq.Symbol.nterm natural)))
                      (fun n _ loc -> 
# 1319 "vernac/g_vernac.mlg"
                                       VernacSynPure (VernacBack n) 
# 6397 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Back"))))))
                      (fun _ loc -> 
# 1318 "vernac/g_vernac.mlg"
                          VernacSynPure (VernacBack 1) 
# 6405 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Reset"))))))
                       ((Procq.Symbol.nterm identref)))
                      (fun id _ loc -> 
# 1317 "vernac/g_vernac.mlg"
                                          VernacSynPure (VernacResetName id) 
# 6415 "vernac/g_vernac.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Reset"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Initial"))))))
                      (fun _ _ loc -> 
# 1316 "vernac/g_vernac.mlg"
                                            VernacSynPure (VernacResetInitial) 
# 6425 "vernac/g_vernac.ml"
)]))
  in ()

let _ =
  let enable_enable_disable = Procq.Entry.make "enable_enable_disable"
  and enable_notation_rule = Procq.Entry.make "enable_notation_rule"
  and enable_notation_interpretation =
    Procq.Entry.make "enable_notation_interpretation"
  and enable_notation_flags = Procq.Entry.make "enable_notation_flags"
  and enable_notation_flag = Procq.Entry.make "enable_notation_flag"
  and opt_scope = Procq.Entry.make "opt_scope"
  and level = Procq.Entry.make "level"
  and syntax_modifier = Procq.Entry.make "syntax_modifier"
  and explicit_subentry = Procq.Entry.make "explicit_subentry"
  and at_level_opt = Procq.Entry.make "at_level_opt"
  and binder_interp = Procq.Entry.make "binder_interp"
  in
  let () = assert (Procq.Entry.is_empty syntax) in
  let () =
  Procq.grammar_extend syntax
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next
                                 (Procq.Rule.next (Procq.Rule.stop)
                                  ((Procq.Symbol.nterm enable_enable_disable)))
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Notation"))))))
                                ((Procq.Symbol.nterm enable_notation_rule)))
                               ((Procq.Symbol.nterm enable_notation_interpretation)))
                              ((Procq.Symbol.nterm enable_notation_flags)))
                             ((Procq.Symbol.nterm opt_scope)))
                            (fun scope flags interp rule _ on loc -> 
# 1378 "vernac/g_vernac.mlg"
             VernacSynPure (VernacEnableNotation (on, rule, interp, flags, scope)) 
# 6465 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Reserved"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Notation"))))))
                             ((Procq.Symbol.nterm ne_lstring)))
                            ((Procq.Symbol.nterm syntax_modifiers)))
                           (fun l s _ _ loc -> 
# 1373 "vernac/g_vernac.mlg"
             VernacSynterp (VernacReservedNotation (false,(s,l))) 
# 6481 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Reserved"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Infix"))))))
                             ((Procq.Symbol.nterm ne_lstring)))
                            ((Procq.Symbol.nterm syntax_modifiers)))
                           (fun l s _ _ loc -> 
# 1371 "vernac/g_vernac.mlg"
             VernacSynterp (VernacReservedNotation (true,(s,l))) 
# 6497 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Notation"))))))
                            ((Procq.Symbol.nterm notation_declaration)))
                           (fun ntn_decl _ loc -> 
# 1368 "vernac/g_vernac.mlg"
             VernacSynterp (VernacNotation (false,ntn_decl)) 
# 6508 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Notation"))))))
                                ((Procq.Symbol.nterm identref)))
                               ((Procq.Symbol.list0 (Procq.Symbol.nterm ident))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                             ((Procq.Symbol.nterm constr)))
                            ((Procq.Symbol.nterm syntax_modifiers)))
                           (fun modl c _ idl id _ loc -> 
# 1366 "vernac/g_vernac.mlg"
             VernacSynPure (VernacSyntacticDefinition (id,(idl,c), modl)) 
# 6527 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Infix"))))))
                            ((Procq.Symbol.nterm notation_declaration)))
                           (fun ntn_decl _ loc -> 
# 1363 "vernac/g_vernac.mlg"
           VernacSynterp (VernacNotation (true,ntn_decl)) 
# 6538 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Bind"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Scope"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm coercion_class)))))
                           (fun refl _ sc _ _ loc -> 
# 1360 "vernac/g_vernac.mlg"
                                        VernacSynPure (VernacBindScope (sc,refl)) 
# 6556 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Undelimit"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun sc _ _ loc -> 
# 1357 "vernac/g_vernac.mlg"
           VernacSynPure(VernacDelimiters (sc, None)) 
# 6570 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("Delimit"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Scope"))))))
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun key _ sc _ _ loc -> 
# 1355 "vernac/g_vernac.mlg"
           VernacSynPure(VernacDelimiters (sc, Some key)) 
# 6588 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Close"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun sc _ _ loc -> 
# 1352 "vernac/g_vernac.mlg"
           VernacSynPure (VernacOpenCloseScope (false,sc)) 
# 6602 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Open"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun sc _ _ loc -> 
# 1349 "vernac/g_vernac.mlg"
           VernacSynPure (VernacOpenCloseScope (true,sc)) 
# 6616 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty enable_enable_disable) in
  let () =
  Procq.grammar_extend enable_enable_disable
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Disable"))))))
                            (fun _ loc -> 
# 1386 "vernac/g_vernac.mlg"
                             false 
# 6630 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Enable"))))))
                           (fun _ loc -> 
# 1385 "vernac/g_vernac.mlg"
                            true 
# 6639 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty enable_notation_rule) in
  let () =
  Procq.grammar_extend enable_notation_rule
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1391 "vernac/g_vernac.mlg"
             None 
# 6650 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm global)))
                            ((Procq.Symbol.list0 (Procq.Symbol.nterm ident))))
                           (fun idl qid loc -> 
# 1390 "vernac/g_vernac.mlg"
                                             Some (Inr (idl,qid)) 
# 6660 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm ne_string)))
                           (fun s loc -> 
# 1389 "vernac/g_vernac.mlg"
                           Some (Inl s) 
# 6668 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty enable_notation_interpretation)
  in
  let () =
  Procq.grammar_extend enable_notation_interpretation
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1395 "vernac/g_vernac.mlg"
             None 
# 6680 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":=")))))
                            ((Procq.Symbol.nterm constr)))
                           (fun c _ loc -> 
# 1394 "vernac/g_vernac.mlg"
                              Some c 
# 6690 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty enable_notation_flags) in
  let () =
  Procq.grammar_extend enable_notation_flags
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1399 "vernac/g_vernac.mlg"
             [] 
# 6701 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.nterm enable_notation_flag)) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ l _ loc -> 
# 1398 "vernac/g_vernac.mlg"
                                                              l 
# 6713 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty enable_notation_flag) in
  let () =
  Procq.grammar_extend enable_notation_flag
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("constr"))))))
                            (fun _ _ loc -> 
# 1406 "vernac/g_vernac.mlg"
                                  EnableNotationEntry (CAst.make ~loc InConstrEntry) 
# 6729 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("custom"))))))
                            ((Procq.Symbol.nterm identref)))
                           (fun x _ _ loc -> 
# 1405 "vernac/g_vernac.mlg"
                                                EnableNotationEntry CAst.(make ?loc:x.loc (InCustomEntry (Id.to_string x.v))) 
# 6742 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("only"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("printing"))))))
                           (fun _ _ loc -> 
# 1404 "vernac/g_vernac.mlg"
                                            EnableNotationOnly Notationextern.OnlyPrinting 
# 6754 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("only"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("parsing"))))))
                           (fun _ _ loc -> 
# 1403 "vernac/g_vernac.mlg"
                                           EnableNotationOnly Notationextern.OnlyParsing 
# 6766 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("all"))))))
                           (fun _ loc -> 
# 1402 "vernac/g_vernac.mlg"
                         EnableNotationAll 
# 6775 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty opt_scope) in
  let () =
  Procq.grammar_extend opt_scope
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1411 "vernac/g_vernac.mlg"
             None 
# 6786 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("no"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("scope"))))))
                           (fun _ _ _ loc -> 
# 1410 "vernac/g_vernac.mlg"
                                            Some LastLonelyNotation 
# 6800 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun sc _ loc -> 
# 1409 "vernac/g_vernac.mlg"
                             Some (NotationInScope sc) 
# 6810 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty level) in
  let () =
  Procq.grammar_extend level
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("next"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            (fun _ _ loc -> 
# 1415 "vernac/g_vernac.mlg"
                                         NextLevel 
# 6827 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ loc -> 
# 1414 "vernac/g_vernac.mlg"
                                        NumLevel n 
# 6838 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty syntax_modifier) in
  let () =
  Procq.grammar_extend syntax_modifier
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (None)))))
                             ((Procq.Symbol.nterm explicit_subentry)))
                            (fun typ x loc -> 
# 1435 "vernac/g_vernac.mlg"
                                                SetEntryType (x,typ) 
# 6853 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            ((Procq.Symbol.nterm binder_interp)))
                           (fun b x loc -> 
# 1434 "vernac/g_vernac.mlg"
                                          SetItemLevel ([x],Some b,DefaultLevel) 
# 6863 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (None)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("scope"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun k _ _ x loc -> 
# 1433 "vernac/g_vernac.mlg"
                                                       SetItemScope([x],k) 
# 6878 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (None)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.nterm level)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm binder_interp))))
                           (fun b lev _ x loc -> 
# 1432 "vernac/g_vernac.mlg"
          SetItemLevel ([x],b,lev) 
# 6892 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (None)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD (",")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.token (Tok.PIDENT (None)))) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                    ("scope"))))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                                                   (fun k _ _
                                                                   loc -> 
                                                                   
# 1430 "vernac/g_vernac.mlg"
                                                fun x l -> SetItemScope(x::l,k) 
# 6917 "vernac/g_vernac.ml"
);
                                                 Procq.Rules.make (Procq.Rule.next_norec
                                                                   (Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                                                                   ((Procq.Symbol.nterm level)))
                                                                  (fun lev _
                                                                  loc -> 
                                                                  
# 1429 "vernac/g_vernac.mlg"
                                   fun x l -> SetItemLevel (x::l,None,lev) 
# 6929 "vernac/g_vernac.ml"
)])))
                           (fun v l _ x loc -> 
# 1430 "vernac/g_vernac.mlg"
                                                                                         v x l 
# 6934 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("format"))))))
                            ((Procq.Symbol.nterm lstring)))
                           (fun s _ loc -> 
# 1427 "vernac/g_vernac.mlg"
                                         SetFormat (TextFormat s) 
# 6945 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("only"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("parsing"))))))
                           (fun _ _ loc -> 
# 1426 "vernac/g_vernac.mlg"
                                           SetOnlyParsing 
# 6957 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("only"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("printing"))))))
                           (fun _ _ loc -> 
# 1425 "vernac/g_vernac.mlg"
                                            SetOnlyPrinting 
# 6969 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("no"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("associativity"))))))
                           (fun _ _ loc -> 
# 1424 "vernac/g_vernac.mlg"
                                               SetAssoc Gramlib.Gramext.NonA 
# 6981 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("right"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("associativity"))))))
                           (fun _ _ loc -> 
# 1423 "vernac/g_vernac.mlg"
                                                  SetAssoc Gramlib.Gramext.RightA 
# 6993 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("left"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("associativity"))))))
                           (fun _ _ loc -> 
# 1422 "vernac/g_vernac.mlg"
                                                 SetAssoc Gramlib.Gramext.LeftA 
# 7005 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("custom"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (None)))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ _ x _ _ loc -> 
# 1421 "vernac/g_vernac.mlg"
           SetCustomEntry (x,Some n) 
# 7025 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("in")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("custom"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (None)))))
                           (fun x _ _ loc -> 
# 1419 "vernac/g_vernac.mlg"
                                             SetCustomEntry (x,None) 
# 7038 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ _ loc -> 
# 1418 "vernac/g_vernac.mlg"
                                              SetLevel n 
# 7051 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty syntax_modifiers) in
  let () =
  Procq.grammar_extend syntax_modifiers
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1440 "vernac/g_vernac.mlg"
             [] 
# 7062 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD ("(")))))
                             ((Procq.Symbol.list1sep ((Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.stop)
                                                ((Procq.Symbol.nterm syntax_modifier)))
                                               (fun s loc -> 
# 1439 "vernac/g_vernac.mlg"
                                                  CAst.make ~loc s 
# 7076 "vernac/g_vernac.ml"
)])) ((Procq.Symbol.tokens [Procq.TPattern (Tok.PKEYWORD (","))])) false)))
                            ((Procq.Symbol.token (Tok.PKEYWORD (")")))))
                           (fun _ l _ loc -> 
# 1439 "vernac/g_vernac.mlg"
                                                                                         l 
# 7082 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty explicit_subentry) in
  let () =
  Procq.grammar_extend explicit_subentry
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("custom"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (None)))))
                              ((Procq.Symbol.nterm at_level_opt)))
                             ((Procq.Symbol.opt (Procq.Symbol.nterm binder_interp))))
                            (fun b n x _ loc -> 
# 1457 "vernac/g_vernac.mlg"
             ETConstr (InCustomEntry x,b,n) 
# 7102 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("closed"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("binder"))))))
                           (fun _ _ loc -> 
# 1455 "vernac/g_vernac.mlg"
                                            ETBinder false 
# 7114 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next (Procq.Rule.stop)
                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                ("strict"))))))
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("pattern"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ _ _ _ loc -> 
# 1454 "vernac/g_vernac.mlg"
                                                                               ETPattern (true,Some n) 
# 7133 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("strict"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("pattern"))))))
                           (fun _ _ loc -> 
# 1453 "vernac/g_vernac.mlg"
                                             ETPattern (true,None) 
# 7145 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("pattern"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("level"))))))
                            ((Procq.Symbol.nterm natural)))
                           (fun n _ _ _ loc -> 
# 1452 "vernac/g_vernac.mlg"
                                                               ETPattern (false,Some n) 
# 7161 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("pattern"))))))
                           (fun _ loc -> 
# 1451 "vernac/g_vernac.mlg"
                             ETPattern (false,None) 
# 7170 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("constr"))))))
                             ((Procq.Symbol.nterm at_level_opt)))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm binder_interp))))
                           (fun b n _ loc -> 
# 1450 "vernac/g_vernac.mlg"
                                                                     ETConstr (InConstrEntry,b,n) 
# 7183 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("constr"))))))
                           (fun _ loc -> 
# 1449 "vernac/g_vernac.mlg"
                            ETConstr (InConstrEntry,None,DefaultLevel) 
# 7192 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("binder"))))))
                           (fun _ loc -> 
# 1448 "vernac/g_vernac.mlg"
                            ETBinder true 
# 7201 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("bigint"))))))
                           (fun _ loc -> 
# 1447 "vernac/g_vernac.mlg"
                            ETBigint 
# 7210 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("global"))))))
                           (fun _ loc -> 
# 1446 "vernac/g_vernac.mlg"
                            ETGlobal 
# 7219 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("name"))))))
                           (fun _ loc -> 
# 1445 "vernac/g_vernac.mlg"
                          ETName 
# 7228 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("ident"))))))
                           (fun _ loc -> 
# 1444 "vernac/g_vernac.mlg"
                           ETIdent 
# 7237 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty at_level_opt) in
  let () =
  Procq.grammar_extend at_level_opt
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make (Procq.Rule.stop)
                            (fun loc -> 
# 1462 "vernac/g_vernac.mlg"
             DefaultLevel 
# 7248 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("at")))))
                            ((Procq.Symbol.nterm level)))
                           (fun n _ loc -> 
# 1461 "vernac/g_vernac.mlg"
                             n 
# 7258 "vernac/g_vernac.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty binder_interp) in
  let () =
  Procq.grammar_extend binder_interp
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("strict"))))))
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("pattern"))))))
                            (fun _ _ _ loc -> 
# 1468 "vernac/g_vernac.mlg"
                                                   Notation_term.AsStrictPattern 
# 7277 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("pattern"))))))
                           (fun _ _ loc -> 
# 1467 "vernac/g_vernac.mlg"
                                   Notation_term.AsAnyPattern 
# 7288 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("name"))))))
                           (fun _ _ loc -> 
# 1466 "vernac/g_vernac.mlg"
                                Notation_term.AsName 
# 7299 "vernac/g_vernac.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PKEYWORD ("as")))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("ident"))))))
                           (fun _ _ loc -> 
# 1465 "vernac/g_vernac.mlg"
                                 warn_deprecated_as_ident_kind (); Notation_term.AsIdent 
# 7310 "vernac/g_vernac.ml"
)])]))
  in ()

