/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.icons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.link.icons.LinkDecorationConfig;
import org.freeplane.features.link.icons.LinkDecorationRule;
import org.freeplane.features.link.icons.LinkMatchResult;

public class NodeViewDecorator {
    private static final String SHOW_LINK_SPECIFIC_ICONS_PROPERTY = "showLinkSpecificIcons";
    private LinkDecorationConfig decorationConfig;
    public static NodeViewDecorator INSTANCE = new NodeViewDecorator(new LinkDecorationConfig());

    private NodeViewDecorator(LinkDecorationConfig decorationConfig) {
        this.setDecorationConfig(decorationConfig);
    }

    public List<String> getIconsForLink(Hyperlink link) {
        if (ResourceController.getResourceController().getBooleanProperty(SHOW_LINK_SPECIFIC_ICONS_PROPERTY)) {
            ArrayList<String> icons = new ArrayList<String>();
            if (link != null) {
                this.addLinkIcon(icons, link.toString());
            }
            return icons;
        }
        return Collections.emptyList();
    }

    private void setDecorationConfig(LinkDecorationConfig decorationConfig) {
        this.decorationConfig = decorationConfig;
    }

    private void addLinkIcon(List<String> icons, String link) {
        List<LinkMatchResult> matchResults = this.findMatchingResults(link);
        LinkMatchResult mostSpecificResult = this.findResultWithHighestScore(matchResults);
        if (mostSpecificResult != null) {
            icons.add(mostSpecificResult.getIconName());
        }
    }

    private LinkMatchResult findResultWithHighestScore(List<LinkMatchResult> matchResults) {
        LinkMatchResult mostSpecificResult = null;
        for (LinkMatchResult result : matchResults) {
            if (mostSpecificResult != null && result.getScore() <= mostSpecificResult.getScore()) continue;
            mostSpecificResult = result;
        }
        return mostSpecificResult;
    }

    private List<LinkMatchResult> findMatchingResults(String link) {
        List<LinkDecorationRule> rules = this.decorationConfig.getRules();
        if (rules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LinkMatchResult> matchResults = new ArrayList<LinkMatchResult>();
        int matchedScore = 0;
        for (LinkDecorationRule rule : rules) {
            if (rule.getMaximalScore() < matchedScore) break;
            LinkMatchResult result = rule.matches(link);
            if (!result.matches()) continue;
            matchResults.add(result);
            matchedScore = result.getScore();
        }
        return matchResults;
    }
}

