function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
export var OuiRadio = function OuiRadio(_ref) {
  var className = _ref.className,
    id = _ref.id,
    name = _ref.name,
    checked = _ref.checked,
    label = _ref.label,
    value = _ref.value,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    autoFocus = _ref.autoFocus,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, ["className", "id", "name", "checked", "label", "value", "onChange", "disabled", "compressed", "autoFocus", "labelProps"]);
  var classes = classNames('ouiRadio', {
    'ouiRadio--noLabel': !label,
    'ouiRadio--compressed': compressed
  }, className);
  var labelClasses = classNames('ouiRadio__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var optionalLabel;
  if (label) {
    optionalLabel = /*#__PURE__*/React.createElement("label", _extends({}, labelProps, {
      className: labelClasses,
      htmlFor: id
    }), label);
  }
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes
  }, rest), /*#__PURE__*/React.createElement("input", {
    className: "ouiRadio__input",
    type: "radio",
    id: id,
    name: name,
    value: value,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    autoFocus: autoFocus
  }), /*#__PURE__*/React.createElement("div", {
    className: "ouiRadio__circle"
  }), optionalLabel);
};

// @internal
OuiRadio.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  autoFocus: PropTypes.bool,
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  compressed: PropTypes.bool,
  name: PropTypes.string,
  value: PropTypes.string,
  checked: PropTypes.bool,
  disabled: PropTypes.bool,
  onChange: PropTypes.any.isRequired,
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  labelProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  label: PropTypes.node,
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.string.isRequired])
};
// @internal
export var OuiCompressedRadio = function OuiCompressedRadio(props) {
  return /*#__PURE__*/React.createElement(OuiRadio, _extends({}, props, {
    compressed: true
  }));
};

/* OUI -> EUI Aliases: Build-Time */
OuiCompressedRadio.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  label: PropTypes.node,
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.string.isRequired]),
  autoFocus: PropTypes.bool,
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  compressed: PropTypes.bool,
  name: PropTypes.string,
  value: PropTypes.string,
  checked: PropTypes.bool,
  disabled: PropTypes.bool,
  onChange: PropTypes.oneOfType([PropTypes.any, PropTypes.any.isRequired]),
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  labelProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  })
};
/* OUI -> EUI Aliases: Build-Time */export { EuiRadio, EuiCompressedRadio } from '../../../eui_components/form/radio/radio';