function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { createElement } from 'react';
// Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during oui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.

import all from 'mdast-util-to-hast/lib/all';
import rehype2react from 'rehype-react';
import markdown from 'remark-parse';
import emoji from 'remark-emoji';
import remark2rehype from 'remark-rehype';
import rehypeSlug from 'rehype-slug';
import highlight from './remark/remark_prismjs';
import * as MarkdownTooltip from './markdown_tooltip';
import * as MarkdownCheckbox from './markdown_checkbox';
import { markdownLinkValidator } from './markdown_link_validator';
import { OuiLink } from '../../link';
import { OuiCodeBlock, OuiCode } from '../../code';
export var getDefaultOuiMarkdownParsingPlugins = function getDefaultOuiMarkdownParsingPlugins() {
  return [[markdown, {}], [highlight, {}], [emoji, {
    emoticon: false
  }], [MarkdownTooltip.parser, {}], [MarkdownCheckbox.parser, {}], [markdownLinkValidator, {}]];
};
export var defaultParsingPlugins = getDefaultOuiMarkdownParsingPlugins();
var unknownHandler = function unknownHandler(h, node) {
  return h(node, node.type, node, all(h, node));
};
export var getDefaultOuiMarkdownProcessingPlugins = function getDefaultOuiMarkdownProcessingPlugins() {
  return [[remark2rehype, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to
  }], [rehypeSlug, {}], [rehype2react, {
    createElement: createElement,
    components: {
      a: OuiLink,
      code: function code(props) {
        return (
          // If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) ? /*#__PURE__*/React.createElement(OuiCodeBlock, _extends({
            fontSize: "m",
            paddingSize: "s"
          }, props)) : /*#__PURE__*/React.createElement(OuiCode, props)
        );
      },
      tooltipPlugin: MarkdownTooltip.renderer,
      checkboxPlugin: MarkdownCheckbox.renderer
    }
  }]];
};
export var defaultProcessingPlugins = getDefaultOuiMarkdownProcessingPlugins();
export var getDefaultOuiMarkdownUiPlugins = function getDefaultOuiMarkdownUiPlugins() {
  var array = [MarkdownTooltip.plugin];
  // @ts-ignore __originatedFromOui is a custom property
  array.__originatedFromOui = true;
  return array;
};
export var defaultUiPlugins = getDefaultOuiMarkdownUiPlugins();

/* OUI -> EUI Aliases: Build-Time */
export { getDefaultEuiMarkdownParsingPlugins, getDefaultEuiMarkdownProcessingPlugins, getDefaultEuiMarkdownUiPlugins } from '../../../eui_components/markdown_editor/plugins/markdown_default_plugins';