/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ParentIdQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, ParentIdQuery> {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final String type;
    public static final JsonpDeserializer<ParentIdQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ParentIdQuery::setupParentIdQueryDeserializer);

    private ParentIdQuery(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.type = builder.type;
    }

    public static ParentIdQuery of(Function<Builder, ObjectBuilder<ParentIdQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.ParentId;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupParentIdQueryDeserializer(ObjectDeserializer<Builder> op) {
        ParentIdQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + Objects.hashCode(this.type);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParentIdQuery other = (ParentIdQuery)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && Objects.equals(this.type, other.type);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ParentIdQuery> {
        @Nullable
        private String id;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(ParentIdQuery o) {
            super(o);
            this.id = o.id;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.type = o.type;
        }

        private Builder(Builder o) {
            super(o);
            this.id = o.id;
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public ParentIdQuery build() {
            this._checkSingleUse();
            return new ParentIdQuery(this);
        }
    }
}

