/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.signer.SignerAsyncClient;
import software.amazon.awssdk.services.signer.internal.UserAgentUtils;
import software.amazon.awssdk.services.signer.model.ListSigningPlatformsRequest;
import software.amazon.awssdk.services.signer.model.ListSigningPlatformsResponse;

public class ListSigningPlatformsPublisher
implements SdkPublisher<ListSigningPlatformsResponse> {
    private final SignerAsyncClient client;
    private final ListSigningPlatformsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSigningPlatformsPublisher(SignerAsyncClient client, ListSigningPlatformsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSigningPlatformsPublisher(SignerAsyncClient client, ListSigningPlatformsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSigningPlatformsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSigningPlatformsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSigningPlatformsResponseFetcher
    implements AsyncPageFetcher<ListSigningPlatformsResponse> {
        private ListSigningPlatformsResponseFetcher() {
        }

        public boolean hasNextPage(ListSigningPlatformsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSigningPlatformsResponse> nextPage(ListSigningPlatformsResponse previousPage) {
            if (previousPage == null) {
                return ListSigningPlatformsPublisher.this.client.listSigningPlatforms(ListSigningPlatformsPublisher.this.firstRequest);
            }
            return ListSigningPlatformsPublisher.this.client.listSigningPlatforms((ListSigningPlatformsRequest)((Object)ListSigningPlatformsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

