/**
 * src/classes/sys-users.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * * "THE SYSUSER MASTER"
 * Gestione pura Node.js per utenti e gruppi di sistema.
 * Sostituisce i binari (useradd/usermod/deluser) per garantire operazioni atomiche
 * e compatibilità SELinux (Fedora/RHEL) scrivendo file puliti.
 */
export interface IPasswdEntry {
    username: string;
    password: string;
    uid: string;
    gid: string;
    gecos: string;
    home: string;
    shell: string;
}
export interface IShadowEntry {
    username: string;
    hash: string;
    lastChange: string;
    min: string;
    max: string;
    warn: string;
    inactive: string;
    expire: string;
}
export interface IGroupEntry {
    groupName: string;
    password: string;
    gid: string;
    members: string[];
}
export default class SysUsers {
    private targetRoot;
    private distroFamily;
    private passwd;
    private shadow;
    private group;
    private gshadowLines;
    private subuidLines;
    private subgidLines;
    constructor(targetRoot: string, distroFamily: string);
    /**
     * Carica tutti i file di configurazione in memoria
     */
    load(): void;
    /**
     * Salva lo stato della memoria su disco e applica SELinux fix
     */
    save(): Promise<void>;
    /**
     * Crea un nuovo utente completo
     */
    addUser(user: IPasswdEntry, cleanPassword: string): void;
    /**
     * Rimuove completamente un utente
     */
    removeUser(username: string): void;
    /**
     * Aggiunge utente a un gruppo supplementare
     */
    addUserToGroup(username: string, groupName: string): void;
    /**
     * Cambia password utente
     */
    setPassword(username: string, password: string): void;
    private readFile;
    private writeFile;
    private parsePasswd;
    private serializePasswd;
    private parseShadow;
    private serializeShadow;
    private parseGroup;
    private serializeGroup;
}
