/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesCommonBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public final class PythonCextBytesBuiltins {

    static abstract class PyBytes_AsString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_AsString() {
        }

        @Specialization
        static Object doBytes(PBytes bytes) {
            return PySequenceArrayWrapper.ensureNativeSequence(bytes);
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject obj, @Bind Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CStructAccess.GetElementPtrNode getArray, @Cached PRaiseNode raiseNode) {
            if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PBytes)) {
                return getArray.getElementPtr(obj.getPtr(), CFields.PyBytesObject__ob_sval);
            }
            return PyBytes_AsString.doError(obj, raiseNode);
        }

        @Fallback
        static Object doError(Object obj, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_S_P_FOUND, "bytes", obj);
        }
    }

    static abstract class GraalPyPrivate_Bytes_CheckEmbeddedNull
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Bytes_CheckEmbeddedNull() {
        }

        @Specialization
        static int doBytes(Object bytes, @Bind Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode) {
            SequenceStorage sequenceStorage = getBytesStorage.execute(inliningTarget, bytes);
            int len = sequenceStorage.length();
            try {
                for (int i = 0; i < len; ++i) {
                    if (getItemScalarNode.executeInt(inliningTarget, sequenceStorage, i) != 0) continue;
                    return -1;
                }
            }
            catch (UnexpectedResultException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"bytes object contains non-int value");
            }
            return 0;
        }
    }

    static abstract class GraalPyPrivate_ByteArray_EmptyWithCapacity
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_ByteArray_EmptyWithCapacity() {
        }

        @Specialization
        static PByteArray doInt(int size, @Bind PythonLanguage language) {
            return PFactory.createByteArray(language, new byte[size]);
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PByteArray doLong(long size, @Bind PythonLanguage language) throws OverflowException {
            return GraalPyPrivate_ByteArray_EmptyWithCapacity.doInt(PInt.intValueExact(size), language);
        }

        @Specialization(replaces={"doLong"})
        static PByteArray doLongOvf(long size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return GraalPyPrivate_ByteArray_EmptyWithCapacity.doInt(PInt.intValueExact(size), language);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, size);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PByteArray doPInt(PInt size, @Bind PythonLanguage language) throws OverflowException {
            return GraalPyPrivate_ByteArray_EmptyWithCapacity.doInt(size.intValueExact(), language);
        }

        @Specialization(replaces={"doPInt"})
        static PByteArray doPIntOvf(PInt size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return GraalPyPrivate_ByteArray_EmptyWithCapacity.doInt(size.intValueExact(), language);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, size);
            }
        }
    }

    static abstract class GraalPyPrivate_Bytes_EmptyWithCapacity
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Bytes_EmptyWithCapacity() {
        }

        @Specialization
        static PBytes doInt(int size, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, new byte[size]);
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PBytes doLong(long size, @Bind PythonLanguage language) throws OverflowException {
            return GraalPyPrivate_Bytes_EmptyWithCapacity.doInt(PInt.intValueExact(size), language);
        }

        @Specialization(replaces={"doLong"})
        static PBytes doLongOvf(long size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return GraalPyPrivate_Bytes_EmptyWithCapacity.doInt(PInt.intValueExact(size), language);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, size);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static PBytes doPInt(PInt size, @Bind PythonLanguage language) throws OverflowException {
            return GraalPyPrivate_Bytes_EmptyWithCapacity.doInt(size.intValueExact(), language);
        }

        @Specialization(replaces={"doPInt"})
        static PBytes doPIntOvf(PInt size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return GraalPyPrivate_Bytes_EmptyWithCapacity.doInt(size.intValueExact(), language);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, size);
            }
        }
    }

    static abstract class GraalPyPrivate_Bytes_Resize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Bytes_Resize() {
        }

        @Specialization
        static int resize(PBytesLike self, long newSizeL, @Bind Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached CastToByteNode castToByteNode) {
            SequenceStorage storage = self.getSequenceStorage();
            int newSize = asSizeNode.executeExact(null, inliningTarget, newSizeL);
            int len = storage.length();
            byte[] smaller = new byte[newSize];
            for (int i = 0; i < newSize && i < len; ++i) {
                smaller[i] = castToByteNode.execute(null, getItemNode.execute(storage, i));
            }
            self.setSequenceStorage(new ByteSequenceStorage(smaller));
            return 0;
        }

        @Fallback
        static int fallback(Object self, Object o, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, "a bytes object", self);
        }
    }

    @ImportStatic(value={CApiGuards.class})
    static abstract class GraalPyPrivate_ByteArray_FromStringAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_ByteArray_FromStringAndSize() {
        }

        @Specialization
        static Object doGeneric(PythonNativeWrapper object, long size, @Bind PythonLanguage language, @Cached CApiTransitions.NativeToPythonNode asPythonObjectNode, @Cached.Exclusive @Cached BytesNodes.ToBytesNode getByteArrayNode) {
            byte[] ary = getByteArrayNode.execute(null, asPythonObjectNode.execute(object));
            if (size >= 0L && size < (long)ary.length) {
                return PFactory.createByteArray(language, Arrays.copyOf(ary, (int)size));
            }
            return PFactory.createByteArray(language, ary);
        }

        @Specialization(guards={"!isNativeWrapper(nativePointer)"})
        static Object doNativePointer(Object nativePointer, long size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached PRaiseNode raiseNode) {
            try {
                return PFactory.createByteArray(language, getByteArrayNode.execute(inliningTarget, nativePointer, size));
            }
            catch (InteropException e) {
                return raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                return raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
        }
    }

    @ImportStatic(value={CApiGuards.class})
    static abstract class GraalPyPrivate_Bytes_FromStringAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Bytes_FromStringAndSize() {
        }

        @Specialization
        static Object doGeneric(PythonNativeWrapper object, long size, @Bind PythonLanguage language, @Cached CApiTransitions.NativeToPythonNode asPythonObjectNode, @Cached.Exclusive @Cached BytesNodes.ToBytesNode getByteArrayNode) {
            byte[] ary = getByteArrayNode.execute(null, asPythonObjectNode.execute(object));
            if (size >= 0L && size < (long)ary.length) {
                return PFactory.createBytes(language, Arrays.copyOf(ary, (int)size));
            }
            return PFactory.createBytes(language, ary);
        }

        @Specialization(guards={"!isNativeWrapper(nativePointer)"})
        static Object doNativePointer(Object nativePointer, long size, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached.Exclusive @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached PRaiseNode raiseNode) {
            try {
                return PFactory.createBytes(language, getByteArrayNode.execute(inliningTarget, nativePointer, size));
            }
            catch (InteropException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
        }
    }

    static abstract class PyBytes_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_FromObject() {
        }

        @Specialization(guards={"isBuiltinBytes(bytes)"})
        static Object bytes(PBytes bytes) {
            return bytes;
        }

        @Fallback
        static Object fromObject(Object obj, @Bind Node inliningTarget, @Cached BytesNodes.BytesFromObject fromObject) {
            byte[] bytes = fromObject.execute(null, obj);
            return PFactory.createBytes(PythonLanguage.get(inliningTarget), bytes);
        }
    }

    static abstract class GraalPyPrivate_Bytes_FromFormat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Bytes_FromFormat() {
        }

        @Specialization
        static Object fromFormat(TruffleString fmt, Object args, @Cached StringBuiltins.ModNode modeNode, @Cached StringBuiltins.EncodeNode encodeNode) {
            Object formated = modeNode.execute(null, fmt, args);
            return encodeNode.execute(null, formated, PNone.NONE, PNone.NONE);
        }
    }

    static abstract class _PyBytes_Join
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyBytes_Join() {
        }

        @Specialization
        static Object join(Object original, Object newPart, @Cached BytesCommonBuiltins.JoinNode joinNode) {
            return joinNode.execute(null, original, newPart);
        }
    }

    static abstract class GraalPyPrivate_Bytes_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Bytes_Concat() {
        }

        @Specialization
        static Object concat(Object original, Object newPart, @Cached BytesCommonBuiltins.ConcatNode addNode) {
            return addNode.execute(null, original, newPart);
        }
    }

    static abstract class PyBytes_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyBytes_Size() {
        }

        @Specialization
        static long doPBytes(PBytes obj, @Bind Node inliningTarget, @Cached PyObjectSizeNode sizeNode) {
            return sizeNode.execute(null, inliningTarget, obj);
        }

        @Specialization
        static long doOther(PythonAbstractNativeObject obj, @Bind Node inliningTarget, @Cached PyBytesCheckNode check, @Cached CStructAccess.ReadI64Node readI64Node) {
            if (check.execute(inliningTarget, obj)) {
                return readI64Node.readFromObj(obj, CFields.PyVarObject__ob_size);
            }
            return PyBytes_Size.fallback(obj, inliningTarget);
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        static long fallback(Object obj, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_BYTES_P_FOUND, obj);
        }
    }
}

