/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.Cache;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
implements Cache<K, V> {
    private final LRUHashMap<K, V> lruHashMap;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();

    public LRUCache(int maxSize) {
        this.lruHashMap = new LRUHashMap(maxSize);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public V get(K key) {
        try {
            this.read.lock();
            Object v = this.lruHashMap.get(key);
            return v;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CompilerDirectives.TruffleBoundary
    public V put(K key, V value) {
        try {
            this.write.lock();
            V v = this.lruHashMap.putIfAbsent(key, value);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void clear() {
        try {
            this.write.lock();
            this.lruHashMap.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int size() {
        try {
            this.read.lock();
            int n = this.lruHashMap.size();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    static class LRUHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -2396748959641741279L;
        private final int maxSize;

        public LRUHashMap(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

