"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const language_service_1 = require("@volar/language-service");
const featureWorkers_1 = require("@volar/language-service/lib/utils/featureWorkers");
function register(htmlLs) {
    return (pugDoc, posArr) => {
        const htmlPosArr = posArr
            .map(position => {
            for (const pos of (0, featureWorkers_1.getGeneratedPositions)(pugDoc.docs, position)) {
                return pos;
            }
        })
            .filter((v) => !!v);
        const htmlResult = htmlLs.getSelectionRanges(pugDoc.docs[1], htmlPosArr);
        return (0, language_service_1.transformLocations)(htmlResult, htmlRange => (0, featureWorkers_1.getSourceRange)(pugDoc.docs, htmlRange));
    };
}
//# sourceMappingURL=selectionRanges.js.map