/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.alg.util.Extension;

public abstract class MaximumFlowAlgorithmBase<V, E>
implements MaximumFlowAlgorithm<V, E> {
    public static final double DEFAULT_EPSILON = 1.0E-9;
    private Extension<V, ? extends VertexExtensionBase> vXs;
    private Extension<E, ? extends EdgeExtensionBase> eXs;

    abstract DirectedGraph<V, E> getNetwork();

    <VE extends VertexExtensionBase, EE extends EdgeExtensionBase> void init(Extension.ExtensionFactory<VE> vertexExtensionFactory, Extension.ExtensionFactory<EE> edgeExtensionFactory) {
        this.vXs = new Extension(vertexExtensionFactory);
        this.eXs = new Extension(edgeExtensionFactory);
        this.buildInternal();
    }

    private void buildInternal() {
        DirectedGraph n = this.getNetwork();
        for (Object u : n.vertexSet()) {
            VertexExtensionBase ux = this.extendedVertex(u);
            ux.prototype = u;
            for (E e : n.outgoingEdgesOf(u)) {
                Object v = n.getEdgeTarget(e);
                VertexExtensionBase vx = this.extendedVertex(v);
                EdgeExtensionBase ex = this.createEdge(ux, vx, e, n.getEdgeWeight(e));
                EdgeExtensionBase iex = this.createInverse(ex, n);
                ux.getOutgoing().add(ex);
                if (iex.prototype != null) continue;
                vx.getOutgoing().add(iex);
            }
        }
    }

    private EdgeExtensionBase createEdge(VertexExtensionBase source, VertexExtensionBase target, E e, double weight) {
        EdgeExtensionBase ex = this.extendedEdge(e);
        ex.source = source;
        ex.target = target;
        ex.capacity = weight;
        ex.prototype = e;
        return ex;
    }

    private EdgeExtensionBase createInverse(EdgeExtensionBase ex, DirectedGraph<V, E> n) {
        EdgeExtensionBase iex;
        if (n.containsEdge(((EdgeExtensionBase)ex).target.prototype, ((EdgeExtensionBase)ex).source.prototype)) {
            Object ie = n.getEdge(((EdgeExtensionBase)ex).target.prototype, ((EdgeExtensionBase)ex).source.prototype);
            iex = this.createEdge(ex.target, ex.source, ie, n.getEdgeWeight(ie));
        } else {
            iex = this.eXs.createInstance();
            iex.source = ex.target;
            iex.target = ex.source;
        }
        ex.inverse = iex;
        iex.inverse = ex;
        return iex;
    }

    private VertexExtensionBase extendedVertex(V v) {
        return this.vertexExtended(v);
    }

    private EdgeExtensionBase extendedEdge(E e) {
        return this.edgeExtended(e);
    }

    protected <VE extends VertexExtensionBase> VE vertexExtended(V v) {
        return (VE)this.vXs.get(v);
    }

    protected <EE extends EdgeExtensionBase> EE edgeExtended(E e) {
        return (EE)this.eXs.get(e);
    }

    protected void pushFlowThrough(EdgeExtensionBase ex, double f) {
        Object iex = ex.getInverse();
        assert (this.compareFlowTo(ex.flow, 0.0) == 0 || this.compareFlowTo(((EdgeExtensionBase)iex).flow, 0.0) == 0);
        if (this.compareFlowTo(((EdgeExtensionBase)iex).flow, f) == -1) {
            double d = f - ((EdgeExtensionBase)iex).flow;
            ex.flow += d;
            ex.capacity -= ((EdgeExtensionBase)iex).flow;
            ((EdgeExtensionBase)iex).flow = 0.0;
            ((EdgeExtensionBase)iex).capacity += d;
        } else {
            ex.capacity -= f;
            ((EdgeExtensionBase)iex).flow -= f;
        }
    }

    protected Map<E, Double> composeFlow() {
        HashMap maxFlow = new HashMap();
        for (Object e : this.getNetwork().edgeSet()) {
            EdgeExtensionBase ex = this.extendedEdge(e);
            maxFlow.put(e, ex.flow);
        }
        return maxFlow;
    }

    protected int compareFlowTo(double flow, double val) {
        double diff = flow - val;
        if (Math.abs(diff) < 1.0E-9) {
            return 0;
        }
        return diff < 0.0 ? -1 : 1;
    }

    class EdgeExtensionBase
    extends Extension.BaseExtension {
        private VertexExtensionBase source;
        private VertexExtensionBase target;
        private EdgeExtensionBase inverse;
        E prototype;
        double capacity;
        double flow;

        EdgeExtensionBase() {
        }

        public <VE extends VertexExtensionBase> VE getSource() {
            return (VE)this.source;
        }

        public void setSource(VertexExtensionBase source) {
            this.source = source;
        }

        public <VE extends VertexExtensionBase> VE getTarget() {
            return (VE)this.target;
        }

        public void setTarget(VertexExtensionBase target) {
            this.target = target;
        }

        public <EE extends EdgeExtensionBase> EE getInverse() {
            return (EE)this.inverse;
        }

        public void setInverse(EdgeExtensionBase inverse) {
            this.inverse = inverse;
        }
    }

    class VertexExtensionBase
    extends Extension.BaseExtension {
        private final List<? extends EdgeExtensionBase> outgoing = new ArrayList<EdgeExtensionBase>();
        V prototype;
        double excess;

        VertexExtensionBase() {
        }

        public <EE extends EdgeExtensionBase> List<EE> getOutgoing() {
            return this.outgoing;
        }
    }
}

