/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

// This test tends to trigger a race in the fullscreen time telemetry,
// where the fullscreen enter and fullscreen exit events (which use the
// same histogram ID) overlap. That causes TelemetryStopwatch to log an
// error.
SimpleTest.ignoreAllUncaughtExceptions(true);
SimpleTest.requestLongerTimeout(2);

const TEST_URL =
  "http://example.com/browser/browser/base/content/test/fullscreen/open_and_focus_helper.html";
const IFRAME_ID = "testIframe";

async function testWindowOpen(iframeID) {
  let tab = await BrowserTestUtils.openNewForegroundTab(gBrowser, TEST_URL);
  info("Entering full-screen");
  await changeFullscreen(tab.linkedBrowser, true);

  let popup;
  await testExpectFullScreenExit(tab.linkedBrowser, true, async () => {
    info("Calling window.open()");
    popup = await jsWindowOpen(tab.linkedBrowser, iframeID);
  });

  // Cleanup
  await BrowserTestUtils.closeWindow(popup);
  BrowserTestUtils.removeTab(tab);
}

add_task(async function setup() {
  await SpecialPowers.pushPrefEnv({
    set: [
      ["dom.disable_open_during_load", false], // Allow window.open calls without user interaction
      ["browser.link.open_newwindow.disabled_in_fullscreen", false],
    ],
  });
});

add_task(function test_parentWindowOpen() {
  return testWindowOpen();
});

add_task(function test_iframeWindowOpen() {
  return testWindowOpen(IFRAME_ID);
});
