/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.lnf.LookAndFeelProvider;
import ancestris.app.App;
import ancestris.app.AppOptions;
import ancestris.app.OptionDisplayOptionsPanelController;
import ancestris.core.TextOptions;
import ancestris.startup.settings.StartupOptions;
import ancestris.util.Lifecycle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class OptionDisplayPanel
extends JPanel {
    private final OptionDisplayOptionsPanelController controller;
    Locale[] locales = new Locale[]{new Locale("br"), new Locale("es"), new Locale("ca"), new Locale("cs"), new Locale("da"), Locale.GERMAN, Locale.ENGLISH, new Locale("el"), new Locale("fi"), Locale.FRENCH, new Locale("hu"), Locale.ITALIAN, new Locale("lv"), new Locale("nl"), new Locale("no"), new Locale("pl"), new Locale("pt"), new Locale("ru"), new Locale("sv"), new Locale("tr")};
    private static final LookAndFeelProvider[] SKINS = LookAndFeelProvider.getProviders();
    private long memTotal;
    private String xmx = "";
    private String laf = "";
    private JCheckBox jCheckBoxWindow;
    private JComboBox jComboBoxAppearance;
    private JLabel jLabel5;
    private JLabel jLabelAppearance;
    private JLabel jLabelFontsize;
    private JLabel jLabelLanguage;
    private JLabel jLabelMemsize;
    private JLabel jLabelOutput;
    private JLabel jLabelWindow;
    private JLabel jLabelZoom;
    private JLabel jLabelcMemsize;
    private JPanel jPanelDemo;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerFontsize;
    private JSpinner jSpinnerMemsize;
    private JSpinner jSpinnerZoom;
    private JComboBox jcbLanguage;
    private JComboBox jcbOutputLanguage;
    private JPanel mainPanel;

    OptionDisplayPanel(OptionDisplayOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.jComboBoxAppearanceActionPerformed(null);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.jSpinnerFontsize = new JSpinner();
        this.jLabelWindow = new JLabel();
        this.jCheckBoxWindow = new JCheckBox();
        this.jLabelMemsize = new JLabel();
        this.jLabelLanguage = new JLabel();
        this.jSpinnerMemsize = new JSpinner();
        this.jcbLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.system")));
        this.jLabelcMemsize = new JLabel();
        this.jLabelOutput = new JLabel();
        this.jPanelDemo = new JPanel();
        this.jLabel5 = new JLabel();
        this.jcbOutputLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.gui")));
        this.jLabelAppearance = new JLabel();
        this.jLabelZoom = new JLabel();
        this.jComboBoxAppearance = new JComboBox<LookAndFeelProvider>(SKINS);
        this.jSpinnerZoom = new JSpinner();
        this.jLabelFontsize = new JLabel();
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jSpinnerFontsize.setModel(new SpinnerNumberModel(12, 5, 40, 1));
        this.jLabelWindow.setFont(this.jLabelWindow.getFont().deriveFont(this.jLabelWindow.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelWindow, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelWindow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxWindow, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBoxWindow.text"));
        this.jCheckBoxWindow.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBoxWindow.toolTipText"));
        this.jLabelMemsize.setFont(this.jLabelMemsize.getFont().deriveFont(this.jLabelMemsize.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelMemsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelMemsize.text"));
        this.jLabelLanguage.setFont(this.jLabelLanguage.getFont().deriveFont(this.jLabelLanguage.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelLanguage, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelLanguage.text"));
        this.jSpinnerMemsize.setModel(new SpinnerNumberModel(1, 1, 12, 1));
        this.jcbLanguage.setMaximumRowCount(25);
        this.jcbLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbLanguage.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelcMemsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelcMemsize.text"));
        this.jLabelOutput.setFont(this.jLabelOutput.getFont().deriveFont(this.jLabelOutput.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelOutput, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelOutput.text"));
        this.jPanelDemo.setBackground(new Color(179, 179, 179));
        this.jPanelDemo.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDemo.setPreferredSize(new Dimension(199, 224));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel5.text"));
        GroupLayout jPanelDemoLayout = new GroupLayout(this.jPanelDemo);
        this.jPanelDemo.setLayout(jPanelDemoLayout);
        jPanelDemoLayout.setHorizontalGroup(jPanelDemoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDemoLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 177, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDemoLayout.setVerticalGroup(jPanelDemoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDemoLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 214, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jcbOutputLanguage.setMaximumRowCount(25);
        this.jcbOutputLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbOutputLanguage.toolTipText"));
        this.jLabelAppearance.setFont(this.jLabelAppearance.getFont().deriveFont(this.jLabelAppearance.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelAppearance, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelAppearance.text"));
        this.jLabelZoom.setFont(this.jLabelZoom.getFont().deriveFont(this.jLabelZoom.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelZoom, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelZoom.text"));
        this.jComboBoxAppearance.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jComboBoxAppearance.toolTipText"));
        this.jComboBoxAppearance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDisplayPanel.this.jComboBoxAppearanceActionPerformed(evt);
            }
        });
        this.jSpinnerZoom.setModel(new SpinnerNumberModel(100, 75, 250, 25));
        this.jSpinnerZoom.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jSpinnerZoom.toolTipText"));
        this.jLabelFontsize.setFont(this.jLabelFontsize.getFont().deriveFont(this.jLabelFontsize.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelFontsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelFontsize.text"));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabelZoom, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelWindow, GroupLayout.Alignment.LEADING).addComponent(this.jLabelMemsize, GroupLayout.Alignment.LEADING).addComponent(this.jLabelOutput, GroupLayout.Alignment.LEADING).addComponent(this.jLabelLanguage).addComponent(this.jLabelAppearance, GroupLayout.Alignment.LEADING).addComponent(this.jLabelFontsize, GroupLayout.Alignment.LEADING)).addGap(28, 28, 28).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxAppearance, 0, -1, Short.MAX_VALUE).addComponent(this.jcbOutputLanguage, 0, -1, Short.MAX_VALUE).addComponent(this.jcbLanguage, 0, -1, Short.MAX_VALUE)).addGap(32, 32, 32)).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxWindow).addComponent(this.jSpinnerFontsize, -2, 90, -2).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jSpinnerMemsize, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelcMemsize))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addComponent(this.jPanelDemo, -2, 182, -2)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.jSpinnerZoom, -2, 90, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDemo, -2, 219, -2).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLanguage).addComponent(this.jcbLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutput).addComponent(this.jcbOutputLanguage, -2, -1, -2)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAppearance).addComponent(this.jComboBoxAppearance, -2, -1, -2)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerFontsize, -2, -1, -2).addComponent(this.jLabelFontsize)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWindow).addComponent(this.jCheckBoxWindow)).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMemsize).addComponent(this.jSpinnerMemsize, -2, -1, -2).addComponent(this.jLabelcMemsize)))).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelZoom).addComponent(this.jSpinnerZoom, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 578, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1).addGap(0, 0, 0)));
    }

    private void jComboBoxAppearanceActionPerformed(ActionEvent evt) {
        LookAndFeelProvider provider = (LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem();
        this.jLabel5.setIcon(provider == null ? null : provider.getSampleImage());
    }

    void load() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String currentXmx = "";
        String zoom = "";
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String s : arguments) {
            if (s.contains("-Xmx")) {
                currentXmx = s.substring(4);
            }
            if (!s.contains("-Dsun.java2d.uiScale")) continue;
            zoom = s.substring(21);
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            this.memTotal = 1L + Long.parseLong(attribute.toString()) / 0x40000000L;
            this.jSpinnerMemsize.setModel(new SpinnerNumberModel(1.0, 1.0, this.memTotal - 1L, 1.0));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StartupOptions stopts = new StartupOptions();
        this.xmx = stopts.getJvmParameter("-J-Xmx");
        if (this.xmx == null || this.xmx.isEmpty()) {
            this.xmx = currentXmx;
        }
        this.setLanguage(stopts.getJvmLocale());
        this.setOutputLanguage(TextOptions.getInstance().getOutputLocale(null));
        String value = AppOptions.getFontSize();
        if (value != null && !value.isEmpty()) {
            this.jSpinnerFontsize.setValue(Integer.valueOf(value));
        }
        this.laf = stopts.getJvmParameter("--laf");
        if (this.laf == null) {
            this.laf = "";
        }
        this.jComboBoxAppearance.setSelectedItem(LookAndFeelProvider.getProviderFromName((String)this.laf));
        this.jCheckBoxWindow.setSelected(AppOptions.isRestoreViews());
        if (this.xmx != null) {
            Integer i;
            Integer c = 0;
            try {
                i = Integer.valueOf(this.xmx.replace('g', ' ').trim());
                c = Integer.valueOf(currentXmx.replace('g', ' ').trim());
            }
            catch (NumberFormatException e) {
                i = 1;
            }
            this.jSpinnerMemsize.setValue(i);
            this.jLabelcMemsize.setText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelcMemsize.text", (Object)c));
        }
        if (!"".equals(zoom)) {
            Double bgzoom = Double.valueOf(zoom);
            bgzoom = bgzoom * 100.0;
            this.jSpinnerZoom.setValue(Math.floor(bgzoom));
        }
    }

    void store() {
        boolean needRestart = false;
        StartupOptions stopts = new StartupOptions();
        needRestart |= stopts.setJvmLocale(this.getLanguage());
        TextOptions.getInstance().setOutputLocale(this.getOutputLanguage());
        String newLaf = ((LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem()).getName();
        needRestart |= stopts.setJvmParameter("--laf", newLaf);
        stopts.setJvmParameter("--cp:p", ((LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem()).getClassPath());
        needRestart |= !AppOptions.getFontSize().equals(this.jSpinnerFontsize.getValue().toString());
        AppOptions.setFontSize(this.jSpinnerFontsize.getValue().toString());
        needRestart |= stopts.setJvmParameter("-J-Xmx", ((SpinnerNumberModel)this.jSpinnerMemsize.getModel()).getNumber().intValue() + "g");
        int zoom = ((SpinnerNumberModel)this.jSpinnerZoom.getModel()).getNumber().intValue();
        needRestart = zoom == 100 ? (needRestart |= stopts.setJvmParameter("-J-Dsun.java2d.uiScale", null)) : (needRestart |= stopts.setJvmParameter("-J-Dsun.java2d.uiScale", String.format("%.2f", (double)zoom / 100.0).replace(",", ".")));
        stopts.applyChanges();
        AppOptions.setRestoreViews(this.jCheckBoxWindow.isSelected());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionPanel.saved.statustext"));
        if (needRestart) {
            Lifecycle.askForStopAndStart(null, this.getLanguage(), this.isDarkModeChanged(this.laf, newLaf));
        }
    }

    private String[] initLanguages(String defaultDesc) {
        ArrayList<String> langDescr = new ArrayList<String>(this.locales.length);
        langDescr.add(defaultDesc);
        for (Locale locale : this.locales) {
            if (locale.getDisplayName(locale).equals("espa\u00f1ol")) {
                langDescr.add("Castellano");
                continue;
            }
            langDescr.add(locale.getDisplayName(locale));
        }
        return (String[])langDescr.toArray(String[]::new);
    }

    private int findLanguageIndex(Locale locale) {
        int i;
        if (locale == null) {
            return -1;
        }
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.equals(this.locales[i])) continue;
            return i;
        }
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.getLanguage().equals(this.locales[i].getLanguage())) continue;
            return i;
        }
        return -1;
    }

    void setLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbLanguage.setSelectedIndex(++i);
    }

    Locale getLanguage() {
        int i = this.jcbLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }

    void setOutputLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbOutputLanguage.setSelectedIndex(++i);
    }

    Locale getOutputLanguage() {
        int i = this.jcbOutputLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }

    private boolean isDarkModeChanged(String laf, String newLaf) {
        String mode = "dark";
        laf = laf.toLowerCase();
        newLaf = newLaf.toLowerCase();
        return laf.contains(mode) && !newLaf.contains(mode) || !laf.contains(mode) && newLaf.contains(mode);
    }
}

