/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.GedcomExplorerTopComponent;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.io.Filter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import org.openide.util.NbBundle;

public class Filters {
    protected static Filter[] get() {
        ArrayList<Object> ret = new ArrayList<Object>();
        ret.add(new FilterAllIn());
        ret.add(new FilterRecentlyModified());
        return ret.toArray(new Filter[0]);
    }

    protected static class FilterAllIn
    implements Filter {
        FilterAllIn() {
        }

        public String toString() {
            return this.getFilterName();
        }

        public String getFilterName() {
            return NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"DisplayType.AllEntities");
        }

        public String getSelectionName() {
            return "";
        }

        public int getIndividualsCount() {
            return -1;
        }

        public boolean veto(Entity entity) {
            return false;
        }

        public boolean veto(Property property) {
            return false;
        }

        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    protected static class FilterRecentlyModified
    implements Filter {
        private FilterRecentlyModified() {
        }

        public String toString() {
            return this.getFilterName();
        }

        public String getFilterName() {
            long millisec = Long.parseLong(GedcomOptions.getInstance().getFromModificationDate());
            Date date = new Date(millisec);
            LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            DateTimeFormatter pattern = DateTimeFormatter.ofPattern("EEEE dd MMMM yyyy HH:mm");
            String formattedDate = localDateTime.format(pattern);
            return NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"DisplayType.ChangedLast", (Object)formattedDate);
        }

        public String getSelectionName() {
            return "ChangedLast";
        }

        public int getIndividualsCount() {
            return 0;
        }

        public boolean veto(Entity entity) {
            long modDateLong;
            long lastChange;
            long now = System.currentTimeMillis();
            PropertyChange changeProp = entity.getLastChange();
            long l = lastChange = changeProp != null ? changeProp.getTime() : now;
            if (changeProp != null) {
                long offset = PropertyChange.toLocal((long)System.currentTimeMillis()) - System.currentTimeMillis();
                lastChange -= offset;
            }
            return lastChange < (modDateLong = Long.parseLong(GedcomOptions.getInstance().getFromModificationDate()));
        }

        public boolean veto(Property property) {
            return false;
        }

        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    protected static class FilterNeighbourhood
    implements Filter {
        private FilterNeighbourhood() {
        }

        public String toString() {
            return this.getFilterName();
        }

        public String getFilterName() {
            return NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"DisplayType.Neighbourhood");
        }

        public String getSelectionName() {
            return "";
        }

        public int getIndividualsCount() {
            return 0;
        }

        public boolean veto(Entity entity) {
            return false;
        }

        public boolean veto(Property property) {
            return false;
        }

        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }
}

