/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.marking;

import ancestris.api.search.SearchCommunicator;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.commonAncestor.CommonAncestorTopComponent;
import ancestris.modules.document.view.HyperLinkTextDocumentView;
import ancestris.modules.document.view.WidgetDocumentView;
import ancestris.modules.gedcom.marking.MarkingAction;
import ancestris.modules.gedcom.marking.MarkingPanel;
import ancestris.modules.gedcom.marking.MarkingTask;
import ancestris.util.TimingUtility;
import genj.common.ContextListWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.io.Filter;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class MarkingTaskFactory {
    public static MarkingTask create(Context context, Indi indiDeCujus, MarkingPanel.Settings settings) {
        return new Impl(context, indiDeCujus, settings);
    }

    private static class Impl
    implements MarkingTask {
        private static final Logger log = Logger.getLogger(MarkingTaskFactory.class.getName());
        private HyperLinkTextDocumentView summary = null;
        private final String LINESTR = "====================================================================================================";
        private Gedcom gedcom = null;
        private Context context = null;
        private Indi indi = null;
        private MarkingPanel.Settings settings = null;
        private int progress = 0;
        private int counter = 0;
        private int maxCounter = 0;
        private boolean cancel = false;
        private String taskName = "";
        private String state = "";
        private final Color notSosaColor = new Color(153, 0, 255);
        private int maxGen = 0;

        private Impl(Context context, Indi indiDeCujus, MarkingPanel.Settings settings) {
            this.context = context;
            this.gedcom = context.getGedcom();
            this.indi = indiDeCujus;
            this.settings = settings;
            this.taskName = NbBundle.getMessage(MarkingAction.class, (String)"MarkingAction.AskParams");
            this.maxCounter = (settings.isTreeTop ? 3 : 0) + (settings.isTreeBottom ? 3 : 0) + (settings.isImplex || settings.isMulti ? 4 : 0) + (settings.isSearch ? 3 : 0) + (settings.isViews ? 2 : 0);
        }

        @Override
        public void run() {
            this.mark(this.context, this.indi, this.settings);
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            return this.progress;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getState() {
            return this.state;
        }

        public boolean setProgress(String name, int p) {
            this.state = name != null ? name : this.getTaskName();
            this.progress = p * 100 / this.maxCounter;
            log.log(Level.FINE, "{0} - step name = {1}", new Object[]{TimingUtility.getInstance().getTime(), name});
            return true;
        }

        private void mark(Context context, Indi indiDeCujus, MarkingPanel.Settings settings) {
            this.counter = 1;
            TimingUtility.getInstance().reset();
            ArrayList<ViewContext> treetops = new ArrayList<ViewContext>();
            ArrayList<ViewContext> treebottoms = new ArrayList<ViewContext>();
            ArrayList<ViewContext> implexes = new ArrayList<ViewContext>();
            ArrayList<ViewContext> multipleancestors = new ArrayList<ViewContext>();
            ArrayList<ViewContext> searchIndividuals = new ArrayList<ViewContext>();
            ArrayList<ViewContext> viewsIndividuals = new ArrayList<ViewContext>();
            if (settings.isTreeTop) {
                this.markTreeTop(this.gedcom, indiDeCujus, settings, treetops, NbBundle.getMessage(this.getClass(), (String)"MarkingPanel.jCheckBoxTreeTop.text"));
            }
            if (this.cancel) {
                return;
            }
            if (settings.isTreeBottom) {
                this.markTreeBottom(this.gedcom, indiDeCujus, settings, treebottoms, NbBundle.getMessage(this.getClass(), (String)"MarkingPanel.jCheckBoxTreeBottom.text"));
            }
            if (this.cancel) {
                return;
            }
            if (settings.isImplex || settings.isMulti) {
                this.markImplex(this.gedcom, settings, implexes, multipleancestors, NbBundle.getMessage(this.getClass(), (String)"MarkingPanel.jCheckBoxImplex.text"));
            }
            if (this.cancel) {
                return;
            }
            if (settings.isSearch) {
                this.markSearch(this.gedcom, settings, searchIndividuals, NbBundle.getMessage(this.getClass(), (String)"MarkingPanel.jCheckBoxSearch.text"));
            }
            if (this.cancel) {
                return;
            }
            if (settings.isViews) {
                this.markView(this.gedcom, settings, viewsIndividuals, NbBundle.getMessage(this.getClass(), (String)"MarkingPanel.jCheckBoxViews.text"));
            }
            if (this.cancel) {
                return;
            }
            WindowManager.getDefault().invokeWhenUIReady(() -> {
                boolean shown = false;
                if (settings.toBeDisplayed) {
                    this.summary = new HyperLinkTextDocumentView(new Context(this.gedcom), this.taskName, this.taskName);
                    this.summary.add(this.taskName + "\n");
                    this.summary.add("====================================================================================================".substring(0, this.taskName.length()) + "\n");
                }
                if (settings.isTreeTop && !treetops.isEmpty() && settings.toBeDisplayed) {
                    this.showDocument(this.gedcom, treetops, "MarkingPanel.jCheckBoxTreeTop.text", treetops.size(), context.toString());
                    shown = true;
                }
                if (settings.isTreeBottom && !treebottoms.isEmpty() && settings.toBeDisplayed) {
                    this.showDocument(this.gedcom, treebottoms, "MarkingPanel.jCheckBoxTreeBottom.text", treebottoms.size(), context.toString());
                    shown = true;
                }
                if (settings.isImplex && !implexes.isEmpty() && settings.toBeDisplayed) {
                    CommonAncestorTopComponent.createInstance((Context)context);
                    this.showDocument(this.gedcom, implexes, "MarkingPanel.jCheckBoxImplex.text", implexes.size(), context.getGedcom().getDisplayName());
                    shown = true;
                }
                if (settings.isMulti && !multipleancestors.isEmpty() && settings.toBeDisplayed) {
                    this.showDocument(this.gedcom, multipleancestors, "MarkingPanel.jCheckBoxMulti.text", multipleancestors.size(), context.getGedcom().getDisplayName());
                    shown = true;
                }
                if (settings.isSearch && !searchIndividuals.isEmpty() && settings.toBeDisplayed) {
                    this.showDocument(this.gedcom, searchIndividuals, "MarkingPanel.jCheckBoxSearch.text", searchIndividuals.size(), context.getGedcom().getDisplayName() + " | " + NbBundle.getMessage(MarkingAction.class, (String)settings.searchOption));
                    shown = true;
                }
                if (settings.isViews && !viewsIndividuals.isEmpty() && settings.toBeDisplayed) {
                    this.showDocument(this.gedcom, viewsIndividuals, "MarkingPanel.jCheckBoxViews.text", viewsIndividuals.size(), context.getGedcom().getDisplayName() + " | " + settings.viewsOption);
                    shown = true;
                }
                if (!settings.toBeDisplayed && settings.toBeMarked) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MarkingAction.class, (String)"MarkingAction.Done"), 1));
                }
                if (settings.toBeDisplayed && !shown) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(MarkingAction.class, (String)"MarkingAction.Nothing"), 1));
                }
                if (settings.toBeDisplayed) {
                    String optionsStr = "\n" + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.Marked.options.text");
                    this.summary.add(optionsStr + "\n");
                    this.summary.add("====================================================================================================".substring(0, optionsStr.length()) + "\n");
                    this.summary.add(settings.displaySettings());
                    this.summary.add("\n\n");
                }
            });
        }

        private void showDocument(Gedcom gedcom, List<ViewContext> list, String text, int size, String context) {
            ContextListWidget object = new ContextListWidget(new ArrayList<ViewContext>(list));
            String title = NbBundle.getMessage(MarkingAction.class, (String)text);
            String message1 = NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.Marked.title", (Object)size, (Object)title);
            String message2 = NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.Marked.tip", (Object)title, (Object)context);
            this.summary.add("\n* " + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.Marked.tab.text") + " : " + message1 + "\n   - " + message2 + "\n     " + size + " " + NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.Marked.found.text") + ".\n\n");
            new WidgetDocumentView(new Context(gedcom), message1, message2, (JComponent)object);
        }

        private void sortMarkers(List<ViewContext> list) {
            list.sort((o1, o2) -> o1.compareTo(o2));
        }

        private void sortMarkers2(List<ViewContext> list) {
            list.sort((o1, o2) -> {
                int i2;
                String s1 = o1.getCode();
                String s2 = o2.getCode();
                int i1 = Integer.parseInt(s1 == null ? "0" : s1);
                if (i1 != (i2 = Integer.parseInt(s2 == null ? "0" : s2))) {
                    return Integer.compare(i2, i1);
                }
                return o1.compareTo(o2);
            });
        }

        private void markTreeTop(Gedcom gedcom, Indi indiDeCujus, MarkingPanel.Settings settings, List<ViewContext> treetops, String taskName) {
            this.setProgress(taskName, this.counter);
            if (settings.toBeErased) {
                this.deleteTags(gedcom, "INDI", settings.treeTopTag);
            }
            this.setProgress(taskName + " 1/3", this.counter++);
            this.maxGen = 0;
            HashSet<Indi> viewedIndis = new HashSet<Indi>();
            this.iterateUp(indiDeCujus, 1, BigInteger.ONE, viewedIndis, settings, treetops);
            this.setProgress(taskName + " 2/3", this.counter++);
            if (settings.toBeDisplayed) {
                int nbDigit = (int)(Math.log10(2.0) * (double)this.maxGen) + 1;
                DecimalFormat formatGen = new DecimalFormat("00");
                DecimalFormat formatSosa = new DecimalFormat("0000000000000000000000000000000".substring(0, nbDigit));
                for (ViewContext vc : treetops) {
                    String[] str = vc.getText().split("%");
                    vc.setText("G" + formatGen.format(Integer.valueOf(str[0])) + "-" + formatSosa.format(new BigInteger(str[1])) + " - " + str[2]);
                }
                this.sortMarkers(treetops);
            }
            this.setProgress(taskName + " 3/3", this.counter++);
        }

        private void iterateUp(Indi indi, int gen, BigInteger sosa, Set<Indi> viewedIndis, MarkingPanel.Settings settings, List<ViewContext> treetops) {
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi parent = famc.getHusband();
                if (parent != null) {
                    this.iterateUp(parent, gen + 1, sosa.shiftLeft(1), viewedIndis, settings, treetops);
                }
                if ((parent = famc.getWife()) != null) {
                    this.iterateUp(parent, gen + 1, sosa.shiftLeft(1).add(BigInteger.ONE), viewedIndis, settings, treetops);
                }
            } else if (!viewedIndis.contains(indi)) {
                viewedIndis.add(indi);
                if (settings.toBeMarked) {
                    indi.addProperty(settings.treeTopTag, settings.treeTopValue);
                }
                if (settings.toBeDisplayed) {
                    treetops.add(new ViewContext((Entity)indi).setText(sosa.bitLength() + "%" + sosa + "%" + indi.getDisplayTitle(true)));
                    this.maxGen = Math.max(this.maxGen, sosa.bitLength());
                }
            }
        }

        private void markTreeBottom(Gedcom gedcom, Indi indiDeCujus, MarkingPanel.Settings settings, List<ViewContext> treebottoms, String taskName) {
            this.setProgress(taskName, this.counter);
            if (settings.toBeErased) {
                this.deleteTags(gedcom, "INDI", settings.treeBottomTag);
            }
            this.setProgress(taskName + " 1/3", this.counter++);
            HashSet<Indi> viewedIndis = new HashSet<Indi>();
            HashSet<Fam> viewedFams = new HashSet<Fam>();
            this.iterateDown(indiDeCujus, 1, "1", viewedIndis, viewedFams, settings, treebottoms);
            this.setProgress(taskName + " 2/3", this.counter++);
            if (settings.toBeDisplayed) {
                this.sortMarkers(treebottoms);
            }
            this.setProgress(taskName + " 3/3", this.counter++);
        }

        private void iterateDown(Indi indi, int gen, String num, Set<Indi> viewedIndis, Set<Fam> viewedFams, MarkingPanel.Settings settings, List<ViewContext> treebottoms) {
            Fam[] fams = indi.getFamiliesWhereSpouse();
            boolean several = fams.length > 1;
            Character suffix = Character.valueOf('a');
            DecimalFormat formatGen = new DecimalFormat("00");
            if (fams.length == 0) {
                if (viewedIndis.contains(indi)) {
                    return;
                }
                viewedIndis.add(indi);
                if (settings.toBeMarked) {
                    indi.addProperty(settings.treeBottomTag, settings.treeBottomValue);
                }
                if (settings.toBeDisplayed) {
                    treebottoms.add(new ViewContext((Entity)indi).setText("G" + formatGen.format(gen) + "-" + num + " - " + indi.getDisplayTitle(true)));
                }
                return;
            }
            for (Fam fam : fams) {
                if (viewedFams.contains(fam)) continue;
                viewedFams.add(fam);
                Indi[] children = fam.getChildren();
                if (children.length == 0) {
                    Indi husb = fam.getHusband();
                    Indi wife = fam.getWife();
                    if (husb != null && !viewedIndis.contains(husb)) {
                        viewedIndis.add(husb);
                        if (settings.toBeMarked) {
                            husb.addProperty(settings.treeBottomTag, settings.treeBottomValue + " " + fam.getId());
                        }
                        if (settings.toBeDisplayed) {
                            treebottoms.add(new ViewContext((Entity)husb).setText("G" + formatGen.format(gen) + "-" + num + " - " + husb.getDisplayTitle(true)));
                        }
                    }
                    if (wife != null && !viewedIndis.contains(wife)) {
                        viewedIndis.add(wife);
                        if (settings.toBeMarked) {
                            wife.addProperty(settings.treeBottomTag, settings.treeBottomValue + " " + fam.getId());
                        }
                        if (settings.toBeDisplayed) {
                            treebottoms.add(new ViewContext((Entity)wife).setText("G" + formatGen.format(gen) + "-" + num + suffix.toString() + " - " + wife.getDisplayTitle(true)));
                        }
                    }
                    return;
                }
                for (int c = 0; c < children.length; ++c) {
                    this.iterateDown(children[c], gen + 1, num + (several ? suffix.toString() : "") + (c + 1), viewedIndis, viewedFams, settings, treebottoms);
                }
                Character c = suffix;
                suffix = Character.valueOf((char)(suffix.charValue() + '\u0001'));
            }
        }

        private void markImplex(Gedcom gedcom, MarkingPanel.Settings settings, List<ViewContext> implexes, List<ViewContext> multipleancestors, String taskName) {
            this.setProgress(taskName, this.counter);
            if (settings.toBeErased) {
                if (settings.isImplex) {
                    this.deleteTags(gedcom, "FAM", settings.implexTag);
                }
                if (settings.isMulti) {
                    this.deleteTags(gedcom, "INDI", settings.multiTag);
                }
            }
            this.setProgress(taskName + " 1/4", this.counter++);
            HashMap ancestors = new HashMap();
            gedcom.getFamilies().forEach(fam -> {
                Indi wife;
                Indi husb = fam.getHusband();
                int nbCA = this.getNbOfCommonAncestor((Fam)fam, husb, wife = fam.getWife(), ancestors);
                if (nbCA > 0) {
                    this.addImplex((Fam)fam, implexes, nbCA);
                    if (settings.isImplex && settings.toBeMarked) {
                        String str = settings.implexValue + " (" + String.valueOf(nbCA) + ")";
                        fam.addProperty(settings.implexTag, str);
                    }
                }
            });
            this.setProgress(taskName + " 2/4", this.counter++);
            if (implexes.isEmpty()) {
                implexes.add(new ViewContext(gedcom).setCode("0").setText(NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.NoImplexFound")));
            }
            int size = 0;
            Object str = "";
            String strMax = "";
            int ctr = 0;
            for (Indi indien : ancestors.keySet()) {
                Property prop2;
                size = ((Set)ancestors.get(indien)).size();
                ViewContext vc = new ViewContext((Entity)indien).setText(indien.getDisplayTitle(true) + " (" + size + ")").setCode(String.valueOf(size));
                Property prop1 = indien.getProperty("_SOSA");
                if (prop1 == null & (prop2 = indien.getProperty("_SOSADABOVILLE")) == null) {
                    vc.setColor(this.notSosaColor);
                }
                multipleancestors.add(vc);
                if (!settings.isMulti || !settings.toBeMarked) continue;
                str = settings.multiValue + " ";
                strMax = "";
                ctr = 0;
                ArrayList<String> ids = new ArrayList<String>();
                for (Fam fam2 : (Set)ancestors.get(indien)) {
                    ids.add(fam2.getId());
                    if (ctr++ <= 20) continue;
                    strMax = "...";
                    break;
                }
                Collections.sort(ids);
                for (String s : ids) {
                    str = (String)str + "(" + s + ")";
                }
                str = (String)str + strMax;
                indien.addProperty(settings.multiTag, (String)str);
            }
            this.setProgress(taskName + " 3/4", this.counter++);
            if (multipleancestors.isEmpty()) {
                implexes.add(new ViewContext(gedcom).setCode("0").setText(NbBundle.getMessage(MarkingAction.class, (String)"MarkingPanel.NoMultipleAncestorsFound")));
            }
            this.sortMarkers2(implexes);
            this.sortMarkers2(multipleancestors);
            this.setProgress(taskName + " 4/4", this.counter++);
        }

        private boolean addImplex(Fam fam, List<ViewContext> implexes, int NbOfCommonAncestors) {
            if (fam != null) {
                implexes.add(new ViewContext((Entity)fam).setText(fam.getDisplayFullNames(true) + " (" + NbOfCommonAncestors + ")").setAction((Action)new MarkedAction(fam)).setCode(String.valueOf(NbOfCommonAncestors)));
            }
            return false;
        }

        private int getNbOfCommonAncestor(Fam fam, Indi indi1, Indi indi2, HashMap<Indi, Set<Fam>> ancestors) {
            int ret = 0;
            if (indi1 == null || indi2 == null) {
                return 0;
            }
            HashSet<Indi> ancestorsOf1 = new HashSet<Indi>();
            this.getAllAncestors(indi1, ancestorsOf1);
            HashSet<Indi> ancestorsOf2 = new HashSet<Indi>();
            this.getAllAncestors(indi2, ancestorsOf2);
            for (Indi indien : ancestorsOf1) {
                if (!ancestorsOf2.contains(indien)) continue;
                Set<Fam> setOfFam = ancestors.get(indien);
                if (setOfFam == null) {
                    setOfFam = new HashSet<Fam>();
                    ancestors.put(indien, setOfFam);
                }
                setOfFam.add(fam);
                ++ret;
            }
            return ret;
        }

        private void getAllAncestors(Indi indi, Set<Indi> ancestors) {
            if (indi == null || ancestors.contains(indi)) {
                return;
            }
            ancestors.add(indi);
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam == null) {
                return;
            }
            this.getAllAncestors(fam.getHusband(), ancestors);
            this.getAllAncestors(fam.getWife(), ancestors);
        }

        private void getAllDescendants(Indi indi, Set<Indi> descendants) {
            Fam[] fams;
            if (indi == null || descendants.contains(indi)) {
                return;
            }
            descendants.add(indi);
            for (Fam fam : fams = indi.getFamiliesWhereSpouse()) {
                for (Indi child : fam.getChildren()) {
                    this.getAllDescendants(child, descendants);
                }
            }
        }

        private void getYDNALine(Indi indi, Set<Indi> YIndis) {
            Indi[] children;
            Indi husb;
            if (indi == null || YIndis.contains(indi)) {
                return;
            }
            YIndis.add(indi);
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam != null && (husb = fam.getHusband()) != null) {
                this.getYDNALine(husb, YIndis);
            }
            for (Indi child : children = indi.getChildren()) {
                if (child.getSex() != 1) continue;
                this.getYDNALine(child, YIndis);
            }
        }

        private void getmtDNALine(Indi indi, Set<Indi> mtIndis) {
            Indi[] children;
            Indi wife;
            if (indi == null || mtIndis.contains(indi)) {
                return;
            }
            mtIndis.add(indi);
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam != null && (wife = fam.getWife()) != null) {
                this.getmtDNALine(wife, mtIndis);
            }
            for (Indi child : children = indi.getChildren()) {
                if (child.getSex() == 2) {
                    this.getmtDNALine(child, mtIndis);
                    continue;
                }
                mtIndis.add(child);
            }
        }

        private void getXLine(Indi indi, Set<Indi> xIndis) {
            if (indi == null || xIndis.contains(indi)) {
                return;
            }
            xIndis.add(indi);
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam != null) {
                Indi wife;
                Indi husband;
                if (indi.getSex() == 2 && (husband = fam.getHusband()) != null) {
                    this.getXLine(husband, xIndis);
                }
                if ((wife = fam.getWife()) != null) {
                    this.getXLine(wife, xIndis);
                }
            }
        }

        private void markSearch(Gedcom gedcom, MarkingPanel.Settings settings, List<ViewContext> searchIndividuals, String taskName) {
            this.setProgress(taskName, this.counter);
            if (settings.toBeErased) {
                this.deleteTags(gedcom, "INDI", settings.searchTag);
            }
            this.setProgress(taskName + " 1/3", this.counter++);
            HashSet<Indi> indis = new HashSet<Indi>();
            HashSet<Fam> famSet = new HashSet<Fam>();
            Fam[] famArr = null;
            List entities = SearchCommunicator.getResultEntities((Gedcom)gedcom);
            switch (settings.searchOption) {
                case "SEARCH_PARENT_OF": {
                    for (Entity entity : entities) {
                        Set<Indi> subIndis = this.getIndis(entity);
                        for (Indi indien : subIndis) {
                            Indi wife;
                            Fam fam = indien.getFamilyWhereBiologicalChild();
                            if (fam == null) continue;
                            Indi husb = fam.getHusband();
                            if (husb != null) {
                                indis.add(husb);
                            }
                            if ((wife = fam.getWife()) == null) continue;
                            indis.add(wife);
                        }
                    }
                    break;
                }
                case "SEARCH_CHILD_OF": {
                    for (Entity entity : entities) {
                        Set<Fam> subFams = this.getFams(entity);
                        for (Fam fam : subFams) {
                            if (famSet.contains(fam)) continue;
                            famSet.add(fam);
                            indis.addAll(Arrays.asList(fam.getChildren()));
                        }
                    }
                    break;
                }
                case "SEARCH_SPOUSE_OF": {
                    for (Entity entity : entities) {
                        if (!(entity instanceof Indi)) continue;
                        Indi indien = (Indi)entity;
                        for (Fam fam : famArr = indien.getFamiliesWhereSpouse()) {
                            if (famSet.contains(fam)) continue;
                            famSet.add(fam);
                            Indi spouse = fam.getOtherSpouse(indien);
                            if (spouse == null || indis.contains(spouse)) continue;
                            indis.add(spouse);
                        }
                    }
                    break;
                }
                case "SEARCH_ANCESTOR_OF": {
                    for (Entity entity : entities) {
                        if (entity instanceof Indi && indis.contains((Indi)entity)) continue;
                        for (Indi indien : this.getIndis(entity)) {
                            this.getAllAncestors(indien, indis);
                        }
                    }
                    break;
                }
                case "SEARCH_DESCENDANT_OF": {
                    for (Entity entity : entities) {
                        if (entity instanceof Indi && indis.contains((Indi)entity)) continue;
                        for (Indi indien : this.getIndis(entity)) {
                            this.getAllDescendants(indien, indis);
                        }
                    }
                    break;
                }
                case "SEARCH_PATRILINE_OF": {
                    for (Entity entity : entities) {
                        if (entity instanceof Indi && indis.contains((Indi)entity)) continue;
                        for (Indi indien : this.getIndis(entity)) {
                            this.getYDNALine(indien, indis);
                        }
                    }
                    break;
                }
                case "SEARCH_MATRILINE_OF": {
                    for (Entity entity : entities) {
                        if (entity instanceof Indi && indis.contains((Indi)entity)) continue;
                        for (Indi indien : this.getIndis(entity)) {
                            this.getmtDNALine(indien, indis);
                        }
                    }
                    break;
                }
                case "SEARCH_XLINE_OF": {
                    for (Entity entity : entities) {
                        if (entity instanceof Indi && indis.contains((Indi)entity)) continue;
                        for (Indi indien : this.getIndis(entity)) {
                            this.getXLine(indien, indis);
                        }
                    }
                    break;
                }
                default: {
                    for (Entity entity : entities) {
                        indis.addAll(this.getIndis(entity));
                    }
                }
            }
            this.setProgress(taskName + " 2/3", this.counter++);
            for (Indi indien : indis) {
                ViewContext vc = new ViewContext((Entity)indien).setText(indien.toString(true));
                searchIndividuals.add(vc);
                if (!settings.isSearch || !settings.toBeMarked) continue;
                indien.addProperty(settings.searchTag, settings.searchValue);
            }
            this.sortMarkers(searchIndividuals);
            this.setProgress(taskName + " 3/3", this.counter++);
        }

        private void markView(Gedcom gedcom, MarkingPanel.Settings settings, List<ViewContext> viewsIndividuals, String taskName) {
            this.setProgress(taskName, this.counter);
            if (settings.toBeErased) {
                this.deleteTags(gedcom, "INDI", settings.viewsTag);
            }
            this.setProgress(taskName + " 1/2", this.counter++);
            ArrayList<Indi> indis = new ArrayList<Indi>();
            for (Filter f : AncestrisPlugin.lookupAll(Filter.class)) {
                if (!f.getFilterName().equals(settings.viewsOption)) continue;
                for (Indi indien : gedcom.getIndis()) {
                    if (f.veto((Entity)indien)) continue;
                    indis.add(indien);
                }
            }
            for (Indi indien : indis) {
                ViewContext vc = new ViewContext((Entity)indien).setText(indien.toString(true));
                viewsIndividuals.add(vc);
                if (!settings.isViews || !settings.toBeMarked) continue;
                boolean alreadyMarked = false;
                Property mark = indien.getProperty(settings.viewsTag);
                if (mark != null && settings.viewsValue.equals(mark.getValue())) {
                    alreadyMarked = true;
                }
                if (alreadyMarked) continue;
                indien.addProperty(settings.viewsTag, settings.viewsValue);
            }
            this.sortMarkers(viewsIndividuals);
            this.setProgress(taskName + " 2/2", this.counter++);
        }

        private Set<Indi> getIndis(Entity entity) {
            HashSet<Indi> ret = new HashSet<Indi>();
            if (entity instanceof Indi) {
                Indi indi1 = (Indi)entity;
                ret.add(indi1);
            } else if (entity instanceof Fam) {
                Indi wife;
                Fam fam = (Fam)entity;
                Indi husb = fam.getHusband();
                if (husb != null) {
                    ret.add(husb);
                }
                if ((wife = fam.getWife()) != null) {
                    ret.add(wife);
                }
            }
            return ret;
        }

        private Set<Fam> getFams(Entity entity) {
            HashSet<Fam> ret = new HashSet<Fam>();
            if (entity instanceof Fam) {
                Fam fam = (Fam)entity;
                ret.add(fam);
            } else if (entity instanceof Indi) {
                Fam[] fams;
                Indi indien = (Indi)entity;
                for (Fam fam : fams = indien.getFamiliesWhereSpouse()) {
                    if (fam == null) continue;
                    ret.add(fam);
                }
            }
            return ret;
        }

        private void deleteTags(Gedcom gedcom, String entityTag, String propertyTag) {
            for (Entity entity : gedcom.getEntities(entityTag)) {
                for (Property prop : entity.getProperties(propertyTag)) {
                    entity.delProperty(prop);
                }
            }
        }
    }

    private static class MarkedAction
    implements Action {
        private Fam fam = null;

        private MarkedAction(Fam fam) {
            this.fam = fam;
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonAncestorTopComponent.createInstance((Context)new Context((Entity)this.fam));
        }
    }
}

