/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import genj.util.AncestrisPreferences;
import genj.util.IRegistryStorage;
import genj.util.RegistryStorage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JFrame;

public class Registry
implements PropertyChangeListener,
AncestrisPreferences {
    private String prefix;
    private static Map<File, Registry> file2registry = new HashMap<File, Registry>();
    private static final Logger LOG = Logger.getLogger("ancestris");
    private IRegistryStorage storage = null;

    public Registry(Registry registry, String view) {
        if (registry.prefix.length() > 0) {
            view = registry.prefix + "." + (String)view;
        }
        this.prefix = view;
        this.storage = registry.storage;
    }

    protected Registry(IRegistryStorage preference) {
        this.storage = preference;
        this.prefix = "";
    }

    public Registry(InputStream in) {
        this.prefix = "";
        LOG.fine("set storage to input streams storage");
        this.storage = new RegistryStorage.Properties(in);
    }

    public Registry(File file) {
        this.prefix = "";
        LOG.fine("set storage to file storage");
        this.storage = new RegistryStorage.Properties(file);
    }

    public static Registry get(Object source) {
        return Registry.get(source.getClass());
    }

    public static Registry get(Class<?> source) {
        return new Registry(RegistryStorage.get(source));
    }

    public static Registry get(String pckg) {
        return new Registry(RegistryStorage.get(pckg));
    }

    public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        this.storage.addPreferenceChangeListener(pcl);
    }

    public void remove(String prefix) {
        this.storage.remove(prefix);
    }

    public Set<String> getProperties() {
        IRegistryStorage iRegistryStorage = this.storage;
        if (iRegistryStorage instanceof RegistryStorage.Properties) {
            RegistryStorage.Properties properties = (RegistryStorage.Properties)iRegistryStorage;
            return properties.getProperties().stringPropertyNames();
        }
        iRegistryStorage = this.storage;
        if (iRegistryStorage instanceof RegistryStorage.Preferences) {
            RegistryStorage.Preferences preferences = (RegistryStorage.Preferences)iRegistryStorage;
            return preferences.getProperties();
        }
        return null;
    }

    @Override
    public <K, V> Map<K, V> get(String key, Map<K, V> def) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K subkey : def.keySet()) {
            Object value = def.get(subkey);
            try {
                value = this.getClass().getMethod("get", String.class, value.getClass()).invoke((Object)this, key + "." + subkey, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            result.put(subkey, value);
        }
        return result;
    }

    @Override
    public int[] get(String key, int[] def) {
        int size = this.get(key, -1);
        if (size < 0) {
            return def;
        }
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.get(key + "." + (i + 1), -1);
        }
        return result;
    }

    @Override
    public Boolean[] get(String key, Boolean[] def) {
        int size = this.get(key, -1);
        if (size < 0) {
            return def;
        }
        Boolean[] result = new Boolean[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.get(key + "." + (i + 1), false);
        }
        return result;
    }

    @Override
    public Rectangle[] get(String key, Rectangle[] def) {
        int size = this.get(key, -1);
        if (size == -1) {
            return def;
        }
        Rectangle[] result = new Rectangle[size];
        Rectangle empty = new Rectangle(-1, -1, -1, -1);
        for (int i = 0; i < size; ++i) {
            result[i] = this.get(key + "." + (i + 1), empty);
        }
        return result;
    }

    @Override
    public String[] get(String key, String[] def) {
        int size = this.get(key, -1);
        if (size == -1) {
            return def;
        }
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.get(key + "." + (i + 1), "");
        }
        return result;
    }

    @Override
    public float get(String key, float def) {
        String result = this.get(key, (String)null);
        if (result == null) {
            return def;
        }
        try {
            return Float.parseFloat(result.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    @Override
    public int get(String key, int def) {
        String result = this.get(key, (String)null);
        if (result == null) {
            return def;
        }
        try {
            return Integer.parseInt(result.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    @Override
    public <T extends Enum<T>> T get(String key, T def) {
        String enumValue = this.get(key, (String)null);
        if (enumValue == null) {
            return def;
        }
        try {
            return Enum.valueOf(def.getDeclaringClass(), enumValue);
        }
        catch (Exception e) {
            return def;
        }
    }

    @Override
    public Dimension get(String key, Dimension def) {
        int w = this.get(key + ".w", -1);
        int h = this.get(key + ".h", -1);
        if (w == -1 || h == -1) {
            return def;
        }
        return new Dimension(w, h);
    }

    @Override
    public Font get(String key, Font def) {
        String face = this.get(key + ".name", (String)null);
        int style = this.get(key + ".style", -1);
        int size = this.get(key + ".size", -1);
        if (face == null || style == -1 || size == -1) {
            return def;
        }
        return new Font(face, style, size);
    }

    @Override
    public Point get(String key, Point def) {
        int x = this.get(key + ".x", Integer.MAX_VALUE);
        int y = this.get(key + ".y", Integer.MAX_VALUE);
        if (x == Integer.MAX_VALUE || y == Integer.MAX_VALUE) {
            return def;
        }
        return new Point(x, y);
    }

    @Override
    public Point2D get(String key, Point2D def) {
        float x = this.get(key + ".x", Float.NaN);
        float y = this.get(key + ".y", Float.NaN);
        if (Float.isNaN(x) || Float.isNaN(y)) {
            return def;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public Rectangle get(String key, Rectangle def) {
        int x = this.get(key + ".x", Integer.MAX_VALUE);
        int y = this.get(key + ".y", Integer.MAX_VALUE);
        int w = this.get(key + ".w", Integer.MAX_VALUE);
        int h = this.get(key + ".h", Integer.MAX_VALUE);
        if (x == Integer.MAX_VALUE || y == Integer.MAX_VALUE || w == Integer.MAX_VALUE || h == Integer.MAX_VALUE) {
            return def;
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public List<String> get(String key, List<String> def) {
        int size = this.get(key, -1);
        if (size == -1) {
            return def;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            result.add(this.get(key + "." + (i + 1), ""));
        }
        return result;
    }

    @Override
    public boolean get(String key, boolean def) {
        String result = this.get(key, (String)null);
        if (result == null) {
            return def;
        }
        if (result.equals("1") || result.equals("true")) {
            return true;
        }
        if (result.equals("0") || result.equals("false")) {
            return false;
        }
        return def;
    }

    @Override
    public Color get(String key, Color def) {
        int result = this.get(key, Integer.MAX_VALUE);
        if (result == Integer.MAX_VALUE) {
            return def;
        }
        return new Color(result);
    }

    @Override
    public String get(String key, String def) {
        LOG.log(Level.FINER, "get registry key {0}", key);
        return this.storage.get(key, def);
    }

    @Override
    public void put(String key, String value) {
        LOG.log(Level.FINER, "put registry key {0}={1}", new String[]{key, value});
        this.storage.put(key, value);
    }

    public File get(String key, File def) {
        String path = this.get(key, (String)null);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public void put(String key, File value) {
        if (value != null) {
            this.put(key, value.getAbsolutePath());
        } else {
            this.put(key, (String)null);
        }
    }

    @Override
    public void put(String key, Map<String, ?> values) {
        for (String subkey : values.keySet()) {
            Object value = values.get(subkey);
            try {
                value = this.getClass().getMethod("put", String.class, value.getClass()).invoke((Object)this, key + "." + subkey, value);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void put(String key, int[] value) {
        int l = value.length;
        this.put(key, l);
        for (int i = 0; i < l; ++i) {
            this.put(key + "." + (i + 1), "" + value[i]);
        }
    }

    @Override
    public void put(String key, Rectangle[] value) {
        int l = value.length;
        this.put(key, "" + l);
        for (int i = 0; i < l; ++i) {
            this.put(key + "." + (i + 1), value[i]);
        }
    }

    @Override
    public void put(String key, Object[] value) {
        this.put(key, value, value.length);
    }

    @Override
    public void put(String key, Object[] value, int length) {
        int l = Math.min(value.length, length);
        this.put(key, "" + l);
        for (int i = 0; i < l; ++i) {
            this.put(key + "." + (i + 1), value[i].toString());
        }
    }

    @Override
    public void put(String key, float value) {
        this.put(key, "" + value);
    }

    @Override
    public void put(String key, int value) {
        this.put(key, "" + value);
    }

    @Override
    public void put(String key, Enum value) {
        this.put(key, value.name());
    }

    @Override
    public void put(String key, Dimension value) {
        this.put(key + ".w", value.width);
        this.put(key + ".h", value.height);
    }

    @Override
    public void put(String key, Font value) {
        this.put(key + ".name", value.getName());
        this.put(key + ".style", value.getStyle());
        this.put(key + ".size", value.getSize());
    }

    @Override
    public void put(String key, Point value) {
        this.put(key + ".x", value.x);
        this.put(key + ".y", value.y);
    }

    @Override
    public void put(String key, Point2D value) {
        this.put(key + ".x", (float)value.getX());
        this.put(key + ".y", (float)value.getY());
    }

    @Override
    public void put(String key, Rectangle value) {
        this.put(key + ".x", value.x);
        this.put(key + ".y", value.y);
        this.put(key + ".w", value.width);
        this.put(key + ".h", value.height);
    }

    @Override
    public void put(String key, Collection<?> values) {
        if (values == null) {
            this.put(key, (String)null);
            return;
        }
        int l = values.size();
        this.put(key, l);
        Iterator<?> elements = values.iterator();
        int i = 0;
        while (elements.hasNext()) {
            this.put(key + "." + (i + 1), elements.next().toString());
            ++i;
        }
    }

    @Override
    public Collection<String> get(String key, Collection<String> def) {
        Collection result;
        int size = this.get(key, -1);
        if (size == -1) {
            return def;
        }
        if (def == null) {
            def = new HashSet<String>();
        }
        try {
            result = (Collection)def.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            return def;
        }
        for (int i = 0; i < size; ++i) {
            result.add(this.get(key + "." + (i + 1), ""));
        }
        return result;
    }

    @Override
    public void put(String key, Boolean value) {
        this.put(key, value != false ? "1" : "0");
    }

    @Override
    public void put(String key, Color value) {
        this.put(key, value.getRGB());
    }

    public static void persist() {
        for (File file : file2registry.keySet()) {
            Registry registry = file2registry.get(file);
            registry.storage.persist();
        }
    }

    @Override
    public void put(String key, JFrame frame) {
        boolean maximized;
        Rectangle bounds = frame.getBounds();
        boolean bl = maximized = frame.getExtendedState() == 6;
        if (bounds != null && !maximized) {
            this.put(key, bounds);
        }
        this.put(key + ".maximized", maximized);
    }

    @Override
    public JFrame get(String key, JFrame frame) {
        frame.setBounds(this.get(key, new Rectangle(0, 0, 640, 480)));
        if (this.get(key + ".maximized", true)) {
            frame.setExtendedState(6);
        }
        return frame;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        Object val = evt.getNewValue();
        if (val == null) {
            this.remove(key);
            return;
        }
        try {
            this.getClass().getMethod("put", String.class, val.getClass()).invoke((Object)this, key, val);
        }
        catch (Throwable t) {
            this.put(key, val.toString());
        }
    }
}

