/*
 * Decompiled with CFR 0.152.
 */
package spin.demo.progress;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import spin.demo.Assert;
import spin.demo.progress.ProgressBean;

public class ProgressBeanImpl
implements ProgressBean {
    private PropertyChangeListener listener;
    private boolean cancelled;
    private double status;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Assert.offEDT();
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Assert.offEDT();
        this.cancelled = false;
        this.status = 0.0;
        for (int i = 0; i < 10; ++i) {
            try {
                ProgressBeanImpl progressBeanImpl = this;
                synchronized (progressBeanImpl) {
                    this.wait(1000L);
                }
                Double oldValue = new Double(this.status);
                this.status += 0.1;
                Double newValue = new Double(this.status);
                if (this.listener != null) {
                    this.listener.propertyChange(new PropertyChangeEvent(this, "value", oldValue, newValue));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.cancelled) break;
        }
    }

    public void cancel() {
        Assert.offEDT();
        this.cancelled = true;
    }

    public double getStatus() {
        Assert.offEDT();
        return this.status;
    }
}

