/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ReleveSynthesisDialog
extends JDialog {
    private JButton jButtonClipboard;
    private JButton jButtonClose;
    private JPanel jPanelButtons;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaSynthesis;

    public static void show(String title, String recordSynthesis) {
        ReleveSynthesisDialog dialog = new ReleveSynthesisDialog((Frame)new JFrame(), false);
        dialog.setTitle(title);
        dialog.jTextAreaSynthesis.setText(recordSynthesis);
        dialog.setVisible(true);
    }

    public ReleveSynthesisDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.loadDialogBounds();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReleveSynthesisDialog.this.saveDialogBounds();
                ReleveSynthesisDialog.this.setVisible(false);
                ReleveSynthesisDialog.this.dispose();
            }
        });
    }

    private void loadDialogBounds() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        String size = NbPreferences.forModule(ReleveSynthesisDialog.class).get("ReleveSynthesisDialogSize", "400,300,0,0");
        String[] dimensions = size.split(",");
        if (dimensions.length >= 4) {
            int width = Integer.parseInt(dimensions[0]);
            int height = Integer.parseInt(dimensions[1]);
            int x = Integer.parseInt(dimensions[2]);
            int y = Integer.parseInt(dimensions[3]);
            if (width < 100) {
                width = 100;
            }
            if (height < 100) {
                height = 100;
            }
            if (x < 10 || x > screen.width - 10) {
                x = screen.width / 2 - width / 2;
            }
            if (y < 10 || y > screen.height - 10) {
                y = screen.height / 2 - height / 2;
            }
            this.setBounds(x, y, width, height);
        } else {
            this.setBounds(screen.width / 2 - 100, screen.height / 2 - 100, 300, 450);
        }
    }

    private void saveDialogBounds() {
        String size = String.valueOf((int)this.getBounds().getWidth()) + "," + String.valueOf((int)this.getBounds().getHeight()) + "," + String.valueOf(this.getBounds().getLocation().x + "," + String.valueOf(this.getBounds().getLocation().y));
        NbPreferences.forModule(ReleveSynthesisDialog.class).put("ReleveSynthesisDialogSize", size);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaSynthesis = new JTextArea();
        this.jPanelButtons = new JPanel();
        this.jButtonClipboard = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTextAreaSynthesis.setColumns(20);
        this.jTextAreaSynthesis.setLineWrap(true);
        this.jTextAreaSynthesis.setRows(5);
        this.jTextAreaSynthesis.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTextAreaSynthesis);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonClipboard, (String)NbBundle.getMessage(ReleveSynthesisDialog.class, (String)"ReleveSynthesisDialog.jButtonClipboard.text"));
        this.jButtonClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveSynthesisDialog.this.jButtonClipboardActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonClipboard);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonClose, (String)NbBundle.getMessage(ReleveSynthesisDialog.class, (String)"ReleveSynthesisDialog.jButtonClose.text"));
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReleveSynthesisDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanelButtons.add(this.jButtonClose);
        this.getContentPane().add((Component)this.jPanelButtons, "South");
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.saveDialogBounds();
        this.dispose();
    }

    private void jButtonClipboardActionPerformed(ActionEvent evt) {
        Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
        CLIPBOARD.setContents(new StringSelection(this.jTextAreaSynthesis.getText()), null);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ReleveSynthesisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ReleveSynthesisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ReleveSynthesisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ReleveSynthesisDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReleveSynthesisDialog dialog = new ReleveSynthesisDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

