/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldPicture;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public class BeanFreeComment
extends Bean {
    private final JTextField editor = new JTextField();

    public BeanFreeComment() {
        this.setLayout(new BorderLayout());
        JSpinner spinner = new JSpinner();
        spinner.setEditor(this.editor);
        spinner.setModel(new PictureNameModel(this.editor));
        this.add((Component)spinner, "Center");
        this.editor.getDocument().addDocumentListener((DocumentListener)this.changeSupport);
        this.editor.setMargin(new Insets(0, 0, 0, 0));
        this.defaultFocus = spinner;
    }

    @Override
    public void setFieldImpl() {
        final FieldPicture property = (FieldPicture)this.getField();
        if (property == null) {
            this.editor.setText("");
        } else {
            String txt = property.toString();
            this.editor.setText(txt);
        }
        this.changeSupport.setChanged(false);
        this.resetKeyboardActions();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(1).put(escape, this);
        this.getActionMap().put(this, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeanFreeComment.this.editor.setText(property.toString());
            }
        });
    }

    @Override
    protected void replaceValueImpl(Field field) {
        if (field == null) {
            this.editor.setText("");
        } else {
            this.editor.setText(field.toString());
        }
    }

    @Override
    protected void commitImpl() {
        String value = this.editor.getText().trim();
        this.setFieldValue(value);
        this.editor.setText(value);
    }

    private class PictureNameModel
    implements SpinnerModel {
        JTextField editor;

        PictureNameModel(JTextField editor) {
            this.editor = editor;
        }

        @Override
        public Object getValue() {
            return this.editor.getText();
        }

        @Override
        public void setValue(Object value) {
            this.editor.setText(value.toString());
        }

        @Override
        public Object getNextValue() {
            int i;
            String value = this.editor.getText();
            for (i = value.length() - 1; i >= 0 && value.charAt(i) >= '0' && value.charAt(i) <= '9'; --i) {
            }
            String format = String.format("%%s%%0%dd", value.length() - ++i);
            if (i < value.length()) {
                int num = Integer.parseInt(value.substring(i, value.length())) + 1;
                value = String.format(format, value.substring(0, i), num);
            }
            return value;
        }

        @Override
        public Object getPreviousValue() {
            int num;
            int i;
            String value = this.editor.getText();
            for (i = value.length() - 1; i >= 0 && value.charAt(i) >= '0' && value.charAt(i) <= '9'; --i) {
            }
            String format = String.format("%%s%%0%dd", value.length() - ++i);
            if (i < value.length() && (num = Integer.parseInt(value.substring(i, value.length())) - 1) >= 0) {
                value = String.format(format, value.substring(0, i), num);
            }
            return value;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }
}

