/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.HashSet;
import org.graphstream.algorithm.generator.BaseGenerator;

public class LCFGenerator
extends BaseGenerator {
    private int n;
    private int initialRingSize;
    private HashSet<String> crossed;
    protected LCF lcf;
    protected boolean canBeExtended;

    public LCFGenerator(LCF lcf, int initialRingSize, boolean canBeExtended) {
        this.lcf = lcf;
        this.crossed = new HashSet();
        this.initialRingSize = initialRingSize;
        this.canBeExtended = canBeExtended;
    }

    @Override
    public void begin() {
        this.addNode(this.getNodeId(0));
        this.addNode(this.getNodeId(1));
        this.addNode(this.getNodeId(2));
        this.addEdge(this.getEdgeId(0, 1), this.getNodeId(0), this.getNodeId(1));
        this.addEdge(this.getEdgeId(1, 2), this.getNodeId(1), this.getNodeId(2));
        this.addEdge(this.getEdgeId(2, 0), this.getNodeId(2), this.getNodeId(0));
        for (int i = this.n = 3; i < this.initialRingSize; ++i) {
            this.increaseRing();
        }
        this.flushCoords();
        this.makeLCF();
    }

    @Override
    public boolean nextEvents() {
        if (this.canBeExtended) {
            this.increaseRing();
            this.makeLCF();
            this.flushCoords();
        }
        return this.canBeExtended;
    }

    protected void increaseRing() {
        this.addNode(this.getNodeId(this.n));
        this.delEdge(this.getEdgeId(this.n - 1, 0));
        this.addEdge(this.getEdgeId(this.n - 1, this.n), this.getNodeId(this.n - 1), this.getNodeId(this.n));
        this.addEdge(this.getEdgeId(this.n, 0), this.getNodeId(this.n), this.getNodeId(0));
        ++this.n;
    }

    protected void makeLCF() {
        int i = 0;
        HashSet<String> added = new HashSet<String>();
        for (int r = 0; r < this.lcf.repeat && i < this.n; ++r) {
            for (int k = 0; k < this.lcf.steps.length && i < this.n; ++i, ++k) {
                int j;
                for (j = (i + this.lcf.steps[k]) % this.n; j < 0; j += this.n) {
                }
                String edge2 = this.getEdgeId(i, j);
                if (!this.crossed.contains(edge2) && !added.contains(edge2)) {
                    this.addEdge(edge2, this.getNodeId(i), this.getNodeId(j));
                }
                added.add(edge2);
            }
        }
        this.crossed.stream().filter(edge -> !added.contains(edge)).forEach(edge -> this.delEdge((String)edge));
        this.crossed.clear();
        this.crossed = added;
    }

    protected void flushCoords() {
        double d = Math.PI * 2 / (double)this.n;
        for (int i = 0; i < this.n; ++i) {
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i), "x", null, Math.cos((double)i * d));
            this.sendNodeAttributeChanged(this.sourceId, this.getNodeId(i), "y", null, Math.sin((double)i * d));
        }
    }

    protected String getNodeId(int i) {
        return String.format("%03d", i);
    }

    protected String getEdgeId(int i1, int i2) {
        if (i1 > i2) {
            int t = i1;
            i1 = i2;
            i2 = t;
        }
        return String.format("%03d_%03d", i1, i2);
    }

    public static class LCF {
        int repeat;
        int[] steps;

        public LCF(int repeat, int ... steps) {
            this.repeat = repeat;
            this.steps = steps;
        }
    }
}

