/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.measure;

import org.graphstream.algorithm.measure.ChartMeasure;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class ChartSeriesMeasure
extends ChartMeasure {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    protected XYSeries series;

    public ChartSeriesMeasure(String name) {
        super(name);
        this.series = new XYSeries((Comparable)((Object)name));
        this.series.setMaximumItemCount(100);
    }

    public XYSeries getXYSeries() {
        return this.series;
    }

    public void setWindowSize(int size) {
        this.series.setMaximumItemCount(size);
    }

    @Override
    public void plot(ChartMeasure.PlotParameters params) throws ChartMeasure.PlotException {
        ChartSeriesMeasure.outputPlot(params, this.createChart(params));
    }

    @Override
    public ChartMeasure.PlotParameters getDefaultPlotParameters() {
        ChartMeasure.PlotParameters params = new ChartMeasure.PlotParameters();
        params.title = this.name;
        params.type = ChartMeasure.PlotType.LINE;
        return params;
    }

    @Override
    public JFreeChart createChart(ChartMeasure.PlotParameters params) throws ChartMeasure.PlotException {
        JFreeChart chart;
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(this.getXYSeries());
        switch (params.type) {
            case LINE: {
                chart = ChartFactory.createXYLineChart((String)params.title, (String)params.xAxisLabel, (String)params.yAxisLabel, (XYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            case BAR: {
                chart = ChartFactory.createXYBarChart((String)params.title, (String)params.xAxisLabel, (boolean)false, (String)params.yAxisLabel, (IntervalXYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            case SCATTER: {
                chart = ChartFactory.createScatterPlot((String)params.title, (String)params.xAxisLabel, (String)params.yAxisLabel, (XYDataset)dataset, (PlotOrientation)params.orientation, (boolean)params.showLegend, (boolean)false, (boolean)false);
                break;
            }
            default: {
                throw new ChartMeasure.PlotException("unsupported plot type");
            }
        }
        return chart;
    }
}

