/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.ICheckListAction;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCheckListModel<T>
implements ICheckListModel<T> {
    private final List<ListDataListener> listeners = Collections.synchronizedList(new ArrayList());
    private final ICheckListModel<T> originalModel;
    private final ICheckListAction<T> actionCheckAll = new ICheckListAction.CheckAll();
    private final List<ICheckListAction<T>> actionItems = Arrays.asList(this.actionCheckAll);
    private final Set<ICheckListAction<T>> checks = new HashSet<ICheckListAction<T>>();

    public ActionCheckListModel(final ICheckListModel<T> iCheckListModel) {
        if (iCheckListModel == null) {
            throw new NullPointerException();
        }
        this.originalModel = iCheckListModel;
        this.originalModel.addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
                ListDataEvent listDataEvent2 = ActionCheckListModel.this.toDecoratedEvent(listDataEvent);
                for (ListDataListener listDataListener : ActionCheckListModel.this.listeners) {
                    listDataListener.intervalAdded(listDataEvent2);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                ListDataEvent listDataEvent2 = ActionCheckListModel.this.toDecoratedEvent(listDataEvent);
                for (ListDataListener listDataListener : ActionCheckListModel.this.listeners) {
                    listDataListener.intervalRemoved(listDataEvent2);
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                ListDataEvent listDataEvent2 = ActionCheckListModel.this.toDecoratedEvent(listDataEvent);
                for (ListDataListener listDataListener : ActionCheckListModel.this.listeners) {
                    listDataListener.contentsChanged(listDataEvent2);
                }
                if (iCheckListModel.getCheckedItems().size() < iCheckListModel.getSize()) {
                    ActionCheckListModel.this.checks.remove(ActionCheckListModel.this.actionCheckAll);
                } else {
                    ActionCheckListModel.this.checks.add(ActionCheckListModel.this.actionCheckAll);
                }
                ActionCheckListModel.this.fireListDataChanged();
            }
        });
    }

    @Override
    public int getSize() {
        return this.originalModel.getSize() + this.actionItems.size();
    }

    public Object getElementAt(int n) {
        if (this.isDecoratedIndex(n)) {
            return this.actionItems.get(n);
        }
        return this.originalModel.getElementAt(this.toOriginalIndex(n));
    }

    private int toOriginalIndex(int n) {
        return n - this.actionItems.size();
    }

    private int toDecoratedIndex(int n) {
        return n + this.actionItems.size();
    }

    private boolean isDecoratedIndex(int n) {
        int n2 = this.actionItems.size();
        return n2 > 0 && n >= 0 && n < n2;
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    private void fireListDataChanged() {
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize());
        for (ListDataListener listDataListener : this.listeners) {
            listDataListener.contentsChanged(listDataEvent);
        }
    }

    private ListDataEvent toDecoratedEvent(ListDataEvent listDataEvent) {
        return new ListDataEvent(listDataEvent.getSource(), listDataEvent.getType(), this.toDecoratedIndex(listDataEvent.getIndex0()), this.toDecoratedIndex(listDataEvent.getIndex1()));
    }

    @Override
    public boolean isCheckedIndex(int n) {
        if (this.isDecoratedIndex(n)) {
            return this.checks.contains(this.actionItems.get(n));
        }
        return this.originalModel.isCheckedIndex(this.toOriginalIndex(n));
    }

    @Override
    public void setCheckedIndex(int n, boolean bl) {
        if (this.isDecoratedIndex(n)) {
            ICheckListAction<T> iCheckListAction = this.actionItems.get(n);
            iCheckListAction.check(this.originalModel, bl);
            if (bl) {
                this.checks.add(iCheckListAction);
            } else {
                this.checks.remove(iCheckListAction);
            }
            this.fireListDataChanged();
        } else {
            this.originalModel.setCheckedIndex(this.toOriginalIndex(n), bl);
        }
    }

    @Override
    public Collection<T> getCheckedItems() {
        return this.originalModel.getCheckedItems();
    }

    @Override
    public void setCheckedItems(Collection<T> collection) {
        this.originalModel.setCheckedItems(collection);
    }

    @Override
    public void filter(String string, IObjectToStringTranslator iObjectToStringTranslator, CheckListFilterType checkListFilterType) {
        this.originalModel.filter(string, iObjectToStringTranslator, checkListFilterType);
    }
}

