/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.oxbow.swingbits.list.ICheckListModel;

final class CheckListEditor
extends MouseAdapter {
    CheckListEditor() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        JList jList = (JList)mouseEvent.getSource();
        if (!jList.isEnabled() || !(jList.getModel() instanceof ICheckListModel)) {
            return;
        }
        int n = jList.locationToIndex(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        Rectangle rectangle = jList.getCellBounds(n, n);
        if (rectangle.contains(mouseEvent.getPoint())) {
            ICheckListModel iCheckListModel = (ICheckListModel)jList.getModel();
            if (mouseEvent.getClickCount() > 1) {
                iCheckListModel.setCheckedItems(Arrays.asList(iCheckListModel.getElementAt(n)));
            } else {
                iCheckListModel.setCheckedIndex(n, !iCheckListModel.isCheckedIndex(n));
            }
            mouseEvent.consume();
        }
    }
}

