/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.oxbow.swingbits.table.TableHeaderRenderer;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.util.swing.CompoundIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterTableHeaderRenderer
extends TableHeaderRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon;
    private final ITableFilter<?> tableFilter;
    private boolean rendererInit = true;
    private int originalHorizontalTextPosition;

    public FilterTableHeaderRenderer(ITableFilter<?> iTableFilter) {
        this.tableFilter = iTableFilter;
    }

    private Icon getFilterIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(this.getClass().getResource("funnel.png"));
            this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(12, 12, 4));
        }
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        int n3;
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (this.rendererInit) {
            this.originalHorizontalTextPosition = jLabel.getHorizontalTextPosition();
            this.rendererInit = false;
        }
        if (this.tableFilter.isFiltered(n3 = jTable.convertColumnIndexToModel(n2))) {
            Icon icon = jLabel.getIcon();
            if (icon == null) {
                jLabel.setIcon(this.getFilterIcon());
            } else {
                jLabel.setIcon(new CompoundIcon(this.getFilterIcon(), icon));
            }
            jLabel.setHorizontalTextPosition(11);
        } else {
            jLabel.setHorizontalTextPosition(this.originalHorizontalTextPosition);
        }
        return jLabel;
    }
}

