/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.imports.wizard;

import ancestris.api.imports.Import;
import ancestris.modules.imports.wizard.ImportVisualImport;
import ancestris.modules.imports.wizard.ImportWizardImport;
import ancestris.modules.imports.wizard.ImportWizardWarning;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class ImportWizardAction
extends CallableSystemAction {
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;

    public void performAction() {
        WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels());
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(ImportWizardAction.class, (String)"ImportWizardAction.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        ImportVisualImport importPanel = null;
        try {
            importPanel = (ImportVisualImport)this.panels[1].getComponent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cancelled && importPanel != null && importPanel.getInputFile() != null) {
            Import importMethod = importPanel.getImportClass();
            if (importMethod == null) {
                return;
            }
            File inputFile = importPanel.getInputFile();
            File outFile = new File(inputFile.getParent() + System.getProperty("file.separator") + inputFile.getName().replaceFirst("[.][^.]+$", "") + "_ancestris.ged");
            importMethod.launch(inputFile, outFile);
        }
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ImportWizardWarning(), new ImportWizardImport()};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public String getName() {
        return NbBundle.getMessage(ImportWizardAction.class, (String)"ImportWizardAction.title");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

