/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook.creator;

import ancestris.modules.webbook.WebBook;
import ancestris.modules.webbook.WebBookParams;
import ancestris.modules.webbook.creator.WebHelper;
import ancestris.modules.webbook.creator.WebSection;
import java.io.File;
import java.io.PrintWriter;

public class WebCities
extends WebSection {
    public WebCities(boolean generate, WebBook wb, WebBookParams wp, WebHelper wh) {
        super(generate, wb, wp, wh);
    }

    public void init() {
        this.init(this.trs("TXT_Citieslist"), "cities", "cities", "", 1, 0);
    }

    @Override
    public void create() {
        File dir = this.wh.createDir(this.wh.getDir().getAbsolutePath() + File.separator + this.sectionDir, true);
        File file = this.wh.getFileForName(dir, this.sectionPrefix + this.sectionSuffix);
        PrintWriter out = this.wh.getWriter(file, this.UTF8);
        this.printOpenHTML(out, "TXT_Citieslist", this);
        this.calcLetters();
        this.exportData(dir, out);
        this.printLinks(out, this.sectionPrefix + this.sectionSuffix, this);
        this.printCloseHTML(out);
        out.close();
        this.wh.log.write(this.sectionPrefix + this.sectionSuffix + this.trs("EXEC_DONE"));
    }

    private void exportData(File dir, PrintWriter out) {
        out.println("<p class='letters'>");
        out.println("<br /><br />");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            if (this.checkLink(l.toString())) {
                out.println("<a href=\"#" + l + "\">" + l + "</a>&nbsp;&nbsp;");
                continue;
            }
            out.println(l + "&nbsp;&nbsp;");
        }
        if (this.checkLink("_")) {
            out.println("<a href=\"#_\">_</a>&nbsp;&nbsp;");
        } else {
            out.println("_&nbsp;&nbsp;");
        }
        out.println("</p>");
        this.printLinks(out, this.sectionPrefix + this.sectionSuffix, this);
        char last = ' ';
        int cpt = 1;
        int iNames = 1;
        out.println("<p class=\"nameblock\">");
        for (String name : this.wh.getCities(this.wh.gedcom)) {
            String anchor = this.htmlAnchorText(name);
            char tmpChar = anchor.toUpperCase(this.wh.gedcom.getLocale()).charAt(0);
            if (anchor.length() > 0 && tmpChar != last) {
                last = tmpChar;
                String l = String.valueOf(last);
                out.println("</p>");
                out.println("<p class=\"char\">");
                out.println("<a id=\"" + l + "\"></a>");
                out.println(l + "<br /></p>");
                cpt = 1;
                out.println("<p class=\"nameblock\">");
            }
            String listfile = this.buildLink(this, this.wb.sectionCitiesDetails, iNames);
            out.print("<span class=\"name\">");
            out.print("<a href=\"" + listfile + "#" + anchor + "\">" + this.htmlText(this.wh.getCityDisplayName(name)) + "</a>&nbsp;");
            out.print("<span class=\"occu\">(" + this.wh.getCitiesCount(name) + ")</span>");
            out.print("</span>&nbsp;&nbsp;&nbsp;");
            ++iNames;
            if (++cpt <= 7) continue;
            out.print("<br />");
            cpt = 1;
        }
        out.println("</p>");
    }

    private void calcLetters() {
        this.linkForLetter.put("_", "0");
        for (WebSection.Letters l : WebSection.Letters.values()) {
            this.linkForLetter.put(l.toString(), "0");
        }
        for (String name : this.wh.getCities(this.wh.gedcom)) {
            String l = name.length() > 0 ? name.substring(0, 1).toUpperCase(this.wh.gedcom.getLocale()) : "_";
            try {
                WebSection.Letters.valueOf(l);
            }
            catch (IllegalArgumentException e) {
                l = "_";
            }
            this.linkForLetter.put(l, "1");
        }
    }

    private boolean checkLink(String str) {
        String flag = (String)this.linkForLetter.get(str);
        return flag != null && flag.compareTo("0") != 0;
    }
}

